// Generated by CoffeeScript 1.4.0
(function() {
  var upload, url;

  upload = function(files, callback) {
    var file, reader;
    file = files[0];
    if (!file) {
      return;
    }
    reader = new FileReader();
    $('#upload').attr('disabled', true);
    reader.onload = function(ev) {
      $('#upload').attr('disabled', false);
      return window.location = url(file.name.split('.')[0], base64.encode(ev.target.result).replace(/[+\/=]/g, function(m) {
        switch (m) {
          case '+':
            return '-';
          case '/':
            return '_';
          case '=':
            return '';
        }
      }));
    };
    return reader.readAsBinaryString(file);
  };

  url = function(name, replay, format, scheme) {
    if (format == null) {
      format = '';
    }
    if (scheme == null) {
      scheme = 'http';
    }
    return "" + scheme + "://my-card.in/duels/new" + format + "?name=" + (encodeURIComponent(name)) + "&replay=" + replay;
  };

  $(document).ready(function() {
    var name, replay, template;
    if ($.url().param('replay')) {
      template = Handlebars.compile($('#duel-template').html());
      name = $.url().param('name');
      replay = $.url().param('replay');
      $('#duel').html(template({
        name: name,
        url_yrp: url(name, replay, '.yrp'),
        url_mycard: url(name, replay, '.yrp', 'mycard') + ("&name=" + (encodeURIComponent(name)) + ".yrp")
      }));
    }
    return $('#upload').change(function() {
      return upload(this.files);
    });
  });

}).call(this);
