// Generated by CoffeeScript 1.6.3
(function() {
  var login, matched, room, url;

  login = function(username, password) {
    $('#username').html(username);
    $('#login').hide();
    $('#userinfo').show();
    $('#need_login').hide();
    return $('#join').show();
  };

  $('#logout').click(function() {
    $.cookie('username', '');
    $.cookie('password', '');
    return window.location.reload();
  });

  $('#login').submit(function() {
    $.cookie('username', this.username.value);
    $.cookie('password', this.password.value);
    login($.cookie('username'), $.cookie('password'));
    return false;
  });

  matched = window.location.href.match(/\/(?:(.*?)(?::(.*?))?@)?([\d\.]+)\:(\d+)(?:\/(.*))?/);

  if (matched === null) {
    alert("解析房间信息失败");
    throw window.location.href;
  }

  url = $.url('mycard:/' + matched[0]);

  room = _.string.ltrim(url.attr('path'), '/').split('$');

  room = {
    name: decodeURIComponent(room[0]),
    password: room[1] ? decodeURIComponent(room[1]) : void 0,
    _private: url.param('private'),
    server: {
      ip: url.attr('host'),
      port: url.attr('port'),
      auth: !!url.param('server_auth')
    }
  };

  $('#name').html(room.name);

  if (room.password) {
    $('#show_password').html(room.password);
    $('#show_password_wrapper').show();
  } else if (room._private) {
    $('#input_password').change(function() {
      return room.password = this.value;
    });
    $('#input_password_wrapper').show();
  }

  $('#server_ip').html(room.server.ip);

  $('#server_port').html(room.server.port);

  $('#server_auth').html(room.server.auth.toString());

  if (room.server.auth && !($.cookie('username') && $.cookie('password'))) {
    $('#join').hide();
    $('#need_login').show();
  }

  if ($.cookie('username') && $.cookie('password')) {
    login($.cookie('username'), $.cookie('password'));
  }

  $('#join').click(function() {
    return mycard.join(room.server.ip, room.server.port, mycard.room_name(room.name, room.password), $.cookie('username'), (room.server.auth ? $.cookie('password') : void 0));
  });

}).call(this);

/*
//@ sourceMappingURL=room_show.map
*/
