let publicPath = 'https://cdn02.moecube.com:444/accounts/';

const API_ROOT = {
  development: 'https://sapi.moecube.com:444/accounts',
  test: 'http://114.215.243.95:8082',
  production: 'https://sapi.moecube.com:444/accounts'
};

let defineConf = {
  apiRoot: API_ROOT[process.env['ENV']],
};

export default {
  'entry': 'src/index.js',
  publicPath,
  define: { ...defineConf },
  'env': {
    'development': {
      'extraBabelPlugins': [
        'dva-hmr',
        'transform-runtime',
        'babel-plugin-transform-decorators-legacy',
        ['import', { 'libraryName': 'antd', 'style': 'css' }]
      ]
    },
    'production': {
      'extraBabelPlugins': [
        'babel-plugin-transform-decorators-legacy',
        'transform-runtime',
        ['import', { 'libraryName': 'antd', 'style': 'css' }]
      ]
    }
  }
};
