/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Locale;
import org.jsoup.UncheckedIOException;
import org.jsoup.helper.Validate;

public final class CharacterReader {
    static final char EOF = '\uffff';
    private static final int maxStringCacheLen = 12;
    static final int maxBufferLen = 32768;
    private static final int readAheadLimit = 24576;
    private final char[] charBuf;
    private final Reader reader;
    private int bufLength;
    private int bufSplitPoint;
    private int bufPos;
    private int readerPos;
    private int bufMark = -1;
    private final String[] stringCache = new String[512];
    private static final int numNullsConsideredBinary = 10;

    public CharacterReader(Reader input2, int sz) {
        Validate.notNull(input2);
        Validate.isTrue(input2.markSupported());
        this.reader = input2;
        this.charBuf = new char[sz > 32768 ? 32768 : sz];
        this.bufferUp();
        if (this.isBinary()) {
            throw new UncheckedIOException("Input is binary and unsupported");
        }
    }

    public CharacterReader(Reader input2) {
        this(input2, 32768);
    }

    public CharacterReader(String input2) {
        this(new StringReader(input2), input2.length());
    }

    private void bufferUp() {
        int pos = this.bufPos;
        if (pos < this.bufSplitPoint) {
            return;
        }
        try {
            this.reader.skip(pos);
            this.reader.mark(32768);
            int read2 = this.reader.read(this.charBuf);
            this.reader.reset();
            if (read2 != -1) {
                this.bufLength = read2;
                this.readerPos += pos;
                this.bufPos = 0;
                this.bufMark = -1;
                this.bufSplitPoint = this.bufLength > 24576 ? 24576 : this.bufLength;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int pos() {
        return this.readerPos + this.bufPos;
    }

    public boolean isEmpty() {
        this.bufferUp();
        return this.bufPos >= this.bufLength;
    }

    private boolean isEmptyNoBufferUp() {
        return this.bufPos >= this.bufLength;
    }

    public char current() {
        this.bufferUp();
        return this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
    }

    char consume() {
        this.bufferUp();
        char val = this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
        ++this.bufPos;
        return val;
    }

    void unconsume() {
        if (this.bufPos < 1) {
            throw new UncheckedIOException(new IOException("No buffer left to unconsume"));
        }
        --this.bufPos;
    }

    public void advance() {
        ++this.bufPos;
    }

    void mark() {
        this.bufSplitPoint = 0;
        this.bufferUp();
        this.bufMark = this.bufPos;
    }

    void rewindToMark() {
        if (this.bufMark == -1) {
            throw new UncheckedIOException(new IOException("Mark invalid"));
        }
        this.bufPos = this.bufMark;
    }

    int nextIndexOf(char c) {
        this.bufferUp();
        for (int i = this.bufPos; i < this.bufLength; ++i) {
            if (c != this.charBuf[i]) continue;
            return i - this.bufPos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence seq) {
        this.bufferUp();
        char startChar = seq.charAt(0);
        for (int offset = this.bufPos; offset < this.bufLength; ++offset) {
            if (startChar != this.charBuf[offset]) {
                while (++offset < this.bufLength && startChar != this.charBuf[offset]) {
                }
            }
            int i = offset + 1;
            int last2 = i + seq.length() - 1;
            if (offset >= this.bufLength || last2 > this.bufLength) continue;
            int j = 1;
            while (i < last2 && seq.charAt(j) == this.charBuf[i]) {
                ++i;
                ++j;
            }
            if (i != last2) continue;
            return offset - this.bufPos;
        }
        return -1;
    }

    public String consumeTo(char c) {
        int offset = this.nextIndexOf(c);
        if (offset != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq) {
        int offset = this.nextIndexOf(seq);
        if (offset != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    public String consumeToAny(char ... chars) {
        int pos;
        this.bufferUp();
        int start2 = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        int charLen = chars.length;
        block0: while (pos < remaining) {
            for (int i = 0; i < charLen; ++i) {
                if (val[pos] == chars[i]) break block0;
            }
            ++pos;
        }
        this.bufPos = pos;
        return pos > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos - start2) : "";
    }

    String consumeToAnySorted(char ... chars) {
        int pos;
        this.bufferUp();
        int start2 = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (pos < remaining && Arrays.binarySearch(chars, val[pos]) < 0) {
            ++pos;
        }
        this.bufPos = pos;
        return this.bufPos > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos - start2) : "";
    }

    String consumeData() {
        int pos;
        int start2 = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos < remaining) {
            switch (val[pos]) {
                case '\u0000': 
                case '&': 
                case '<': {
                    break block3;
                }
                default: {
                    ++pos;
                    continue block3;
                }
            }
        }
        this.bufPos = pos;
        return pos > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos - start2) : "";
    }

    String consumeTagName() {
        int pos;
        this.bufferUp();
        int start2 = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos < remaining) {
            switch (val[pos]) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '<': 
                case '>': {
                    break block3;
                }
                default: {
                    ++pos;
                    continue block3;
                }
            }
        }
        this.bufPos = pos;
        return pos > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos - start2) : "";
    }

    String consumeToEnd() {
        this.bufferUp();
        String data2 = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, this.bufLength - this.bufPos);
        this.bufPos = this.bufLength;
        return data2;
    }

    String consumeLetterSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        while (!this.isEmptyNoBufferUp() && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    String consumeHexSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    String consumeDigitSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.charBuf[this.bufPos] == c;
    }

    boolean matches(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            if (seq.charAt(offset) == this.charBuf[this.bufPos + offset]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            char upTarget;
            char upScan = Character.toUpperCase(seq.charAt(offset));
            if (upScan == (upTarget = Character.toUpperCase(this.charBuf[this.bufPos + offset]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        this.bufferUp();
        char c = this.charBuf[this.bufPos];
        for (char seek : seq) {
            if (seek != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesAnySorted(char[] seq) {
        this.bufferUp();
        return !this.isEmpty() && Arrays.binarySearch(seq, this.charBuf[this.bufPos]) >= 0;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String seq) {
        this.bufferUp();
        if (this.matches(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq) {
        String loScan = seq.toLowerCase(Locale.ENGLISH);
        String hiScan = seq.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(loScan) > -1 || this.nextIndexOf(hiScan) > -1;
    }

    boolean isBinary() {
        int nullsSeen = 0;
        for (int i = this.bufPos; i < this.bufLength; ++i) {
            if (this.charBuf[i] != '\u0000') continue;
            ++nullsSeen;
        }
        return nullsSeen >= 10;
    }

    public String toString() {
        return new String(this.charBuf, this.bufPos, this.bufLength - this.bufPos);
    }

    private static String cacheString(char[] charBuf, String[] stringCache, int start2, int count2) {
        if (count2 > 12) {
            return new String(charBuf, start2, count2);
        }
        if (count2 < 1) {
            return "";
        }
        int hash = 0;
        int offset = start2;
        for (int i = 0; i < count2; ++i) {
            hash = 31 * hash + charBuf[offset++];
        }
        int index = hash & stringCache.length - 1;
        String cached = stringCache[index];
        if (cached == null) {
            stringCache[index] = cached = new String(charBuf, start2, count2);
        } else {
            if (CharacterReader.rangeEquals(charBuf, start2, count2, cached)) {
                return cached;
            }
            stringCache[index] = cached = new String(charBuf, start2, count2);
        }
        return cached;
    }

    static boolean rangeEquals(char[] charBuf, int start2, int count2, String cached) {
        if (count2 == cached.length()) {
            int i = start2;
            int j = 0;
            while (count2-- != 0) {
                if (charBuf[i++] == cached.charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean rangeEquals(int start2, int count2, String cached) {
        return CharacterReader.rangeEquals(this.charBuf, start2, count2, cached);
    }
}

