/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CryptoKt;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.NonCancellable;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u001a\b\u0010\u0015\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"INSECURE_NONCE_COUNT_FACTOR", "", "NONCE_SIZE_IN_BYTES", "NonceGeneratorCoroutineName", "Lkotlinx/coroutines/CoroutineName;", "SECURE_NONCE_COUNT", "SECURE_RANDOM_PROVIDER_NAME", "", "SECURE_RESEED_PERIOD", "SHA1PRNG", "nonceGeneratorJob", "Lkotlinx/coroutines/Job;", "seedChannel", "Lkotlinx/coroutines/channels/Channel;", "getSeedChannel", "()Lkotlinx/coroutines/channels/Channel;", "ensureNonceGeneratorRunning", "", "getInstanceOrNull", "Ljava/security/SecureRandom;", "name", "lookupSecureRandom", "ktor-utils"})
public final class NonceKt {
    private static final String SHA1PRNG = "SHA1PRNG";
    private static final String SECURE_RANDOM_PROVIDER_NAME;
    private static final int SECURE_RESEED_PERIOD = 30000;
    private static final int NONCE_SIZE_IN_BYTES = 8;
    private static final int SECURE_NONCE_COUNT = 8;
    private static final int INSECURE_NONCE_COUNT_FACTOR = 4;
    @NotNull
    private static final Channel<String> seedChannel;
    private static final CoroutineName NonceGeneratorCoroutineName;
    private static final Job nonceGeneratorJob;

    @NotNull
    public static final Channel<String> getSeedChannel() {
        return seedChannel;
    }

    public static final void ensureNonceGeneratorRunning() {
        nonceGeneratorJob.start();
    }

    private static final SecureRandom lookupSecureRandom() {
        SecureRandom secure = NonceKt.getInstanceOrNull(SECURE_RANDOM_PROVIDER_NAME);
        if (secure != null) {
            return secure;
        }
        LoggerFactory.getLogger("io.ktor.util.random").warn(SECURE_RANDOM_PROVIDER_NAME + " is not found, fallback to SHA1PRNG");
        SecureRandom secureRandom = NonceKt.getInstanceOrNull(SHA1PRNG);
        if (secureRandom == null) {
            String string = "No SecureRandom implementation found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return secureRandom;
    }

    private static final SecureRandom getInstanceOrNull(String name2) {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance(name2);
        }
        catch (NoSuchAlgorithmException notFound) {
            secureRandom = null;
        }
        return secureRandom;
    }

    static {
        String string = System.getProperty("io.ktor.random.secure.random.provider");
        if (string == null) {
            string = "NativePRNGNonBlocking";
        }
        SECURE_RANDOM_PROVIDER_NAME = string;
        seedChannel = ChannelKt.Channel(1024);
        NonceGeneratorCoroutineName = new CoroutineName("nonce-generator");
        nonceGeneratorJob = BuildersKt.launch(GlobalScope.INSTANCE, Dispatchers.getIO().plus(NonCancellable.INSTANCE).plus(NonceGeneratorCoroutineName), CoroutineStart.LAZY, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            private CoroutineScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            long J$0;
            long J$1;
            int I$0;
            int I$1;
            int label;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        $this$launch = this.p$;
                        seedChannel = NonceKt.getSeedChannel();
                        lastReseed = 0L;
                        previousRoundNonceList = new ArrayList();
                        secureInstance = NonceKt.access$lookupSecureRandom();
                        weakRandom = SecureRandom.getInstance("SHA1PRNG");
                        secureBytes = new byte[64];
                        weakBytes = new byte[secureBytes.length * 4];
                        weakRandom.setSeed(secureInstance.generateSeed(secureBytes.length));
                        break;
                    }
                    case 1: {
                        var15_18 = this.I$1;
                        index = this.I$0;
                        randomNonceList = (List<T>)this.L$7;
                        currentTime = this.J$1;
                        weakBytes = (byte[])this.L$6;
                        secureBytes = (byte[])this.L$5;
                        weakRandom = (SecureRandom)this.L$4;
                        secureInstance = (SecureRandom)this.L$3;
                        previousRoundNonceList = (ArrayList)this.L$2;
                        lastReseed = this.J$0;
                        seedChannel = (Channel)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            try {
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
                                while (true) {
                                    ++index;
                                    ** GOTO lbl72
                                    break;
                                }
                            }
                            catch (Throwable t) {
                                seedChannel.close(t);
                                SendChannel.DefaultImpls.close$default(seedChannel, null, 1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        catch (Throwable var11_14) {
                            SendChannel.DefaultImpls.close$default(seedChannel, null, 1, null);
                            throw var11_14;
                        }
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                block10: while (true) {
                    secureInstance.nextBytes(secureBytes);
                    weakRandom.nextBytes(weakBytes);
                    var11_12 = 0;
                    var12_15 = secureBytes.length;
                    while (var11_12 < var12_15) {
                        weakBytes[i * 4] = secureBytes[i];
                        ++i;
                    }
                    currentTime = System.currentTimeMillis();
                    if (currentTime - lastReseed > (long)30000) {
                        weakRandom.setSeed(lastReseed - currentTime);
                        weakRandom.setSeed(secureInstance.generateSeed(secureBytes.length));
                        lastReseed = currentTime;
                    } else {
                        weakRandom.setSeed(secureBytes);
                    }
                    v1 = CollectionsKt.plus((Collection)StringsKt.chunked(CryptoKt.hex(weakBytes), 16), (Iterable)previousRoundNonceList);
                    v2 = weakRandom;
                    Intrinsics.checkExpressionValueIsNotNull(v2, "weakRandom");
                    randomNonceList = CollectionsKt.shuffled(v1, v2);
                    var14_17 = 0;
                    var15_18 = randomNonceList.size() / 2;
lbl72:
                    // 2 sources

                    if (var14_17 < var15_18) {
                        this.L$0 = $this$launch;
                        this.L$1 = seedChannel;
                        this.J$0 = lastReseed;
                        this.L$2 = previousRoundNonceList;
                        this.L$3 = secureInstance;
                        this.L$4 = weakRandom;
                        this.L$5 = secureBytes;
                        this.L$6 = weakBytes;
                        this.J$1 = currentTime;
                        this.L$7 = randomNonceList;
                        this.I$0 = index;
                        this.I$1 = var15_18;
                        this.label = 1;
                        if ((v0 = seedChannel.send(randomNonceList.get(index), this)) != var16_2) ** continue;
                        return var16_2;
                    }
                    previousRoundNonceList.clear();
                    index = randomNonceList.size() / 2;
                    var15_18 = randomNonceList.size();
                    while (true) {
                        if (index >= var15_18) continue block10;
                        previousRoundNonceList.add(randomNonceList.get(index));
                        ++index;
                    }
                    break;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, "completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final /* synthetic */ SecureRandom access$lookupSecureRandom() {
        return NonceKt.lookupSecureRandom();
    }
}

