/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.http.cio.internals.HttpByteBufferPoolKt;
import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.Input;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.pool.DefaultPool;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0019\b\u0002\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000e"}, d2={"CryptoBufferPool", "Lkotlinx/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "getCryptoBufferPool", "()Lkotlinx/io/pool/ObjectPool;", "cipherLoop", "Lkotlinx/io/core/ByteReadPacket;", "cipher", "Ljavax/crypto/Cipher;", "header", "Lkotlin/Function1;", "Lkotlinx/io/core/BytePacketBuilder;", "", "Lkotlin/ExtensionFunctionType;", "ktor-network-tls"})
public final class CipherUtilsKt {
    @NotNull
    private static final ObjectPool<ByteBuffer> CryptoBufferPool = new DefaultPool<ByteBuffer>(128){

        @NotNull
        protected ByteBuffer produceInstance() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "ByteBuffer.allocate(65536)");
            return byteBuffer;
        }

        @NotNull
        protected ByteBuffer clearInstance(@NotNull ByteBuffer instance) {
            Intrinsics.checkParameterIsNotNull(instance, "instance");
            ByteBuffer byteBuffer = instance;
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer $this$apply = byteBuffer;
            boolean bl3 = false;
            $this$apply.clear();
            return byteBuffer;
        }
    };

    @NotNull
    public static final ObjectPool<ByteBuffer> getCryptoBufferPool() {
        return CryptoBufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteReadPacket cipherLoop(@NotNull ByteReadPacket $this$cipherLoop, @NotNull Cipher cipher2, @NotNull Function1<? super BytePacketBuilder, Unit> header) {
        Intrinsics.checkParameterIsNotNull($this$cipherLoop, "$this$cipherLoop");
        Intrinsics.checkParameterIsNotNull(cipher2, "cipher");
        Intrinsics.checkParameterIsNotNull(header, "header");
        ByteBuffer srcBuffer = HttpByteBufferPoolKt.getDefaultByteBufferPool().borrow();
        ByteBuffer dstBuffer = CryptoBufferPool.borrow();
        boolean dstBufferFromPool = true;
        try {
            ByteReadPacket byteReadPacket;
            int headerSizeHint$iv = 0;
            boolean $i$f$buildPacket = false;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
            try {
                int rc2;
                BytePacketBuilder $this$buildPacket = builder$iv;
                boolean bl = false;
                srcBuffer.clear();
                header.invoke($this$buildPacket);
                while (true) {
                    rc2 = srcBuffer.hasRemaining() ? Input.DefaultImpls.readAvailable$default($this$cipherLoop, srcBuffer, 0, 2, null) : 0;
                    srcBuffer.flip();
                    if (!srcBuffer.hasRemaining() && (rc2 == -1 || $this$cipherLoop.isEmpty())) break;
                    dstBuffer.clear();
                    if (cipher2.getOutputSize(srcBuffer.remaining()) > dstBuffer.remaining()) {
                        if (dstBufferFromPool) {
                            CryptoBufferPool.recycle(dstBuffer);
                        }
                        Intrinsics.checkExpressionValueIsNotNull(ByteBuffer.allocate(cipher2.getOutputSize(srcBuffer.remaining())), "ByteBuffer.allocate(ciph\u2026e(srcBuffer.remaining()))");
                        dstBufferFromPool = false;
                    }
                    cipher2.update(srcBuffer, dstBuffer);
                    dstBuffer.flip();
                    $this$buildPacket.writeFully(dstBuffer);
                    srcBuffer.compact();
                }
                rc2 = !srcBuffer.hasRemaining() ? 1 : 0;
                boolean bl2 = false;
                if (_Assertions.ENABLED && rc2 == 0) {
                    boolean $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = false;
                    String $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = "Cipher loop completed too early: there are unprocessed bytes";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CipherUtilsKt$cipherLoop$2$32));
                }
                rc2 = !dstBuffer.hasRemaining() ? 1 : 0;
                bl2 = false;
                if (_Assertions.ENABLED && rc2 == 0) {
                    boolean bl3 = false;
                    String string = "Not all bytes were appended to the packet";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int requiredBufferSize = cipher2.getOutputSize(0);
                if (requiredBufferSize != 0) {
                    if (requiredBufferSize > dstBuffer.capacity()) {
                        Output output2 = $this$buildPacket;
                        byte[] byArray = cipher2.doFinal();
                        Intrinsics.checkExpressionValueIsNotNull(byArray, "cipher.doFinal()");
                        OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                    } else {
                        dstBuffer.clear();
                        cipher2.doFinal(CipherKt.getEmptyByteBuffer(), dstBuffer);
                        dstBuffer.flip();
                        if (!dstBuffer.hasRemaining()) {
                            Output output3 = $this$buildPacket;
                            byte[] byArray = cipher2.doFinal();
                            Intrinsics.checkExpressionValueIsNotNull(byArray, "cipher.doFinal()");
                            OutputKt.writeFully$default(output3, byArray, 0, 0, 6, null);
                        } else {
                            $this$buildPacket.writeFully(dstBuffer);
                        }
                    }
                }
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            return byteReadPacket2;
        }
        finally {
            HttpByteBufferPoolKt.getDefaultByteBufferPool().recycle(srcBuffer);
            if (dstBufferFromPool) {
                CryptoBufferPool.recycle(dstBuffer);
            }
        }
    }

    public static /* synthetic */ ByteReadPacket cipherLoop$default(ByteReadPacket byteReadPacket, Cipher cipher2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = cipherLoop.1.INSTANCE;
        }
        return CipherUtilsKt.cipherLoop(byteReadPacket, cipher2, function1);
    }
}

