/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.DateUtilsKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.DateKt;
import io.ktor.util.date.GMTDate;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lio/ktor/http/content/LastModifiedVersion;", "Lio/ktor/http/content/Version;", "lastModified", "Ljava/util/Date;", "(Ljava/util/Date;)V", "Lio/ktor/util/date/GMTDate;", "(Lio/ktor/util/date/GMTDate;)V", "getLastModified", "()Lio/ktor/util/date/GMTDate;", "appendHeadersTo", "", "builder", "Lio/ktor/http/HeadersBuilder;", "check", "Lio/ktor/http/content/VersionCheckResult;", "requestHeaders", "Lio/ktor/http/Headers;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ktor-http"})
public final class LastModifiedVersion
implements Version {
    @NotNull
    private final GMTDate lastModified;

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders) {
        GMTDate ifUnmodifiedSince;
        Intrinsics.checkParameterIsNotNull(requestHeaders, "requestHeaders");
        GMTDate normalized = DateKt.truncateToSeconds(this.lastModified);
        String string = requestHeaders.get(HttpHeaders.INSTANCE.getIfModifiedSince());
        GMTDate ifModifiedSince = string != null ? DateUtilsKt.fromHttpToGmtDate(string) : null;
        String string2 = requestHeaders.get(HttpHeaders.INSTANCE.getIfUnmodifiedSince());
        GMTDate gMTDate = ifUnmodifiedSince = string2 != null ? DateUtilsKt.fromHttpToGmtDate(string2) : null;
        if (ifModifiedSince != null && normalized.compareTo(ifModifiedSince) <= 0) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        if (ifUnmodifiedSince != null && normalized.compareTo(ifUnmodifiedSince) > 0) {
            return VersionCheckResult.PRECONDITION_FAILED;
        }
        return VersionCheckResult.OK;
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        builder.set(HttpHeaders.INSTANCE.getLastModified(), DateUtilsKt.toHttpDate(this.lastModified));
    }

    @NotNull
    public final GMTDate getLastModified() {
        return this.lastModified;
    }

    public LastModifiedVersion(@NotNull GMTDate lastModified) {
        Intrinsics.checkParameterIsNotNull(lastModified, "lastModified");
        this.lastModified = lastModified;
    }

    public LastModifiedVersion(@NotNull Date lastModified) {
        Intrinsics.checkParameterIsNotNull(lastModified, "lastModified");
        this(DateJvmKt.GMTDate(lastModified.getTime()));
    }

    @NotNull
    public final GMTDate component1() {
        return this.lastModified;
    }

    @NotNull
    public final LastModifiedVersion copy(@NotNull GMTDate lastModified) {
        Intrinsics.checkParameterIsNotNull(lastModified, "lastModified");
        return new LastModifiedVersion(lastModified);
    }

    public static /* synthetic */ LastModifiedVersion copy$default(LastModifiedVersion lastModifiedVersion, GMTDate gMTDate, int n, Object object) {
        if ((n & 1) != 0) {
            gMTDate = lastModifiedVersion.lastModified;
        }
        return lastModifiedVersion.copy(gMTDate);
    }

    @NotNull
    public String toString() {
        return "LastModifiedVersion(lastModified=" + this.lastModified + ")";
    }

    public int hashCode() {
        GMTDate gMTDate = this.lastModified;
        return gMTDate != null ? ((Object)gMTDate).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LastModifiedVersion)) break block3;
                LastModifiedVersion lastModifiedVersion = (LastModifiedVersion)object;
                if (!Intrinsics.areEqual(this.lastModified, lastModifiedVersion.lastModified)) break block3;
            }
            return true;
        }
        return false;
    }
}

