/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring;

import com.alibaba.fastjson.support.spring.FastJsonContainer;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import com.alibaba.fastjson.support.spring.annotation.FastJsonFilter;
import com.alibaba.fastjson.support.spring.annotation.FastJsonView;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order
@ControllerAdvice
public class FastJsonViewResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return FastJsonHttpMessageConverter.class.isAssignableFrom(converterType) && returnType.hasMethodAnnotation(FastJsonView.class);
    }

    public FastJsonContainer beforeBodyWrite(Object body2, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request2, ServerHttpResponse response2) {
        FastJsonContainer container = this.getOrCreateContainer(body2);
        this.beforeBodyWriteInternal(container, selectedContentType, returnType, request2, response2);
        return container;
    }

    private FastJsonContainer getOrCreateContainer(Object body2) {
        return body2 instanceof FastJsonContainer ? (FastJsonContainer)body2 : new FastJsonContainer(body2);
    }

    protected void beforeBodyWriteInternal(FastJsonContainer container, MediaType contentType2, MethodParameter returnType, ServerHttpRequest request2, ServerHttpResponse response2) {
        FastJsonView annotation = (FastJsonView)returnType.getMethodAnnotation(FastJsonView.class);
        FastJsonFilter[] include = annotation.include();
        FastJsonFilter[] exclude = annotation.exclude();
        PropertyPreFilters filters = new PropertyPreFilters();
        for (FastJsonFilter item : include) {
            filters.addFilter(item.clazz(), item.props());
        }
        for (FastJsonFilter item : exclude) {
            filters.addFilter(item.clazz(), new String[0]).addExcludes(item.props());
        }
        container.setFilters(filters);
    }
}

