/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class PrimitiveArraySerializer
implements ObjectSerializer {
    public static PrimitiveArraySerializer instance = new PrimitiveArraySerializer();

    @Override
    public final void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out2 = serializer2.out;
        if (object == null) {
            out2.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        if (object instanceof int[]) {
            int[] array = (int[])object;
            out2.write(91);
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out2.write(44);
                }
                out2.writeInt(array[i]);
            }
            out2.write(93);
            return;
        }
        if (object instanceof short[]) {
            short[] array = (short[])object;
            out2.write(91);
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out2.write(44);
                }
                out2.writeInt(array[i]);
            }
            out2.write(93);
            return;
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            out2.write(91);
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out2.write(44);
                }
                out2.writeLong(array[i]);
            }
            out2.write(93);
            return;
        }
        if (object instanceof boolean[]) {
            boolean[] array = (boolean[])object;
            out2.write(91);
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    out2.write(44);
                }
                out2.write(array[i]);
            }
            out2.write(93);
            return;
        }
        if (object instanceof float[]) {
            float[] array = (float[])object;
            out2.write(91);
            for (int i = 0; i < array.length; ++i) {
                float item;
                if (i != 0) {
                    out2.write(44);
                }
                if (Float.isNaN(item = array[i])) {
                    out2.writeNull();
                    continue;
                }
                out2.append(Float.toString(item));
            }
            out2.write(93);
            return;
        }
        if (object instanceof double[]) {
            double[] array = (double[])object;
            out2.write(91);
            for (int i = 0; i < array.length; ++i) {
                double item;
                if (i != 0) {
                    out2.write(44);
                }
                if (Double.isNaN(item = array[i])) {
                    out2.writeNull();
                    continue;
                }
                out2.append(Double.toString(item));
            }
            out2.write(93);
            return;
        }
        if (object instanceof byte[]) {
            byte[] array = (byte[])object;
            out2.writeByteArray(array);
            return;
        }
        char[] chars = (char[])object;
        out2.writeString(chars);
    }
}

