/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class OptionalCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static OptionalCodec instance = new OptionalCodec();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type2, Object fieldName) {
        if (type2 == OptionalInt.class) {
            Integer obj = parser.parseObject(Integer.class);
            Integer value = TypeUtils.castToInt(obj);
            if (value == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of(value);
        }
        if (type2 == OptionalLong.class) {
            Long obj = parser.parseObject(Long.class);
            Long value = TypeUtils.castToLong(obj);
            if (value == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of(value);
        }
        if (type2 == OptionalDouble.class) {
            Double obj = parser.parseObject(Double.class);
            Double value = TypeUtils.castToDouble(obj);
            if (value == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of(value);
        }
        Object value = parser.parseObject(type2 = TypeUtils.unwrapOptional(type2));
        if (value == null) {
            return (T)Optional.empty();
        }
        return (T)Optional.of(value);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    @Override
    public void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer2.writeNull();
            return;
        }
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            Object value = optional.isPresent() ? optional.get() : null;
            serializer2.write((Object)value);
            return;
        }
        if (object instanceof OptionalDouble) {
            OptionalDouble optional = (OptionalDouble)object;
            if (optional.isPresent()) {
                double value = optional.getAsDouble();
                serializer2.write(value);
            } else {
                serializer2.writeNull();
            }
            return;
        }
        if (object instanceof OptionalInt) {
            OptionalInt optional = (OptionalInt)object;
            if (optional.isPresent()) {
                int value = optional.getAsInt();
                serializer2.out.writeInt(value);
            } else {
                serializer2.writeNull();
            }
            return;
        }
        if (object instanceof OptionalLong) {
            OptionalLong optional = (OptionalLong)object;
            if (optional.isPresent()) {
                long value = optional.getAsLong();
                serializer2.out.writeLong(value);
            } else {
                serializer2.writeNull();
            }
            return;
        }
        throw new JSONException("not support optional : " + object.getClass());
    }
}

