/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.io.internal;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.io.internal.ReadWriteBufferStateKt;
import kotlinx.coroutines.io.internal.RingBufferCapacity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0007\u0018\u0019\u001a\u001b\u001c\u001d\u001eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0010\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0017R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u0082\u0001\u0007\u001f !\"#$%\u00a8\u0006&"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "", "backingBuffer", "Ljava/nio/ByteBuffer;", "capacity", "Lkotlinx/coroutines/io/internal/RingBufferCapacity;", "(Ljava/nio/ByteBuffer;Lkotlinx/coroutines/io/internal/RingBufferCapacity;)V", "idle", "", "getIdle", "()Z", "readBuffer", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "writeBuffer", "getWriteBuffer", "startReading", "startReading$kotlinx_coroutines_io", "startWriting", "startWriting$kotlinx_coroutines_io", "stopReading", "stopReading$kotlinx_coroutines_io", "stopWriting", "stopWriting$kotlinx_coroutines_io", "IdleEmpty", "IdleNonEmpty", "Initial", "Reading", "ReadingWriting", "Terminated", "Writing", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleEmpty;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleNonEmpty;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Reading;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Writing;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$ReadingWriting;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Terminated;", "kotlinx-coroutines-io"})
public abstract class ReadWriteBufferState {
    @JvmField
    @NotNull
    public final ByteBuffer backingBuffer;
    @JvmField
    @NotNull
    public final RingBufferCapacity capacity;

    public boolean getIdle() {
        return false;
    }

    @NotNull
    public ByteBuffer getReadBuffer() {
        String string = "read buffer is not available in state " + this;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ByteBuffer getWriteBuffer() {
        String string = "write buffer is not available in state " + this;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState startReading$kotlinx_coroutines_io() {
        String string = "Reading is not available in state " + this;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState startWriting$kotlinx_coroutines_io() {
        String string = "Writing is not available in state " + this;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState stopReading$kotlinx_coroutines_io() {
        String string = "Unable to stop reading in state " + this;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public ReadWriteBufferState stopWriting$kotlinx_coroutines_io() {
        String string = "Unable to stop writing in state " + this;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private ReadWriteBufferState(ByteBuffer backingBuffer, RingBufferCapacity capacity) {
        this.backingBuffer = backingBuffer;
        this.capacity = capacity;
    }

    public /* synthetic */ ReadWriteBufferState(ByteBuffer backingBuffer, RingBufferCapacity capacity, DefaultConstructorMarker $constructor_marker) {
        this(backingBuffer, capacity);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleEmpty;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "()V", "idle", "", "getIdle", "()Z", "toString", "", "kotlinx-coroutines-io"})
    public static final class IdleEmpty
    extends ReadWriteBufferState {
        public static final IdleEmpty INSTANCE;

        @Override
        public boolean getIdle() {
            return true;
        }

        @NotNull
        public String toString() {
            return "IDLE(empty)";
        }

        private IdleEmpty() {
            super(ReadWriteBufferStateKt.getEmptyByteBuffer(), ReadWriteBufferStateKt.getEmptyCapacity(), null);
        }

        static {
            IdleEmpty idleEmpty;
            INSTANCE = idleEmpty = new IdleEmpty();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010 \u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020%H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "backingBuffer", "Ljava/nio/ByteBuffer;", "reservedSize", "", "(Ljava/nio/ByteBuffer;I)V", "idle", "", "getIdle", "()Z", "idleState", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleNonEmpty;", "getIdleState$kotlinx_coroutines_io", "()Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleNonEmpty;", "readBuffer", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "readingState", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Reading;", "getReadingState$kotlinx_coroutines_io", "()Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Reading;", "readingWritingState", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$ReadingWriting;", "getReadingWritingState$kotlinx_coroutines_io", "()Lkotlinx/coroutines/io/internal/ReadWriteBufferState$ReadingWriting;", "writeBuffer", "getWriteBuffer", "writingState", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Writing;", "getWritingState$kotlinx_coroutines_io", "()Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Writing;", "startReading", "startReading$kotlinx_coroutines_io", "startWriting", "startWriting$kotlinx_coroutines_io", "toString", "", "kotlinx-coroutines-io"})
    public static final class Initial
    extends ReadWriteBufferState {
        @NotNull
        private final ByteBuffer writeBuffer;
        @NotNull
        private final ByteBuffer readBuffer;
        @NotNull
        private final IdleNonEmpty idleState;
        @NotNull
        private final Reading readingState;
        @NotNull
        private final Writing writingState;
        @NotNull
        private final ReadingWriting readingWritingState;

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.writeBuffer;
        }

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        @NotNull
        public final IdleNonEmpty getIdleState$kotlinx_coroutines_io() {
            return this.idleState;
        }

        @NotNull
        public final Reading getReadingState$kotlinx_coroutines_io() {
            return this.readingState;
        }

        @NotNull
        public final Writing getWritingState$kotlinx_coroutines_io() {
            return this.writingState;
        }

        @NotNull
        public final ReadingWriting getReadingWritingState$kotlinx_coroutines_io() {
            return this.readingWritingState;
        }

        @Override
        @NotNull
        public Reading startReading$kotlinx_coroutines_io() {
            return this.readingState;
        }

        @Override
        @NotNull
        public Writing startWriting$kotlinx_coroutines_io() {
            return this.writingState;
        }

        @Override
        public boolean getIdle() {
            String string = "Not available for initial state";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public String toString() {
            return "Initial";
        }

        public Initial(@NotNull ByteBuffer backingBuffer, int reservedSize) {
            Intrinsics.checkParameterIsNotNull(backingBuffer, "backingBuffer");
            super(backingBuffer, new RingBufferCapacity(backingBuffer.capacity() - reservedSize), null);
            boolean bl = backingBuffer.position() == 0;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = backingBuffer.limit() == backingBuffer.capacity();
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ByteBuffer byteBuffer = backingBuffer.duplicate();
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "backingBuffer.duplicate()");
            this.writeBuffer = byteBuffer;
            ByteBuffer byteBuffer2 = backingBuffer.duplicate();
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer2, "backingBuffer.duplicate()");
            this.readBuffer = byteBuffer2;
            this.idleState = new IdleNonEmpty(this);
            this.readingState = new Reading(this);
            this.writingState = new Writing(this);
            this.readingWritingState = new ReadingWriting(this);
        }

        public /* synthetic */ Initial(ByteBuffer byteBuffer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 8;
            }
            this(byteBuffer, n);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleNonEmpty;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "initial", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;", "(Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;)V", "idle", "", "getIdle", "()Z", "getInitial", "()Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;", "startReading", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Reading;", "startReading$kotlinx_coroutines_io", "startWriting", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Writing;", "startWriting$kotlinx_coroutines_io", "toString", "", "kotlinx-coroutines-io"})
    public static final class IdleNonEmpty
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        @Override
        @NotNull
        public Reading startReading$kotlinx_coroutines_io() {
            return this.initial.getReadingState$kotlinx_coroutines_io();
        }

        @Override
        @NotNull
        public Writing startWriting$kotlinx_coroutines_io() {
            return this.initial.getWritingState$kotlinx_coroutines_io();
        }

        @Override
        public boolean getIdle() {
            return true;
        }

        @NotNull
        public String toString() {
            return "IDLE(with buffer)";
        }

        @NotNull
        public final Initial getInitial() {
            return this.initial;
        }

        public IdleNonEmpty(@NotNull Initial initial) {
            Intrinsics.checkParameterIsNotNull(initial, "initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Reading;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "initial", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;", "(Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;)V", "readBuffer", "Ljava/nio/ByteBuffer;", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "startWriting", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$ReadingWriting;", "startWriting$kotlinx_coroutines_io", "stopReading", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopReading$kotlinx_coroutines_io", "toString", "", "kotlinx-coroutines-io"})
    public static final class Reading
    extends ReadWriteBufferState {
        private final Initial initial;

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.initial.getReadBuffer();
        }

        @Override
        @NotNull
        public ReadingWriting startWriting$kotlinx_coroutines_io() {
            return this.initial.getReadingWritingState$kotlinx_coroutines_io();
        }

        @Override
        @NotNull
        public IdleNonEmpty stopReading$kotlinx_coroutines_io() {
            return this.initial.getIdleState$kotlinx_coroutines_io();
        }

        @NotNull
        public String toString() {
            return "Reading";
        }

        public Reading(@NotNull Initial initial) {
            Intrinsics.checkParameterIsNotNull(initial, "initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Writing;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "initial", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;", "(Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;)V", "writeBuffer", "Ljava/nio/ByteBuffer;", "getWriteBuffer", "()Ljava/nio/ByteBuffer;", "startReading", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$ReadingWriting;", "startReading$kotlinx_coroutines_io", "stopWriting", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopWriting$kotlinx_coroutines_io", "toString", "", "kotlinx-coroutines-io"})
    public static final class Writing
    extends ReadWriteBufferState {
        private final Initial initial;

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.initial.getWriteBuffer();
        }

        @Override
        @NotNull
        public ReadingWriting startReading$kotlinx_coroutines_io() {
            return this.initial.getReadingWritingState$kotlinx_coroutines_io();
        }

        @Override
        @NotNull
        public IdleNonEmpty stopWriting$kotlinx_coroutines_io() {
            return this.initial.getIdleState$kotlinx_coroutines_io();
        }

        @NotNull
        public String toString() {
            return "Writing";
        }

        public Writing(@NotNull Initial initial) {
            Intrinsics.checkParameterIsNotNull(initial, "initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0013"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState$ReadingWriting;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "initial", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;", "(Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Initial;)V", "readBuffer", "Ljava/nio/ByteBuffer;", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "writeBuffer", "getWriteBuffer", "stopReading", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Writing;", "stopReading$kotlinx_coroutines_io", "stopWriting", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Reading;", "stopWriting$kotlinx_coroutines_io", "toString", "", "kotlinx-coroutines-io"})
    public static final class ReadingWriting
    extends ReadWriteBufferState {
        private final Initial initial;

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.initial.getReadBuffer();
        }

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.initial.getWriteBuffer();
        }

        @Override
        @NotNull
        public Writing stopReading$kotlinx_coroutines_io() {
            return this.initial.getWritingState$kotlinx_coroutines_io();
        }

        @Override
        @NotNull
        public Reading stopWriting$kotlinx_coroutines_io() {
            return this.initial.getReadingState$kotlinx_coroutines_io();
        }

        @NotNull
        public String toString() {
            return "Reading+Writing";
        }

        public ReadingWriting(@NotNull Initial initial) {
            Intrinsics.checkParameterIsNotNull(initial, "initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lkotlinx/coroutines/io/internal/ReadWriteBufferState$Terminated;", "Lkotlinx/coroutines/io/internal/ReadWriteBufferState;", "()V", "toString", "", "kotlinx-coroutines-io"})
    public static final class Terminated
    extends ReadWriteBufferState {
        public static final Terminated INSTANCE;

        @NotNull
        public String toString() {
            return "Terminated";
        }

        private Terminated() {
            super(ReadWriteBufferStateKt.getEmptyByteBuffer(), ReadWriteBufferStateKt.getEmptyCapacity(), null);
        }

        static {
            Terminated terminated;
            INSTANCE = terminated = new Terminated();
        }
    }
}

