/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.OIDKt;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.CertificatesKt$writeX509Info$1$$special$;
import io.ktor.network.tls.certificates.Counterparty;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.charsets.CharsetJVMKt;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.CloseableJVMKt;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u001a\f\u0010\u000b\u001a\u00020\n*\u00020\nH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u001aX\u0010\u0012\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cH\u0000\u001a\u001e\u0010\u001f\u001a\u00020\r*\u00020\u000e2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\nH\u0002\u001a%\u0010\u001f\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a\u0014\u0010&\u001a\u00020\r*\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0002\u001a\u0014\u0010(\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u001a\u0014\u0010)\u001a\u00020\r*\u00020\u000e2\u0006\u0010*\u001a\u00020\nH\u0002\u001a\f\u0010+\u001a\u00020\r*\u00020\u000eH\u0002\u001a\u0014\u0010,\u001a\u00020\r*\u00020\u000e2\u0006\u0010-\u001a\u00020.H\u0002\u001a\u0014\u0010,\u001a\u00020\r*\u00020\u000e2\u0006\u0010-\u001a\u00020/H\u0002\u001a%\u00100\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a%\u00101\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a%\u00102\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a$\u00103\u001a\u00020\r*\u00020\u000e2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u000207H\u0002\u001a\u0014\u00108\u001a\u00020\r*\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0002\u001a\u001e\u00109\u001a\u00020\r*\u00020\u000e2\u0006\u0010:\u001a\u00020\u00052\b\b\u0002\u0010;\u001a\u00020\nH\u0002\u001a\u0016\u0010<\u001a\u00020\r*\u00020\u000e2\b\b\u0002\u0010=\u001a\u00020\nH\u0002\u001a\u0014\u0010>\u001a\u00020\r*\u00020\u000e2\u0006\u0010?\u001a\u00020\u0014H\u0002\u001a-\u0010@\u001a\u00020\r*\u00020\u000e2\u0006\u0010A\u001a\u00020\n2\u0017\u0010B\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001aX\u0010C\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010D\u001a\u00020E2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cH\u0000\u001a\u001c\u0010F\u001a\u00020\r*\u00020\u000e2\u0006\u0010A\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006G"}, d2={"generateCertificate", "Ljava/security/KeyStore;", "file", "Ljava/io/File;", "algorithm", "", "keyAlias", "keyPassword", "jksPassword", "keySizeInBits", "", "derLength", "writeAlgorithmIdentifier", "", "Lkotlinx/io/core/BytePacketBuilder;", "writeAsnInt", "value", "Ljava/math/BigInteger;", "writeCertificate", "issuer", "Lio/ktor/network/tls/certificates/Counterparty;", "subject", "keyPair", "Ljava/security/KeyPair;", "from", "Ljava/util/Date;", "to", "domains", "", "ipAddresses", "Ljava/net/InetAddress;", "writeDerBitString", "array", "", "unused", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeDerGeneralizedTime", "date", "writeDerInt", "writeDerLength", "length", "writeDerNull", "writeDerObjectIdentifier", "identifier", "Lio/ktor/network/tls/OID;", "", "writeDerOctetString", "writeDerSequence", "writeDerSet", "writeDerType", "kind", "typeIdentifier", "simpleType", "", "writeDerUTCTime", "writeDerUTF8String", "s", "type", "writeVersion", "v", "writeX509Counterparty", "counterparty", "writeX509Extension", "id", "builder", "writeX509Info", "publicKey", "Ljava/security/PublicKey;", "writeX509NamePart", "ktor-network-tls"})
public final class CertificatesKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KeyStore generateCertificate(@NotNull File file, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(algorithm, "algorithm");
        Intrinsics.checkParameterIsNotNull(keyAlias, "keyAlias");
        Intrinsics.checkParameterIsNotNull(keyPassword, "keyPassword");
        Intrinsics.checkParameterIsNotNull(jksPassword, "jksPassword");
        long daysValid = 3L;
        KeyStore keyStore = KeyStore.getInstance("JKS");
        if (keyStore == null) {
            Intrinsics.throwNpe();
        }
        KeyStore keyStore2 = keyStore;
        keyStore2.load(null, null);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm(algorithm));
        if (keyPairGenerator == null) {
            Intrinsics.throwNpe();
        }
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        keyPairGenerator2.initialize(keySizeInBits);
        KeyPair keyPair = keyPairGenerator2.genKeyPair();
        if (keyPair == null) {
            Intrinsics.throwNpe();
        }
        KeyPair keyPair2 = keyPair;
        Counterparty id = new Counterparty("RU", "JetBrains", "Kotlin", "localhost");
        Date from = new Date();
        Date to = Date.from(LocalDateTime.now().plusDays(daysValid).atZone(ZoneId.systemDefault()).toInstant());
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket22 = false;
        BytePacketBuilder builder$iv22 = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv22;
            boolean bl = false;
            Date date = to;
            Intrinsics.checkExpressionValueIsNotNull(date, "to");
            CertificatesKt.writeCertificate($this$buildPacket, id, id, keyPair2, algorithm, from, date, CollectionsKt.listOf("127.0.0.1", "localhost"), CollectionsKt.listOf(Inet4Address.getByName("127.0.0.1")));
            byteReadPacket = builder$iv22.build();
        }
        catch (Throwable t$iv) {
            builder$iv22.release();
            throw t$iv;
        }
        byte[] certificateBytes = StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
        Object $i$f$buildPacket22 = certificateBytes;
        Object object = CertificateFactory.getInstance("X.509");
        boolean builder$iv22 = false;
        Object object2 = new ByteArrayInputStream((byte[])$i$f$buildPacket22);
        Certificate cert = ((CertificateFactory)object).generateCertificate((InputStream)object2);
        cert.verify(keyPair2.getPublic());
        keyStore2.setCertificateEntry(keyAlias, cert);
        $i$f$buildPacket22 = keyPassword;
        Key key = keyPair2.getPrivate();
        object2 = keyAlias;
        object = keyStore2;
        builder$iv22 = false;
        char[] cArray = ((String)$i$f$buildPacket22).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull(cArray, "(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        ((KeyStore)object).setKeyEntry((String)object2, key, cArray2, new Certificate[]{cert});
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        $i$f$buildPacket22 = file;
        builder$iv22 = false;
        Closeable $this$use$iv = new FileOutputStream((File)$i$f$buildPacket22);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            FileOutputStream it = (FileOutputStream)$this$use$iv;
            boolean bl = false;
            String string = jksPassword;
            OutputStream outputStream2 = it;
            KeyStore keyStore3 = keyStore2;
            boolean bl2 = false;
            char[] cArray3 = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull(cArray3, "(this as java.lang.String).toCharArray()");
            char[] cArray4 = cArray3;
            keyStore3.store(outputStream2, cArray4);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable first$iv) {
            try {
                try {
                    closed$iv = true;
                    $this$use$iv.close();
                }
                catch (Throwable second$iv) {
                    CloseableJVMKt.addSuppressedInternal(first$iv, second$iv);
                }
                throw first$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return keyStore2;
    }

    public static /* synthetic */ KeyStore generateCertificate$default(File file, String string, String string2, String string3, String string4, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        return CertificatesKt.generateCertificate(file, string, string2, string3, string4, n);
    }

    public static final void writeX509Info(@NotNull BytePacketBuilder $this$writeX509Info, @NotNull String algorithm, @NotNull Counterparty issuer, @NotNull Counterparty subject, @NotNull PublicKey publicKey, @NotNull Date from, @NotNull Date to, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses) {
        Intrinsics.checkParameterIsNotNull($this$writeX509Info, "$this$writeX509Info");
        Intrinsics.checkParameterIsNotNull(algorithm, "algorithm");
        Intrinsics.checkParameterIsNotNull(issuer, "issuer");
        Intrinsics.checkParameterIsNotNull(subject, "subject");
        Intrinsics.checkParameterIsNotNull(publicKey, "publicKey");
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(domains, "domains");
        Intrinsics.checkParameterIsNotNull(ipAddresses, "ipAddresses");
        BigInteger version = new BigInteger(64, new SecureRandom());
        CertificatesKt.writeDerSequence($this$writeX509Info, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(version, algorithm, issuer, from, to, subject, publicKey, domains, ipAddresses){
            final /* synthetic */ BigInteger $version;
            final /* synthetic */ String $algorithm;
            final /* synthetic */ Counterparty $issuer;
            final /* synthetic */ Date $from;
            final /* synthetic */ Date $to;
            final /* synthetic */ Counterparty $subject;
            final /* synthetic */ PublicKey $publicKey;
            final /* synthetic */ List $domains;
            final /* synthetic */ List $ipAddresses;

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                ByteReadPacket byteReadPacket;
                Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                CertificatesKt.access$writeVersion($this$writeDerSequence, 2);
                CertificatesKt.access$writeAsnInt($this$writeDerSequence, this.$version);
                CertificatesKt.access$writeAlgorithmIdentifier($this$writeDerSequence, this.$algorithm);
                CertificatesKt.access$writeX509Counterparty($this$writeDerSequence, this.$issuer);
                CertificatesKt.access$writeDerSequence($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this){
                    final /* synthetic */ writeX509Info.1 this$0;

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                        CertificatesKt.access$writeDerUTCTime($this$writeDerSequence, this.this$0.$from);
                        CertificatesKt.access$writeDerGeneralizedTime($this$writeDerSequence, this.this$0.$to);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                CertificatesKt.access$writeX509Counterparty($this$writeDerSequence, this.$subject);
                Output output2 = $this$writeDerSequence;
                byte[] byArray = this.$publicKey.getEncoded();
                Intrinsics.checkExpressionValueIsNotNull(byArray, "publicKey.encoded");
                OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                $this$writeDerSequence.writeByte((byte)163);
                int headerSizeHint$iv = 0;
                boolean $i$f$buildPacket = false;
                BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
                try {
                    BytePacketBuilder $this$buildPacket = builder$iv;
                    boolean bl = false;
                    CertificatesKt.access$writeDerSequence($this$buildPacket, new Function1<BytePacketBuilder, Unit>(this){
                        final /* synthetic */ writeX509Info.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                            Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                            CertificatesKt.access$writeDerSequence($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this){
                                final /* synthetic */ writeX509Info$1$$special$$inlined$buildPacket$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }

                                public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                                    Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                                    CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getSubjectAltName());
                                    CertificatesKt.access$writeDerOctetString($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this){
                                        final /* synthetic */ writeX509Info$1$$special$$inlined$buildPacket$lambda$1$1 this$0;
                                        {
                                            this.this$0 = var1_1;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull BytePacketBuilder $this$writeDerOctetString) {
                                            Intrinsics.checkParameterIsNotNull($this$writeDerOctetString, "$receiver");
                                            CertificatesKt.access$writeDerSequence($this$writeDerOctetString, new Function1<BytePacketBuilder, Unit>(this){
                                                final /* synthetic */ writeX509Info$1$$special$$inlined$buildPacket$lambda$1$1$1 this$0;
                                                {
                                                    this.this$0 = var1_1;
                                                    super(1);
                                                }

                                                public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                                                    Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                                                    for (String domain : this.this$0.this$0.this$0.this$0.$domains) {
                                                        CertificatesKt.access$writeX509Extension($this$writeDerSequence, 2, new Function1<BytePacketBuilder, Unit>(domain){
                                                            final /* synthetic */ String $domain;
                                                            {
                                                                this.$domain = string;
                                                                super(1);
                                                            }

                                                            public final void invoke(@NotNull BytePacketBuilder $this$writeX509Extension) {
                                                                Intrinsics.checkParameterIsNotNull($this$writeX509Extension, "$receiver");
                                                                String $this$toByteArray$iv = this.$domain;
                                                                Output output2 = $this$writeX509Extension;
                                                                Charset charset$iv = Charsets.UTF_8;
                                                                boolean $i$f$toByteArray = false;
                                                                CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                                                                Intrinsics.checkExpressionValueIsNotNull(charsetEncoder, "charset.newEncoder()");
                                                                byte[] byArray = CharsetJVMKt.encodeToByteArray(charsetEncoder, $this$toByteArray$iv, 0, $this$toByteArray$iv.length());
                                                                OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                                                            }
                                                        });
                                                    }
                                                    for (InetAddress ip : this.this$0.this$0.this$0.this$0.$ipAddresses) {
                                                        CertificatesKt.access$writeX509Extension($this$writeDerSequence, 7, new Function1<BytePacketBuilder, Unit>(ip){
                                                            final /* synthetic */ InetAddress $ip;
                                                            {
                                                                this.$ip = inetAddress;
                                                                super(1);
                                                            }

                                                            public final void invoke(@NotNull BytePacketBuilder $this$writeX509Extension) {
                                                                Intrinsics.checkParameterIsNotNull($this$writeX509Extension, "$receiver");
                                                                Output output2 = $this$writeX509Extension;
                                                                byte[] byArray = this.$ip.getAddress();
                                                                Intrinsics.checkExpressionValueIsNotNull(byArray, "ip.address");
                                                                OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    });
                    byteReadPacket = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                ByteReadPacket extensions = byteReadPacket;
                CertificatesKt.access$writeDerLength($this$writeDerSequence, (int)extensions.getRemaining());
                $this$writeDerSequence.writePacket(extensions);
            }
            {
                this.$version = bigInteger;
                this.$algorithm = string;
                this.$issuer = counterparty;
                this.$from = date;
                this.$to = date2;
                this.$subject = counterparty2;
                this.$publicKey = publicKey;
                this.$domains = list;
                this.$ipAddresses = list2;
                super(1);
            }
        });
    }

    private static final void writeAlgorithmIdentifier(@NotNull BytePacketBuilder $this$writeAlgorithmIdentifier, String algorithm) {
        CertificatesKt.writeDerSequence($this$writeAlgorithmIdentifier, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(algorithm){
            final /* synthetic */ String $algorithm;

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                OID oid = OID.Companion.fromAlgorithm(this.$algorithm);
                CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, oid);
                CertificatesKt.access$writeDerNull($this$writeDerSequence);
            }
            {
                this.$algorithm = string;
                super(1);
            }
        });
    }

    private static final void writeX509Extension(@NotNull BytePacketBuilder $this$writeX509Extension, int id, Function1<? super BytePacketBuilder, Unit> builder) {
        ByteReadPacket byteReadPacket;
        $this$writeX509Extension.writeByte((byte)(0x80 | id));
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            builder.invoke($this$buildPacket);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet2 = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeX509Extension, (int)packet2.getRemaining());
        $this$writeX509Extension.writePacket(packet2);
    }

    private static final void writeX509NamePart(@NotNull BytePacketBuilder $this$writeX509NamePart, OID id, String value) {
        CertificatesKt.writeDerSet($this$writeX509NamePart, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(id, value){
            final /* synthetic */ OID $id;
            final /* synthetic */ String $value;

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSet) {
                Intrinsics.checkParameterIsNotNull($this$writeDerSet, "$receiver");
                CertificatesKt.access$writeDerSequence($this$writeDerSet, new Function1<BytePacketBuilder, Unit>(this){
                    final /* synthetic */ writeX509NamePart.1 this$0;

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                        CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, this.this$0.$id);
                        CertificatesKt.writeDerUTF8String$default($this$writeDerSequence, this.this$0.$value, 0, 2, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$id = oID;
                this.$value = string;
                super(1);
            }
        });
    }

    private static final void writeX509Counterparty(@NotNull BytePacketBuilder $this$writeX509Counterparty, Counterparty counterparty) {
        CertificatesKt.writeDerSequence($this$writeX509Counterparty, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(counterparty){
            final /* synthetic */ Counterparty $counterparty;

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                CharSequence charSequence = this.$counterparty.getCountry();
                boolean bl = false;
                if (charSequence.length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getCountryName(), this.$counterparty.getCountry());
                }
                charSequence = this.$counterparty.getOrganization();
                bl = false;
                if (charSequence.length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getOrganizationName(), this.$counterparty.getOrganization());
                }
                charSequence = this.$counterparty.getOrganizationUnit();
                bl = false;
                if (charSequence.length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getOrganizationalUnitName(), this.$counterparty.getOrganizationUnit());
                }
                charSequence = this.$counterparty.getCommonName();
                bl = false;
                if (charSequence.length() > 0) {
                    CertificatesKt.access$writeX509NamePart($this$writeDerSequence, OID.Companion.getCommonName(), this.$counterparty.getCommonName());
                }
            }
            {
                this.$counterparty = counterparty;
                super(1);
            }
        });
    }

    public static final void writeCertificate(@NotNull BytePacketBuilder $this$writeCertificate, @NotNull Counterparty issuer, @NotNull Counterparty subject, @NotNull KeyPair keyPair, @NotNull String algorithm, @NotNull Date from, @NotNull Date to, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull($this$writeCertificate, "$this$writeCertificate");
        Intrinsics.checkParameterIsNotNull(issuer, "issuer");
        Intrinsics.checkParameterIsNotNull(subject, "subject");
        Intrinsics.checkParameterIsNotNull(keyPair, "keyPair");
        Intrinsics.checkParameterIsNotNull(algorithm, "algorithm");
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(domains, "domains");
        Intrinsics.checkParameterIsNotNull(ipAddresses, "ipAddresses");
        boolean bl = to.after(from);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl6 = false;
            PublicKey publicKey = keyPair.getPublic();
            Intrinsics.checkExpressionValueIsNotNull(publicKey, "keyPair.public");
            CertificatesKt.writeX509Info($this$buildPacket, algorithm, issuer, subject, publicKey, from, to, domains, ipAddresses);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket certInfo = byteReadPacket;
        byte[] certInfoBytes = StringsKt.readBytes$default(certInfo, 0, 1, null);
        Signature signature2 = Signature.getInstance(algorithm);
        signature2.initSign(keyPair.getPrivate());
        signature2.update(certInfoBytes);
        byte[] signed = signature2.sign();
        CertificatesKt.writeDerSequence($this$writeCertificate, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(certInfoBytes, algorithm, signed){
            final /* synthetic */ byte[] $certInfoBytes;
            final /* synthetic */ String $algorithm;
            final /* synthetic */ byte[] $signed;

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                OutputKt.writeFully$default((Output)$this$writeDerSequence, this.$certInfoBytes, 0, 0, 6, null);
                CertificatesKt.access$writeDerSequence($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this){
                    final /* synthetic */ writeCertificate.1 this$0;

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkParameterIsNotNull($this$writeDerSequence, "$receiver");
                        CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.fromAlgorithm(this.this$0.$algorithm));
                        CertificatesKt.access$writeDerNull($this$writeDerSequence);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull(this.$signed, "signed");
                CertificatesKt.writeDerBitString$default($this$writeDerSequence, this.$signed, 0, 2, null);
            }
            {
                this.$certInfoBytes = byArray;
                this.$algorithm = string;
                this.$signed = byArray2;
                super(1);
            }
        });
    }

    private static final void writeVersion(@NotNull BytePacketBuilder $this$writeVersion, int v) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($this$writeVersion, 2, 0, false);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            CertificatesKt.writeAsnInt($this$buildPacket, v);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeVersion, (int)encoded.getRemaining());
        $this$writeVersion.writePacket(encoded);
    }

    static /* synthetic */ void writeVersion$default(BytePacketBuilder bytePacketBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        CertificatesKt.writeVersion(bytePacketBuilder, n);
    }

    private static final void writeDerOctetString(@NotNull BytePacketBuilder $this$writeDerOctetString, Function1<? super BytePacketBuilder, Unit> block2) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            block2.invoke($this$buildPacket);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerOctetString, 0, 4, true);
        CertificatesKt.writeDerLength($this$writeDerOctetString, (int)sub.getRemaining());
        $this$writeDerOctetString.writePacket(sub);
    }

    private static final void writeDerBitString(@NotNull BytePacketBuilder $this$writeDerBitString, Function1<? super BytePacketBuilder, Unit> block2) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            block2.invoke($this$buildPacket);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerBitString, 0, 3, true);
        CertificatesKt.writeDerLength($this$writeDerBitString, (int)sub.getRemaining() + 1);
        $this$writeDerBitString.writeByte((byte)0);
        $this$writeDerBitString.writePacket(sub);
    }

    private static final void writeDerBitString(@NotNull BytePacketBuilder $this$writeDerBitString, byte[] array, int unused) {
        int n = unused;
        n = 0 <= n && 7 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CertificatesKt.writeDerType($this$writeDerBitString, 0, 3, true);
        CertificatesKt.writeDerLength($this$writeDerBitString, array.length + 1);
        $this$writeDerBitString.writeByte((byte)unused);
        OutputKt.writeFully$default((Output)$this$writeDerBitString, array, 0, 0, 6, null);
    }

    static /* synthetic */ void writeDerBitString$default(BytePacketBuilder bytePacketBuilder, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        CertificatesKt.writeDerBitString(bytePacketBuilder, byArray, n);
    }

    private static final void writeDerUTCTime(@NotNull BytePacketBuilder $this$writeDerUTCTime, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        BytePacketBuilder bytePacketBuilder = $this$writeDerUTCTime;
        boolean bl = false;
        boolean bl2 = false;
        SimpleDateFormat $this$apply = simpleDateFormat;
        boolean bl3 = false;
        $this$apply.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        String string = simpleDateFormat2.format(date);
        Intrinsics.checkExpressionValueIsNotNull(string, "SimpleDateFormat(\"yyMMdd\u2026\"UTC\")\n    }.format(date)");
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, 23);
    }

    private static final void writeDerGeneralizedTime(@NotNull BytePacketBuilder $this$writeDerGeneralizedTime, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        BytePacketBuilder bytePacketBuilder = $this$writeDerGeneralizedTime;
        boolean bl = false;
        boolean bl2 = false;
        SimpleDateFormat $this$apply = simpleDateFormat;
        boolean bl3 = false;
        $this$apply.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        String string = simpleDateFormat2.format(date);
        Intrinsics.checkExpressionValueIsNotNull(string, "SimpleDateFormat(\"yyyyMM\u2026           date\n        )");
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, 24);
    }

    private static final void writeDerUTF8String(@NotNull BytePacketBuilder $this$writeDerUTF8String, String s, int type2) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            $this$buildPacket.writeStringUtf8(s);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerUTF8String, 0, type2, true);
        CertificatesKt.writeDerLength($this$writeDerUTF8String, (int)sub.getRemaining());
        $this$writeDerUTF8String.writePacket(sub);
    }

    static /* synthetic */ void writeDerUTF8String$default(BytePacketBuilder bytePacketBuilder, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 12;
        }
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, n);
    }

    private static final void writeDerNull(@NotNull BytePacketBuilder $this$writeDerNull) {
        $this$writeDerNull.writeShort((short)1280);
    }

    private static final void writeDerSequence(@NotNull BytePacketBuilder $this$writeDerSequence, Function1<? super BytePacketBuilder, Unit> block2) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            block2.invoke($this$buildPacket);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerSequence, 0, 16, false);
        CertificatesKt.writeDerLength($this$writeDerSequence, (int)sub.getRemaining());
        $this$writeDerSequence.writePacket(sub);
    }

    private static final void writeDerSet(@NotNull BytePacketBuilder $this$writeDerSet, Function1<? super BytePacketBuilder, Unit> block2) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            block2.invoke($this$buildPacket);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerSet, 0, 17, false);
        CertificatesKt.writeDerLength($this$writeDerSet, (int)sub.getRemaining());
        $this$writeDerSet.writePacket(sub);
    }

    private static final void writeDerObjectIdentifier(@NotNull BytePacketBuilder $this$writeDerObjectIdentifier, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($this$writeDerObjectIdentifier, identifier.getAsArray());
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDerObjectIdentifier(@NotNull BytePacketBuilder $this$writeDerObjectIdentifier, int[] identifier) {
        ByteReadPacket byteReadPacket;
        int n = identifier.length >= 2 ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = identifier[0];
        n = 0 <= n && 2 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = identifier[0] == 2 || 0 <= (n = identifier[1]) && 39 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (n == 0) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl7 = false;
            CertificatesKt.writeDerInt($this$buildPacket, identifier[0] * 40 + identifier[1]);
            int n2 = 2;
            int n3 = ArraysKt.getLastIndex(identifier);
            if (n2 <= n3) {
                while (true) {
                    void i;
                    CertificatesKt.writeDerInt($this$buildPacket, identifier[i]);
                    if (i == n3) break;
                    ++i;
                }
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerObjectIdentifier, 0, 6, true);
        CertificatesKt.writeDerLength($this$writeDerObjectIdentifier, (int)sub.getRemaining());
        $this$writeDerObjectIdentifier.writePacket(sub);
    }

    private static final void writeAsnInt(@NotNull BytePacketBuilder $this$writeAsnInt, BigInteger value) {
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        byte[] encoded = value.toByteArray();
        CertificatesKt.writeDerLength($this$writeAsnInt, encoded.length);
        Output output2 = $this$writeAsnInt;
        Intrinsics.checkExpressionValueIsNotNull(encoded, "encoded");
        OutputKt.writeFully$default(output2, encoded, 0, 0, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeAsnInt(@NotNull BytePacketBuilder $this$writeAsnInt, int value) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            boolean skip = true;
            int n = 0;
            int n2 = 3;
            while (n <= n2) {
                void idx;
                int part2 = value >>> (4 - idx - 1) * 8 & 0xFF;
                if (part2 != 0 || !skip) {
                    skip = false;
                    $this$buildPacket.writeByte((byte)part2);
                }
                ++idx;
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeAsnInt, (int)encoded.getRemaining());
        $this$writeAsnInt.writePacket(encoded);
    }

    private static final void writeDerLength(@NotNull BytePacketBuilder $this$writeDerLength, int length) {
        boolean bl = length >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (length <= 127) {
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 255) {
            $this$writeDerLength.writeByte((byte)129);
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 65535) {
            $this$writeDerLength.writeByte((byte)130);
            $this$writeDerLength.writeByte((byte)(length >>> 8));
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 0xFFFFFF) {
            $this$writeDerLength.writeByte((byte)131);
            $this$writeDerLength.writeByte((byte)(length >>> 16));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        } else {
            $this$writeDerLength.writeByte((byte)132);
            $this$writeDerLength.writeByte((byte)(length >>> 24));
            $this$writeDerLength.writeByte((byte)(length >>> 16 & 0xFF));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        }
    }

    private static final void writeDerType(@NotNull BytePacketBuilder $this$writeDerType, int kind, int typeIdentifier, boolean simpleType2) {
        int n = kind;
        n = 0 <= n && 3 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = typeIdentifier >= 0 ? 1 : 0;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = typeIdentifier;
        if (0 <= n && 30 >= n) {
            int singleByte = kind << 6 | typeIdentifier | (simpleType2 ? 0 : 32);
            byte byteValue = (byte)singleByte;
            $this$writeDerType.writeByte(byteValue);
        } else {
            int firstByte = kind << 6 | 0x1F | (simpleType2 ? 0 : 32);
            $this$writeDerType.writeByte((byte)firstByte);
            CertificatesKt.writeDerInt($this$writeDerType, typeIdentifier);
        }
    }

    private static final int derLength(int $this$derLength) {
        boolean bl = $this$derLength >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if ($this$derLength == 0) {
            return 0;
        }
        int mask = 127;
        int byteCount = 1;
        while (($this$derLength & mask) != $this$derLength) {
            mask |= mask << 7;
            ++byteCount;
        }
        return byteCount;
    }

    private static final void writeDerInt(@NotNull BytePacketBuilder $this$writeDerInt, int value) {
        boolean bl = value >= 0;
        boolean bl2 = false;
        int n = 0;
        n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int byteCount = CertificatesKt.derLength(value);
        bl2 = false;
        n = 0;
        n2 = byteCount;
        for (n = 0; n < n2; ++n) {
            int idx = n;
            boolean bl4 = false;
            int part2 = value >> (byteCount - idx - 1) * 7 & 0x7F;
            if (idx == byteCount - 1) {
                $this$writeDerInt.writeByte((byte)part2);
                continue;
            }
            $this$writeDerInt.writeByte((byte)(part2 | 0x80));
        }
    }

    public static final /* synthetic */ void access$writeVersion(BytePacketBuilder $this$access_u24writeVersion, int v) {
        CertificatesKt.writeVersion($this$access_u24writeVersion, v);
    }

    public static final /* synthetic */ void access$writeAsnInt(BytePacketBuilder $this$access_u24writeAsnInt, BigInteger value) {
        CertificatesKt.writeAsnInt($this$access_u24writeAsnInt, value);
    }

    public static final /* synthetic */ void access$writeAlgorithmIdentifier(BytePacketBuilder $this$access_u24writeAlgorithmIdentifier, String algorithm) {
        CertificatesKt.writeAlgorithmIdentifier($this$access_u24writeAlgorithmIdentifier, algorithm);
    }

    public static final /* synthetic */ void access$writeX509Counterparty(BytePacketBuilder $this$access_u24writeX509Counterparty, Counterparty counterparty) {
        CertificatesKt.writeX509Counterparty($this$access_u24writeX509Counterparty, counterparty);
    }

    public static final /* synthetic */ void access$writeDerSequence(BytePacketBuilder $this$access_u24writeDerSequence, Function1 block2) {
        CertificatesKt.writeDerSequence($this$access_u24writeDerSequence, block2);
    }

    public static final /* synthetic */ void access$writeDerUTCTime(BytePacketBuilder $this$access_u24writeDerUTCTime, Date date) {
        CertificatesKt.writeDerUTCTime($this$access_u24writeDerUTCTime, date);
    }

    public static final /* synthetic */ void access$writeDerGeneralizedTime(BytePacketBuilder $this$access_u24writeDerGeneralizedTime, Date date) {
        CertificatesKt.writeDerGeneralizedTime($this$access_u24writeDerGeneralizedTime, date);
    }

    public static final /* synthetic */ void access$writeDerObjectIdentifier(BytePacketBuilder $this$access_u24writeDerObjectIdentifier, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($this$access_u24writeDerObjectIdentifier, identifier);
    }

    public static final /* synthetic */ void access$writeDerOctetString(BytePacketBuilder $this$access_u24writeDerOctetString, Function1 block2) {
        CertificatesKt.writeDerOctetString($this$access_u24writeDerOctetString, block2);
    }

    public static final /* synthetic */ void access$writeX509Extension(BytePacketBuilder $this$access_u24writeX509Extension, int id, Function1 builder) {
        CertificatesKt.writeX509Extension($this$access_u24writeX509Extension, id, builder);
    }

    public static final /* synthetic */ void access$writeDerLength(BytePacketBuilder $this$access_u24writeDerLength, int length) {
        CertificatesKt.writeDerLength($this$access_u24writeDerLength, length);
    }

    public static final /* synthetic */ void access$writeDerNull(BytePacketBuilder $this$access_u24writeDerNull) {
        CertificatesKt.writeDerNull($this$access_u24writeDerNull);
    }

    public static final /* synthetic */ void access$writeX509NamePart(BytePacketBuilder $this$access_u24writeX509NamePart, OID id, String value) {
        CertificatesKt.writeX509NamePart($this$access_u24writeX509NamePart, id, value);
    }
}

