/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.moneta;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import org.javamoney.moneta.Money;

public class MonetaCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final MonetaCodec instance = new MonetaCodec();

    @Override
    public void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        Money money = (Money)object;
        if (money == null) {
            serializer2.writeNull();
            return;
        }
        SerializeWriter out2 = serializer2.out;
        out2.writeFieldValue('{', "numberStripped", money.getNumberStripped());
        out2.writeFieldValue(',', "currency", money.getCurrency().getCurrencyCode());
        out2.write(125);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type2, Object fieldName) {
        JSONObject object = parser.parseObject();
        Object currency = object.get("currency");
        String currencyCode = null;
        if (currency instanceof JSONObject) {
            currencyCode = ((JSONObject)currency).getString("currencyCode");
        } else if (currency instanceof String) {
            currencyCode = (String)currency;
        }
        Object numberStripped = object.get("numberStripped");
        if (numberStripped instanceof BigDecimal) {
            return (T)Money.of((BigDecimal)((BigDecimal)numberStripped), (CurrencyUnit)Monetary.getCurrency((String)currencyCode, (String[])new String[0]));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFastMatchToken() {
        return 0;
    }
}

