/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.NamedCurvesKt;
import io.ktor.network.tls.extensions.PointFormat;
import io.ktor.network.tls.extensions.PointFormatKt;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.network.tls.extensions.TLSExtensionType;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.io.ByteWriteChannel;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00042\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\"\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0001H\u0000\u001a$\u0010!\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\u001a\u0014\u0010'\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010(\u001a\u00020$H\u0000\u001a\u001d\u0010)\u001a\u00020\u001a*\u00020*2\u0006\u0010+\u001a\u00020,H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-\u001a\u001f\u0010.\u001a\u00020\u001a*\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0000\u00a2\u0006\u0002\u00102\u001a>\u00103\u001a\u00020\u001a*\u00020\u001b2\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00062\u0006\u0010%\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u00132\n\b\u0002\u00109\u001a\u0004\u0018\u00010\rH\u0000\u001a\u001c\u0010:\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u0014\u0010=\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010>\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"MAX_CURVES_QUANTITY", "", "MAX_SERVER_NAME_LENGTH", "buildECCurvesExtension", "Lkotlinx/io/core/ByteReadPacket;", "curves", "", "Lio/ktor/network/tls/extensions/NamedCurve;", "buildECPointFormatExtension", "formats", "Lio/ktor/network/tls/extensions/PointFormat;", "buildServerNameExtension", "name", "", "buildSignatureAlgorithmsExtension", "algorithms", "Lio/ktor/network/tls/extensions/HashAndSign;", "finished", "digest", "", "secretKey", "Ljavax/crypto/SecretKey;", "serverFinished", "handshakeHash", "length", "writeAligned", "", "Lkotlinx/io/core/BytePacketBuilder;", "src", "fieldSize", "writeECPoint", "point", "Ljava/security/spec/ECPoint;", "writeEncryptedPreMasterSecret", "preSecret", "publicKey", "Ljava/security/PublicKey;", "random", "Ljava/security/SecureRandom;", "writePublicKeyUncompressed", "key", "writeRecord", "Lkotlinx/coroutines/io/ByteWriteChannel;", "record", "Lio/ktor/network/tls/TLSRecord;", "(Lkotlinx/coroutines/io/ByteWriteChannel;Lio/ktor/network/tls/TLSRecord;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeTLSCertificates", "certificates", "", "Ljava/security/cert/X509Certificate;", "(Lkotlinx/io/core/BytePacketBuilder;[Ljava/security/cert/X509Certificate;)V", "writeTLSClientHello", "version", "Lio/ktor/network/tls/TLSVersion;", "suites", "Lio/ktor/network/tls/CipherSuite;", "sessionId", "serverName", "writeTLSHandshakeType", "type", "Lio/ktor/network/tls/TLSHandshakeType;", "writeTripleByteLength", "value", "ktor-network-tls"})
public final class RenderKt {
    private static final int MAX_SERVER_NAME_LENGTH = 32762;
    private static final int MAX_CURVES_QUANTITY = 16382;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object writeRecord(@NotNull ByteWriteChannel $this$writeRecord, @NotNull TLSRecord record, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof writeRecord.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RenderKt.writeRecord(null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var3_6 = false;
                var4_7 = false;
                $this$with = record;
                $i$a$-with-RenderKt$writeRecord$2 = false;
                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = record;
                $continuation.L$2 = $this$with;
                $continuation.label = 1;
                v0 = $this$writeRecord.writeByte((byte)$this$with.getType().getCode(), $continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $this$with = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl30:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = record;
                $continuation.L$2 = $this$with;
                $continuation.label = 2;
                v1 = $this$writeRecord.writeByte((byte)($this$with.getVersion().getCode() >> 8), $continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl44
            }
            case 2: {
                $this$with = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl44:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = record;
                $continuation.L$2 = $this$with;
                $continuation.label = 3;
                v2 = $this$writeRecord.writeByte((byte)$this$with.getVersion().getCode(), $continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl58
            }
            case 3: {
                $this$with = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl58:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = record;
                $continuation.L$2 = $this$with;
                $continuation.label = 4;
                v3 = $this$writeRecord.writeShort((short)$this$with.getPacket().getRemaining(), $continuation);
                if (v3 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl72
            }
            case 4: {
                $this$with = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl72:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = record;
                $continuation.L$2 = $this$with;
                $continuation.label = 5;
                v4 = $this$writeRecord.writePacket($this$with.getPacket(), $continuation);
                if (v4 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl86
            }
            case 5: {
                $this$with = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v4 = $result;
lbl86:
                // 2 sources

                $this$writeRecord.flush();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final void writeTLSHandshakeType(@NotNull BytePacketBuilder $this$writeTLSHandshakeType, @NotNull TLSHandshakeType type2, int length) {
        Intrinsics.checkParameterIsNotNull($this$writeTLSHandshakeType, "$this$writeTLSHandshakeType");
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        if (length > 0xFFFFFF) {
            throw (Throwable)new TLSException("TLS handshake size limit exceeded: " + length, null, 2, null);
        }
        int v = type2.getCode() << 24 | length;
        $this$writeTLSHandshakeType.writeInt(v);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeTLSClientHello(@NotNull BytePacketBuilder $this$writeTLSClientHello, @NotNull TLSVersion version, @NotNull List<CipherSuite> suites, @NotNull byte[] random, @NotNull byte[] sessionId, @Nullable String serverName) {
        int n;
        void $this$sumBy$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull($this$writeTLSClientHello, "$this$writeTLSClientHello");
        Intrinsics.checkParameterIsNotNull((Object)version, "version");
        Intrinsics.checkParameterIsNotNull(suites, "suites");
        Intrinsics.checkParameterIsNotNull(random, "random");
        Intrinsics.checkParameterIsNotNull(sessionId, "sessionId");
        $this$writeTLSClientHello.writeShort((short)version.getCode());
        OutputKt.writeFully$default((Output)$this$writeTLSClientHello, random, 0, 0, 6, null);
        int sessionIdLength = sessionId.length;
        if (sessionIdLength < 0 || sessionIdLength > 255 || sessionIdLength > sessionId.length) {
            throw (Throwable)new TLSException("Illegal sessionIdLength", null, 2, null);
        }
        $this$writeTLSClientHello.writeByte((byte)sessionIdLength);
        $this$writeTLSClientHello.writeFully(sessionId, 0, sessionIdLength);
        $this$writeTLSClientHello.writeShort((short)(suites.size() * 2));
        for (CipherSuite suite : suites) {
            $this$writeTLSClientHello.writeShort(suite.getCode());
        }
        $this$writeTLSClientHello.writeByte((byte)1);
        $this$writeTLSClientHello.writeByte((byte)0);
        ArrayList extensions = new ArrayList();
        Object object2 = extensions;
        ByteReadPacket byteReadPacket = RenderKt.buildSignatureAlgorithmsExtension$default(null, 1, null);
        boolean bl = false;
        object2.add(byteReadPacket);
        object2 = extensions;
        byteReadPacket = RenderKt.buildECCurvesExtension$default(null, 1, null);
        bl = false;
        object2.add(byteReadPacket);
        object2 = extensions;
        byteReadPacket = RenderKt.buildECPointFormatExtension$default(null, 1, null);
        bl = false;
        object2.add(byteReadPacket);
        String string = serverName;
        if (string != null) {
            object2 = string;
            boolean bl2 = false;
            bl = false;
            Object name2 = object2;
            boolean bl3 = false;
            object = extensions;
            ByteReadPacket byteReadPacket2 = RenderKt.buildServerNameExtension((String)name2);
            boolean bl4 = false;
            object.add(byteReadPacket2);
        }
        object2 = extensions;
        BytePacketBuilder bytePacketBuilder = $this$writeTLSClientHello;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            object = (ByteReadPacket)element$iv;
            n = sum$iv;
            boolean bl5 = false;
            int n2 = (int)it.getRemaining();
            sum$iv = n + n2;
        }
        n = sum$iv;
        bytePacketBuilder.writeShort((short)n);
        Iterator iterator2 = extensions.iterator();
        while (iterator2.hasNext()) {
            ByteReadPacket e;
            ByteReadPacket byteReadPacket3 = e = (ByteReadPacket)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(byteReadPacket3, "e");
            $this$writeTLSClientHello.writePacket(byteReadPacket3);
        }
    }

    public static /* synthetic */ void writeTLSClientHello$default(BytePacketBuilder bytePacketBuilder, TLSVersion tLSVersion, List list, byte[] byArray, byte[] byArray2, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        RenderKt.writeTLSClientHello(bytePacketBuilder, tLSVersion, list, byArray, byArray2, string);
    }

    public static final void writeTLSCertificates(@NotNull BytePacketBuilder $this$writeTLSCertificates, @NotNull X509Certificate[] certificates) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull($this$writeTLSCertificates, "$this$writeTLSCertificates");
        Intrinsics.checkParameterIsNotNull(certificates, "certificates");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            for (X509Certificate certificate : certificates) {
                byte[] certificateBytes;
                if (certificate.getEncoded() == null) {
                    Intrinsics.throwNpe();
                }
                RenderKt.writeTripleByteLength($this$buildPacket, certificateBytes.length);
                OutputKt.writeFully$default((Output)$this$buildPacket, certificateBytes, 0, 0, 6, null);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket chain = byteReadPacket;
        RenderKt.writeTripleByteLength($this$writeTLSCertificates, (int)chain.getRemaining());
        $this$writeTLSCertificates.writePacket(chain);
    }

    public static final void writeEncryptedPreMasterSecret(@NotNull BytePacketBuilder $this$writeEncryptedPreMasterSecret, @NotNull byte[] preSecret, @NotNull PublicKey publicKey, @NotNull SecureRandom random) {
        Intrinsics.checkParameterIsNotNull($this$writeEncryptedPreMasterSecret, "$this$writeEncryptedPreMasterSecret");
        Intrinsics.checkParameterIsNotNull(preSecret, "preSecret");
        Intrinsics.checkParameterIsNotNull(publicKey, "publicKey");
        Intrinsics.checkParameterIsNotNull(random, "random");
        boolean bl = preSecret.length == 48;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Cipher cipher2 = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (cipher2 == null) {
            Intrinsics.throwNpe();
        }
        Cipher rsaCipher = cipher2;
        rsaCipher.init(1, (Key)publicKey, random);
        byte[] encryptedSecret = rsaCipher.doFinal(preSecret);
        if (encryptedSecret.length > 65535) {
            throw (Throwable)new TLSException("Encrypted premaster secret is too long", null, 2, null);
        }
        $this$writeEncryptedPreMasterSecret.writeShort((short)encryptedSecret.length);
        Output output2 = $this$writeEncryptedPreMasterSecret;
        Intrinsics.checkExpressionValueIsNotNull(encryptedSecret, "encryptedSecret");
        OutputKt.writeFully$default(output2, encryptedSecret, 0, 0, 6, null);
    }

    @NotNull
    public static final ByteReadPacket finished(@NotNull byte[] digest, @NotNull SecretKey secretKey) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull(digest, "digest");
        Intrinsics.checkParameterIsNotNull(secretKey, "secretKey");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            byte[] prf = HashesKt.PRF(secretKey, KeysKt.getCLIENT_FINISHED_LABEL(), digest, 12);
            OutputKt.writeFully$default((Output)$this$buildPacket, prf, 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    @NotNull
    public static final byte[] serverFinished(@NotNull byte[] handshakeHash, @NotNull SecretKey secretKey, int length) {
        Intrinsics.checkParameterIsNotNull(handshakeHash, "handshakeHash");
        Intrinsics.checkParameterIsNotNull(secretKey, "secretKey");
        return HashesKt.PRF(secretKey, KeysKt.getSERVER_FINISHED_LABEL(), handshakeHash, length);
    }

    public static /* synthetic */ byte[] serverFinished$default(byte[] byArray, SecretKey secretKey, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 12;
        }
        return RenderKt.serverFinished(byArray, secretKey, n);
    }

    public static final void writePublicKeyUncompressed(@NotNull BytePacketBuilder $this$writePublicKeyUncompressed, @NotNull PublicKey key) {
        Intrinsics.checkParameterIsNotNull($this$writePublicKeyUncompressed, "$this$writePublicKeyUncompressed");
        Intrinsics.checkParameterIsNotNull(key, "key");
        PublicKey publicKey = key;
        if (!(publicKey instanceof ECPublicKey)) {
            throw (Throwable)new TLSException("Unsupported public key type: " + key, null, 2, null);
        }
        ECParameterSpec eCParameterSpec = ((ECPublicKey)key).getParams();
        Intrinsics.checkExpressionValueIsNotNull(eCParameterSpec, "key.params");
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        Intrinsics.checkExpressionValueIsNotNull(ellipticCurve, "key.params.curve");
        ECField eCField = ellipticCurve.getField();
        Intrinsics.checkExpressionValueIsNotNull(eCField, "key.params.curve.field");
        int fieldSize = eCField.getFieldSize();
        ECPoint eCPoint = ((ECPublicKey)key).getW();
        Intrinsics.checkExpressionValueIsNotNull(eCPoint, "key.w");
        RenderKt.writeECPoint($this$writePublicKeyUncompressed, eCPoint, fieldSize);
    }

    public static final void writeECPoint(@NotNull BytePacketBuilder $this$writeECPoint, @NotNull ECPoint point, int fieldSize) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull($this$writeECPoint, "$this$writeECPoint");
        Intrinsics.checkParameterIsNotNull(point, "point");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            $this$buildPacket.writeByte((byte)4);
            byte[] byArray = point.getAffineX().toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "point.affineX.toByteArray()");
            RenderKt.writeAligned($this$buildPacket, byArray, fieldSize);
            byte[] byArray2 = point.getAffineY().toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray2, "point.affineY.toByteArray()");
            RenderKt.writeAligned($this$buildPacket, byArray2, fieldSize);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket pointData = byteReadPacket;
        $this$writeECPoint.writeByte((byte)pointData.getRemaining());
        $this$writeECPoint.writePacket(pointData);
    }

    private static final ByteReadPacket buildSignatureAlgorithmsExtension(List<HashAndSign> algorithms) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            $this$buildPacket.writeShort(TLSExtensionType.SIGNATURE_ALGORITHMS.getCode());
            int size2 = algorithms.size();
            $this$buildPacket.writeShort((short)(2 + size2 * 2));
            $this$buildPacket.writeShort((short)(size2 * 2));
            Iterable $this$forEach$iv = algorithms;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HashAndSign it = (HashAndSign)element$iv;
                boolean bl2 = false;
                $this$buildPacket.writeByte(it.getHash().getCode());
                $this$buildPacket.writeByte(it.getSign().getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* synthetic */ ByteReadPacket buildSignatureAlgorithmsExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
        }
        return RenderKt.buildSignatureAlgorithmsExtension(list);
    }

    private static final ByteReadPacket buildServerNameExtension(String name2) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            boolean bl2 = name2.length() < 32762;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Server name length limit exceeded: at most 32762 characters allowed";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$buildPacket.writeShort(TLSExtensionType.SERVER_NAME.getCode());
            $this$buildPacket.writeShort((short)(name2.length() + 2 + 1 + 2));
            $this$buildPacket.writeShort((short)(name2.length() + 2 + 1));
            $this$buildPacket.writeByte((byte)0);
            $this$buildPacket.writeShort((short)name2.length());
            $this$buildPacket.writeStringUtf8(name2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    private static final ByteReadPacket buildECCurvesExtension(List<? extends NamedCurve> curves) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            boolean bl2 = curves.size() <= 16382;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Too many named curves provided: at most 16382 could be provided";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$buildPacket.writeShort(TLSExtensionType.ELLIPTIC_CURVES.getCode());
            int size2 = curves.size() * 2;
            $this$buildPacket.writeShort((short)(2 + size2));
            $this$buildPacket.writeShort((short)size2);
            Iterable $this$forEach$iv = curves;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NamedCurve it = (NamedCurve)((Object)element$iv);
                boolean bl6 = false;
                $this$buildPacket.writeShort(it.getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* synthetic */ ByteReadPacket buildECCurvesExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = NamedCurvesKt.getSupportedNamedCurves();
        }
        return RenderKt.buildECCurvesExtension(list);
    }

    private static final ByteReadPacket buildECPointFormatExtension(List<? extends PointFormat> formats) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            $this$buildPacket.writeShort(TLSExtensionType.EC_POINT_FORMAT.getCode());
            int size2 = formats.size();
            $this$buildPacket.writeShort((short)(1 + size2));
            $this$buildPacket.writeByte((byte)size2);
            Iterable $this$forEach$iv = formats;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PointFormat it = (PointFormat)((Object)element$iv);
                boolean bl2 = false;
                $this$buildPacket.writeByte(it.getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* synthetic */ ByteReadPacket buildECPointFormatExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = PointFormatKt.getSupportedPointFormats();
        }
        return RenderKt.buildECPointFormatExtension(list);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeAligned(@NotNull BytePacketBuilder $this$writeAligned, byte[] src, int fieldSize) {
        int n;
        int expectedSize;
        block3: {
            expectedSize = fieldSize + 7 >>> 3;
            byte[] $this$indexOfFirst$iv = src;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length;
            while (n2 < n3) {
                void index$iv;
                byte it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (it != (byte)0) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        int padding = expectedSize - (src.length - index);
        if (padding > 0) {
            OutputKt.writeFully$default((Output)$this$writeAligned, new byte[padding], 0, 0, 6, null);
        }
        $this$writeAligned.writeFully(src, index, src.length - index);
    }

    private static final void writeTripleByteLength(@NotNull BytePacketBuilder $this$writeTripleByteLength, int value) {
        int high = value >>> 16 & 0xFF;
        int low = value & 0xFFFF;
        $this$writeTripleByteLength.writeByte((byte)high);
        $this$writeTripleByteLength.writeShort((short)low);
    }
}

