/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.robot;

import com.alibaba.fastjson.JSON;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.mamoe.ex.content.RandomAccessHDImage;
import net.mamoe.ex.network.ExNetwork;
import net.mamoe.ex.network.connections.defaults.ExIPWhiteListSpider;
import net.mamoe.robot.AsyncTaskPool;
import net.mamoe.robot.CardUtil;
import net.mamoe.robot.NetworkUtil;
import net.mamoe.robot.ResponseObject;

public class Robot {
    private static Robot instance;
    private final long qq;
    private final Map<Long, HPictureSession> sessionMap = new LinkedHashMap<Long, HPictureSession>();
    public static final String ERROR_LINK = "https://i.loli.net/2019/08/05/usINjXSiZxrQJkT.jpg";
    public static final String TITLE_PICTURE_LINK = "https://i.loli.net/2019/08/04/B5ZMw1rdzVQI7Yv.jpg";
    private static volatile Consumer<String> picIdConsumer;

    public void sendGroupMessage(final long targetGroupId, final String message) {
        Robot.accessAPI("Api_SendMsg", new Object(){
            public long \u54cd\u5e94\u7684QQ;
            public int \u4fe1\u606f\u7c7b\u578b;
            public int \u53c2\u8003\u5b50\u7c7b\u578b;
            public long \u6536\u4fe1\u7fa4_\u8ba8\u8bba\u7ec4;
            public long \u6536\u4fe1\u5bf9\u8c61;
            public String \u5185\u5bb9;
            {
                this.\u54cd\u5e94\u7684QQ = Robot.this.getQq();
                this.\u4fe1\u606f\u7c7b\u578b = 2;
                this.\u53c2\u8003\u5b50\u7c7b\u578b = 0;
                this.\u6536\u4fe1\u5bf9\u8c61 = this.\u6536\u4fe1\u7fa4_\u8ba8\u8bba\u7ec4 = targetGroupId;
                this.\u5185\u5bb9 = message;
            }
        });
    }

    public void sendFriendMessage(final long targetQQ, final String message) {
        Robot.accessAPI("Api_SendMsg", new Object(){
            public long \u54cd\u5e94\u7684QQ;
            public int \u4fe1\u606f\u7c7b\u578b;
            public int \u53c2\u8003\u5b50\u7c7b\u578b;
            public long \u6536\u4fe1\u7fa4_\u8ba8\u8bba\u7ec4;
            public long \u6536\u4fe1\u5bf9\u8c61;
            public String \u5185\u5bb9;
            {
                this.\u54cd\u5e94\u7684QQ = Robot.this.getQq();
                this.\u4fe1\u606f\u7c7b\u578b = 1;
                this.\u53c2\u8003\u5b50\u7c7b\u578b = 0;
                this.\u6536\u4fe1\u5bf9\u8c61 = this.\u6536\u4fe1\u7fa4_\u8ba8\u8bba\u7ec4 = targetQQ;
                this.\u5185\u5bb9 = message;
            }
        });
    }

    public void sendGroupObjectMessage(final long targetGroupId, final String message) {
        Robot.accessAPI("Api_SendObjectMsg", new Object(){
            public long \u54cd\u5e94\u7684QQ;
            public int \u6536\u4fe1\u5bf9\u8c61\u7c7b\u578b;
            public int \u7ed3\u6784\u5b50\u7c7b\u578b;
            public long \u6536\u4fe1\u5bf9\u8c61\u6240\u5c5e\u7fa4_\u8ba8\u8bba\u7ec4;
            public long \u6536\u4fe1\u5bf9\u8c61QQ;
            public String objectMsg;
            {
                this.\u54cd\u5e94\u7684QQ = Robot.this.getQq();
                this.\u6536\u4fe1\u5bf9\u8c61\u7c7b\u578b = 2;
                this.\u7ed3\u6784\u5b50\u7c7b\u578b = 0;
                this.\u6536\u4fe1\u5bf9\u8c61QQ = this.\u6536\u4fe1\u5bf9\u8c61\u6240\u5c5e\u7fa4_\u8ba8\u8bba\u7ec4 = targetGroupId;
                this.objectMsg = message.replace("\"", "'");
            }
        });
    }

    public void sendFriendObjectMessage(final long targetQQ, final String message) {
        Robot.accessAPI("Api_SendObjectMsg", JSON.toJSONString((Object)new Object(){
            public long \u54cd\u5e94\u7684QQ;
            public int \u6536\u4fe1\u5bf9\u8c61\u7c7b\u578b;
            public int \u7ed3\u6784\u5b50\u7c7b\u578b;
            public long \u6536\u4fe1\u5bf9\u8c61\u6240\u5c5e\u7fa4_\u8ba8\u8bba\u7ec4;
            public long \u6536\u4fe1\u5bf9\u8c61QQ;
            public String objectMsg;
            {
                this.\u54cd\u5e94\u7684QQ = Robot.this.getQq();
                this.\u6536\u4fe1\u5bf9\u8c61\u7c7b\u578b = 1;
                this.\u7ed3\u6784\u5b50\u7c7b\u578b = 0;
                this.\u6536\u4fe1\u5bf9\u8c61QQ = this.\u6536\u4fe1\u5bf9\u8c61\u6240\u5c5e\u7fa4_\u8ba8\u8bba\u7ec4 = targetQQ;
                this.objectMsg = message.replace("\"", "'");
            }
        }));
    }

    public void uploadFriendPicture(final long qq, final byte[] data) {
        Robot.accessAPI("Api_UploadPic", JSON.toJSONString((Object)new Object(){
            public long \u54cd\u5e94\u7684QQ;
            public int \u53c2_\u4e0a\u4f20\u7c7b\u578b;
            public long \u53c2_\u53c2\u8003\u5bf9\u8c61;
            public byte[] \u53c2_\u56fe\u7247\u6570\u636e;
            {
                this.\u54cd\u5e94\u7684QQ = Robot.this.getQq();
                this.\u53c2_\u4e0a\u4f20\u7c7b\u578b = 1;
                this.\u53c2_\u53c2\u8003\u5bf9\u8c61 = qq;
                this.\u53c2_\u56fe\u7247\u6570\u636e = data;
            }
        }));
    }

    public void uploadGroupPicture(final long group, final byte[] data, Consumer<String> picIdConsumer) {
        Robot.picIdConsumer = picIdConsumer;
        try {
            Robot.accessAPI("Api_UploadPic", JSON.toJSONString((Object)new Object(){
                public long \u54cd\u5e94\u7684QQ;
                public int \u53c2_\u4e0a\u4f20\u7c7b\u578b;
                public long \u53c2_\u53c2\u8003\u5bf9\u8c61;
                public byte[] \u53c2_\u56fe\u7247\u6570\u636e;
                {
                    this.\u54cd\u5e94\u7684QQ = Robot.this.getQq();
                    this.\u53c2_\u4e0a\u4f20\u7c7b\u578b = 2;
                    this.\u53c2_\u53c2\u8003\u5bf9\u8c61 = group;
                    this.\u53c2_\u56fe\u7247\u6570\u636e = data;
                }
            }));
        }
        catch (Exception e) {
            picIdConsumer.accept(null);
        }
    }

    private void onReceiveGroupMessage(long group, long sender, String message) {
        message = message.replace("\u6765\u4e00\u4efd", "");
        message = message.replace("\u6211\u8981", "");
        message = message.replace("\u7ed9\u6211", "");
        message = message.replace("\u4e00\u4efd", "");
        message = message.replace("\u518d\u6765", "");
        message = message.replace("\u5173\u4e8e", "");
        message = message.replace("\u6709\u5173", "");
        message = message.replace("\u7684", "");
        message = message.replace("\u5f97", "");
        message = message.replace("\u5730", "");
        message = message.replace(" ", "");
        message = message.replace("@" + this.getQq(), "");
        if ((message = message.trim()).contains("\u8272\u56fe")) {
            if (message.startsWith("\u8272\u56fe")) {
                this.sessionMap.put(sender, new HPictureSession(group, sender, ""));
            } else {
                this.sessionMap.put(sender, new HPictureSession(group, sender, message.split("\u8272\u56fe")[0]));
            }
            return;
        }
        if (this.sessionMap.containsKey(sender)) {
            HPictureSession session = this.sessionMap.get(sender);
            if (message.contains("\u4e0d\u597d\u770b") || message.contains("\u96be\u770b") || message.contains("\u7ffb\u9875") || message.contains("\u4e0b\u4e00\u9875") || message.contains("\u50bb\u903c") || message.contains("\u5783\u573e") || message.contains("\u7caa") || message.contains("\u5c4e")) {
                session.reloadImage();
            }
            return;
        }
        switch (message) {
            case "\u4f20\u56fe": {
                break;
            }
        }
    }

    private void onReceivePrivateMessage(long sender, String message) {
        switch (message) {
            case "\u6d4b\u5361\u7247": {
                this.sendFriendMessage(sender, "ok");
                this.onReceiveGroupMessage(580266363L, sender, message);
                return;
            }
        }
        this.sendFriendMessage(sender, message);
    }

    public static void main(String[] args) throws IOException {
        Robot.startEventListening();
    }

    private static void startEventListening() throws IOException {
        HttpServer server = HttpServer.create(new InetSocketAddress(65321), 0);
        server.createContext("/api/ReceiveMahuaOutput", exchange -> {
            try {
                ResponseObject responseObject = (ResponseObject)JSON.toJavaObject((JSON)JSON.parseObject((String)new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8)), ResponseObject.class);
                block6 : switch (responseObject.getTypeCode()) {
                    case "EventFun": {
                        if (instance == null) break;
                        switch (responseObject.EventType) {
                            case 1: {
                                instance.onReceivePrivateMessage(responseObject.getEventOperator(), responseObject.getMessage());
                                break block6;
                            }
                            case 2: {
                                instance.onReceiveGroupMessage(responseObject.getFromNum(), responseObject.getEventOperator(), responseObject.getMessage());
                            }
                        }
                        break;
                    }
                    case "Api_UploadPicApiOut": {
                        if (picIdConsumer == null) break;
                        picIdConsumer.accept(responseObject.Result);
                        picIdConsumer = null;
                        break;
                    }
                    case "Api_GetRadomOnlineQQApiOut": {
                        long result = Long.parseLong(responseObject.Result);
                        if (result < 1000L) {
                            System.out.println("\u65e0\u53ef\u7528\u673a\u5668\u4eba\u8d26\u53f7");
                            System.exit(0);
                        }
                        instance = new Robot(result);
                        System.out.println("Loaded robot: " + result);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        server.start();
    }

    private static void accessAPI(String api, Object postBody) {
        postBody = postBody instanceof String ? postBody : JSON.toJSONString((Object)postBody);
        System.out.println(postBody);
        if (NetworkUtil.sendPostJSON("http://127.0.0.1:36524/api/v1/Mpq/" + api, (String)postBody) != 200) {
            throw new RuntimeException("FILED TO ACCESS API");
        }
        System.out.println("success");
        System.out.println();
    }

    public Robot(long qq) {
        this.qq = qq;
    }

    public static Robot getInstance() {
        return instance;
    }

    public long getQq() {
        return this.qq;
    }

    static {
        Robot.accessAPI("Api_GetRadomOnlineQQ", "");
        picIdConsumer = null;
    }

    private class HPictureSession
    implements Closeable {
        private long group;
        private long sender;
        private final String keyword;
        private RandomAccessHDImage hdImage;
        private int sentCount;
        private Future<RandomAccessHDImage> fetchTask;

        private HPictureSession(long group, long sender, String keyword) {
            AsyncTaskPool.submit(() -> {
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.close();
            });
            this.group = group;
            this.sender = sender;
            this.keyword = keyword;
            this.reloadImage();
        }

        private void reloadImage() {
            if (this.keyword.isEmpty()) {
                Robot.this.sendGroupMessage(this.group, String.format("[@%s] \u6b63\u5728\u641c\u5bfb\u968f\u673a\u8272\u56fe", this.sender));
            } else {
                Robot.this.sendGroupMessage(this.group, String.format("[@%s] \u6b63\u5728\u641c\u5bfb\u6709\u5173 %s \u7684\u8272\u56fe", this.sender, this.keyword));
            }
            try {
                if (!ExNetwork.doSpider(new ExIPWhiteListSpider()).get().booleanValue()) {
                    Robot.this.sendGroupMessage(this.group, String.format("[@%s] \u65e0\u6cd5\u8fde\u63a5EX", this.sender));
                    this.close();
                    return;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                this.close();
                return;
            }
            this.fetchTask = ExNetwork.getRandomImage(this.keyword, value -> {
                this.hdImage = value;
                if (this.hdImage == null) {
                    Robot.this.sendGroupObjectMessage(this.group, CardUtil.parseCard(Robot.ERROR_LINK, "\u6ca1\u627e\u5230", Robot.TITLE_PICTURE_LINK, "", Robot.ERROR_LINK));
                    this.close();
                } else {
                    this.hdImage.sendHDImage(Robot.this, this.group, this.sender);
                }
            });
        }

        @Override
        public void close() {
            this.hdImage = null;
            if (this.fetchTask != null && !this.fetchTask.isCancelled() && !this.fetchTask.isDone()) {
                this.fetchTask.cancel(true);
            }
            this.fetchTask = null;
            Robot.this.sessionMap.entrySet().removeIf(longHPictureSessionEntry -> longHPictureSessionEntry.getValue() == this);
        }

        public long getGroup() {
            return this.group;
        }

        public long getSender() {
            return this.sender;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public RandomAccessHDImage getHdImage() {
            return this.hdImage;
        }

        public int getSentCount() {
            return this.sentCount;
        }

        public Future<RandomAccessHDImage> getFetchTask() {
            return this.fetchTask;
        }

        public void setGroup(long group) {
            this.group = group;
        }

        public void setSender(long sender) {
            this.sender = sender;
        }

        public void setHdImage(RandomAccessHDImage hdImage) {
            this.hdImage = hdImage;
        }

        public void setSentCount(int sentCount) {
            this.sentCount = sentCount;
        }

        public void setFetchTask(Future<RandomAccessHDImage> fetchTask) {
            this.fetchTask = fetchTask;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HPictureSession)) {
                return false;
            }
            HPictureSession other = (HPictureSession)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getGroup() != other.getGroup()) {
                return false;
            }
            if (this.getSender() != other.getSender()) {
                return false;
            }
            String this$keyword = this.getKeyword();
            String other$keyword = other.getKeyword();
            if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
                return false;
            }
            RandomAccessHDImage this$hdImage = this.getHdImage();
            RandomAccessHDImage other$hdImage = other.getHdImage();
            if (this$hdImage == null ? other$hdImage != null : !((Object)this$hdImage).equals(other$hdImage)) {
                return false;
            }
            if (this.getSentCount() != other.getSentCount()) {
                return false;
            }
            Future<RandomAccessHDImage> this$fetchTask = this.getFetchTask();
            Future<RandomAccessHDImage> other$fetchTask = other.getFetchTask();
            return !(this$fetchTask == null ? other$fetchTask != null : !this$fetchTask.equals(other$fetchTask));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HPictureSession;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $group = this.getGroup();
            result = result * 59 + (int)($group >>> 32 ^ $group);
            long $sender = this.getSender();
            result = result * 59 + (int)($sender >>> 32 ^ $sender);
            String $keyword = this.getKeyword();
            result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
            RandomAccessHDImage $hdImage = this.getHdImage();
            result = result * 59 + ($hdImage == null ? 43 : ((Object)$hdImage).hashCode());
            result = result * 59 + this.getSentCount();
            Future<RandomAccessHDImage> $fetchTask = this.getFetchTask();
            result = result * 59 + ($fetchTask == null ? 43 : $fetchTask.hashCode());
            return result;
        }

        public String toString() {
            return "Robot.HPictureSession(group=" + this.getGroup() + ", sender=" + this.getSender() + ", keyword=" + this.getKeyword() + ", hdImage=" + this.getHdImage() + ", sentCount=" + this.getSentCount() + ", fetchTask=" + this.getFetchTask() + ")";
        }
    }
}

