/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.robot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class NetworkUtil {
    public static int sendPostJSON(String url, String JSON) {
        try {
            return Jsoup.connect((String)url).requestBody(JSON).header("Content-Type", "application/json").method(Connection.Method.POST).execute().statusCode();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static String uploadLocal(InputStream stream) throws IOException {
        String filename = "/images/" + System.currentTimeMillis() + Math.random() * 1000.0 + ".png";
        stream.transferTo(new FileOutputStream("." + filename));
        ImageFileManager.traceFile(new File("." + filename));
        return "http://mamoe.net:61435" + filename;
    }

    public static String uploadSMMS(InputStream stream) throws IOException {
        String local = NetworkUtil.uploadLocal(stream);
        if (local != null) {
            return local;
        }
        String response = Jsoup.connect((String)"https://sm.ms/api/v2/upload").header("Content-Type", "multipart/form-data").data("smfile", (double)System.currentTimeMillis() + Math.random() * 1000.0 + ".png", stream).data("Authorization", "14ac5499cfdd2bb2859e4476d2e5b1d2bad079bf").data("format", "xml").method(Connection.Method.POST).execute().body();
        if (!"success".equals(NetworkUtil.getStringCentre(response, "<code>", "</code>"))) {
            System.out.println(response);
            return null;
        }
        return NetworkUtil.getStringCentre(response, "<url>", "</url>");
    }

    private static String getStringCentre(String string, String prefix, String suffix) {
        String[] p = string.split(prefix);
        if (p.length == 1) {
            return null;
        }
        String[] s = p[1].split(suffix);
        if (s.length == 1) {
            return null;
        }
        return s[0];
    }

    static {
        ImageFileManager.refreshFileStatus(new File("./images/"));
    }

    private static final class ImageFileManager
    extends Thread {
        private static final List<File> files = new LinkedList<File>();

        private ImageFileManager() {
        }

        private static void refreshFileStatus(File baseDir) {
            File[] files = baseDir.listFiles();
            if (files == null) {
                if (!baseDir.mkdirs()) {
                    System.out.println("\u65e0\u6cd5\u521b\u5efa\u56fe\u5e8a\u76ee\u5f55");
                    System.exit(0);
                } else {
                    ImageFileManager.refreshFileStatus(baseDir);
                    return;
                }
            }
            ImageFileManager.files.addAll(List.of(files));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void traceFile(File file) {
            List<File> list = files;
            synchronized (list) {
                files.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            List<File> list = files;
            synchronized (list) {
                while (true) {
                    files.removeIf(file -> {
                        if (System.currentTimeMillis() - file.lastModified() > 3600000L) {
                            if (!file.delete()) {
                                System.out.println("\u65e0\u6cd5\u5220\u9664\u8fc7\u671f\u7684\u56fe\u7247\u6587\u4ef6: " + file.getName());
                            }
                            return true;
                        }
                        return false;
                    });
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }
}

