/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.robot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class AsyncTaskPool {
    private static ExecutorService executorService;

    private static ExecutorService createExecutorService() {
        return new ThreadPoolExecutor(16, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), Executors.defaultThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy()){};
    }

    public static void asyncWait(long millis, Runnable runnable) {
        AsyncTaskPool.submit(() -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                return;
            }
            AsyncTaskPool.submit(runnable);
        });
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return AsyncTaskPool.submit(task, null);
    }

    public static <T> Future<T> submit(Callable<T> task, T valueWhenError) {
        return executorService.submit(() -> {
            try {
                return task.call();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return valueWhenError;
            }
        });
    }

    public static <T> Future<T> submit(Callable<T> task, Consumer<T> callback) {
        return executorService.submit(() -> {
            try {
                Object result = task.call();
                callback.accept(result);
                return result;
            }
            catch (Throwable e) {
                e.printStackTrace();
                callback.accept(null);
                return null;
            }
        });
    }

    public static <T> Future<T> submit(Runnable task, T result) {
        return executorService.submit(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        });
    }

    public static <T> Future<T> submit(Runnable task, Runnable callback) {
        return executorService.submit(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            callback.run();
            return null;
        });
    }

    public static Future<?> submit(Runnable task) {
        return executorService.submit(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void init() {
        executorService = AsyncTaskPool.createExecutorService();
    }

    public static void shutdown() {
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    static {
        AsyncTaskPool.init();
    }
}

