/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.ex.network.connections.defaults;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.mamoe.ex.content.ImageSet;
import net.mamoe.ex.network.connections.ExSpider;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ImageSetsSearchSpider
extends ExSpider<List<ImageSet>> {
    private String keyword;
    private int minStar;
    private static final Set<String> blackList = Set.of("miku", "hatsunemiku", "\u521d\u97f3\u672a\u6765", "\u521d\u97f3\u30df\u30af", "vocaloid", "\u521d\u97f3");

    public ImageSetsSearchSpider() {
        this("", 5);
    }

    public ImageSetsSearchSpider(String keyword) {
        this(keyword, 5);
    }

    public ImageSetsSearchSpider(String keyword, int minStar) {
        this.keyword = keyword;
        this.minStar = minStar;
    }

    public static List<ImageSet> fetch(String keyword, int minStar) {
        ImageSetsSearchSpider setsSearchSpider = new ImageSetsSearchSpider(keyword, minStar);
        setsSearchSpider.initConnection();
        return setsSearchSpider.fetch();
    }

    @Override
    public void initConnection() {
        String url = "https://exhentai.org/?f_cats=991&advsearch=1&f_sname=on&f_stags=on&f_sr=on&f_srdd=" + this.minStar + "&f_spf=&f_spt=&";
        if (!this.keyword.equals("")) {
            url = url + "f_search=" + this.keyword;
        }
        this.setConnection(Jsoup.connect((String)url).method(Connection.Method.GET));
    }

    @Override
    public List<ImageSet> fetch() {
        String toKeywordCheck = this.keyword.toLowerCase().replace(" ", "");
        if (blackList.contains(toKeywordCheck)) {
            return Collections.emptyList();
        }
        ArrayList<ImageSet> setList = new ArrayList<ImageSet>(25);
        try {
            Document document = this.getConnection().get();
            Elements elements = document.body().getElementsByClass("itg");
            if (elements.size() == 0) {
                return null;
            }
            elements = ((Element)elements.get(0)).getElementsByTag("tr");
            int count = 0;
            for (Element element : elements) {
                Elements infos;
                if (++count == 1 || count == 26) continue;
                ImageSet set = new ImageSet();
                set.setImageCount(Integer.parseInt(((Element)element.getElementsByClass("glthumb").get(0)).getAllElements().eachText().stream().filter(a -> a.split(" ").length == 6 && a.split(" ")[5].equals("pages")).findAny().orElse("-1 -1 -1 -1 -1 -1").split(" ")[4]));
                Elements images = element.getElementsByTag("img");
                if (images.size() == 2) {
                    String dataSrc = ((Element)images.get(0)).attr("data-src");
                    if (dataSrc.equals("")) {
                        dataSrc = ((Element)images.get(0)).attr("src");
                    }
                    if (dataSrc.equals("")) {
                        dataSrc = ((Element)images.get(0)).attr("abs:src");
                    }
                    set.setImageSetCover(dataSrc);
                    set.setImageSetName(((Element)images.get(0)).attr("title"));
                }
                if ((infos = element.getElementsByClass("glname")).size() == 1) {
                    set.setImageSetUrl(((Element)infos.get(0)).getElementsByTag("a").attr("href"));
                    set.setTags(((Element)infos.get(0)).getElementsByClass("gt").eachText());
                }
                setList.add(set);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return setList;
    }

    @Override
    public void close() {
        super.close();
        this.keyword = null;
    }
}

