/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.ex.network.connections.defaults;

import java.io.IOException;
import java.util.HashMap;
import net.mamoe.ex.content.ImageEntry;
import net.mamoe.ex.content.ImageSet;
import net.mamoe.ex.network.connections.ExSpider;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ImageSetsLoadImageEntrySpider
extends ExSpider<ImageSet> {
    private volatile ImageSet set;
    private volatile int page = -1;

    public ImageSetsLoadImageEntrySpider(ImageSet set) {
        this.set = set;
    }

    public ImageSetsLoadImageEntrySpider(ImageSet set, int page) {
        this.set = set;
        this.page = page;
    }

    @Override
    public void initConnection() {
        if (this.set.getImageSetUrl() == null || this.set.getImageSetUrl().equals("")) {
            System.err.println("IMAGE SET " + this.set + "have a empty URL");
            this.set = null;
            return;
        }
        if (this.page == -1) {
            this.setConnection(Jsoup.connect((String)(this.set.getImageSetUrl() + "??inline_set=ts_l&p=" + this.set.getLoadEntryPage().getAndAdd(1))).method(Connection.Method.GET));
        } else {
            this.setConnection(Jsoup.connect((String)(this.set.getImageSetUrl() + "??inline_set=ts_l&p=" + this.page)).method(Connection.Method.GET));
        }
    }

    @Override
    public ImageSet fetch() {
        if (this.getConnection() != null) {
            try {
                Document document = this.getConnection().get();
                Elements elements = document.body().getElementsByClass("gdtl");
                if (elements.size() == 0) {
                    elements = document.body().getElementsByClass("gdtm");
                }
                if (this.set.getImageEntries() == null) {
                    this.set.setImageEntries(new HashMap<String, ImageEntry>());
                }
                for (Element element : elements) {
                    String key = "";
                    Element img = (Element)element.getElementsByTag("img").get(0);
                    ImageEntry entry = new ImageEntry(img.attr("src"), element.getElementsByTag("a").attr("href"));
                    key = img.attr("alt");
                    this.set.getImageEntries().put(key, entry);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.set;
    }

    @Override
    public void close() {
        super.close();
        this.set = null;
    }
}

