/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.ex.network.connections.defaults;

import java.io.IOException;
import net.mamoe.ex.content.HDImage;
import net.mamoe.ex.content.ImageEntry;
import net.mamoe.ex.network.connections.ExSpider;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class ImageEntryLoadHDImageSpider
extends ExSpider<HDImage> {
    private String entryUrl;

    public ImageEntryLoadHDImageSpider(ImageEntry entry) {
        this(entry.getEntryUrl());
    }

    public ImageEntryLoadHDImageSpider(String entryUrl) {
        this.entryUrl = entryUrl;
    }

    @Override
    public void initConnection() {
        if (this.entryUrl == null || this.entryUrl.equals("")) {
            System.err.println("IMAGE Entry URL" + this.entryUrl + "have a empty URL");
            this.entryUrl = null;
            return;
        }
        this.setConnection(Jsoup.connect((String)this.entryUrl).method(Connection.Method.GET));
    }

    @Override
    public HDImage fetch() {
        HDImage image = new HDImage();
        if (this.entryUrl != null) {
            try {
                Document document = this.getConnection().get();
                Element img = document.body().getElementById("img");
                image.setUrl(img.attr("src"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    @Override
    public void close() {
        super.close();
        this.entryUrl = null;
    }
}

