/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.ex.network.connections.defaults;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.mamoe.ex.content.HDImage;
import net.mamoe.ex.network.connections.ExSpider;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class DownloadHDImageToFileSpider
extends ExSpider<Boolean> {
    private volatile HDImage hdImage;
    private volatile File file;

    public DownloadHDImageToFileSpider(HDImage image, File file) {
        this.hdImage = image;
        this.file = file;
    }

    @Override
    public void initConnection() {
        if (this.hdImage.getUrl() == null || this.hdImage.getUrl().equals("")) {
            System.err.println("HDIMAGE Entry" + this.hdImage + "have a empty URL");
            this.hdImage = null;
            return;
        }
        this.setConnection(Jsoup.connect((String)this.hdImage.getUrl()).method(Connection.Method.GET).ignoreContentType(true));
    }

    @Override
    public Boolean fetch() {
        if (this.file.getParentFile().isDirectory() && !this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        try {
            Connection.Response response = this.getConnection().execute();
            byte[] img = response.bodyAsBytes();
            BufferedOutputStream bos = null;
            FileOutputStream fos = null;
            fos = new FileOutputStream(this.file);
            bos = new BufferedOutputStream(fos);
            bos.write(img);
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

