/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.ex.network;

import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.mamoe.common.ExConfig;
import net.mamoe.ex.content.HDImage;
import net.mamoe.ex.content.ImageEntry;
import net.mamoe.ex.content.ImageSet;
import net.mamoe.ex.content.RandomAccessHDImage;
import net.mamoe.ex.network.connections.ExSpider;
import net.mamoe.ex.network.connections.defaults.DownloadHDImageToFileSpider;
import net.mamoe.ex.network.connections.defaults.ImageEntryLoadHDImageSpider;
import net.mamoe.ex.network.connections.defaults.ImageSetLoadPageCountSpider;
import net.mamoe.ex.network.connections.defaults.ImageSetsLoadImageEntrySpider;
import net.mamoe.ex.network.connections.defaults.ImageSetsSearchSpider;
import org.jetbrains.annotations.Nullable;

public class ExNetwork {
    private static ExecutorService service = Executors.newFixedThreadPool(30);

    public static <T> Future<T> doSpider(ExSpider<T> spider) {
        return service.submit(() -> ExNetwork.initSpider(spider).fetch());
    }

    public static <T> Future<T> asyncSpider(ExSpider<T> spider, Consumer<T> callback) {
        return service.submit(() -> {
            Object ret = ExNetwork.initSpider(spider).fetch();
            callback.accept(ret);
            return ret;
        });
    }

    public static <T> ExSpider<T> initSpider(ExSpider<T> spider) {
        if (spider.getConnection() == null) {
            spider.initConnection();
        }
        spider.getConnection().userAgent("Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Mobile Safari/537.36").cookies(ExConfig.getUserCookies()).timeout(20000);
        return spider;
    }

    public static Future<RandomAccessHDImage> getRandomImage(String keyword) {
        return ExNetwork.getRandomImage(keyword, null);
    }

    public static Future<RandomAccessHDImage> getRandomImage(String keyword, RandomAccessHDImageCallback callback) {
        return ExNetwork.getRandomImage(keyword, 5, callback);
    }

    public static Future<RandomAccessHDImage> getRandomImage(String keyword, int minStar, RandomAccessHDImageCallback callback) {
        return service.submit(() -> {
            try {
                List<ImageSet> setList = ExNetwork.initSpider(new ImageSetsSearchSpider(keyword, minStar)).fetch();
                if (setList == null && (setList = ExNetwork.initSpider(new ImageSetsSearchSpider(keyword, 5)).fetch()) == null) {
                    setList = ExNetwork.initSpider(new ImageSetsSearchSpider(keyword, 0)).fetch();
                }
                if (setList == null || setList.size() == 0) {
                    System.err.println("unknown error = 0001");
                    callback.accept(null);
                    return null;
                }
                ImageSet set = setList.size() == 1 ? setList.get(0) : setList.get(new Random().nextInt(setList.size() - 1));
                int toLoad = new Random().nextInt(set.getMaxLoadEntryPage());
                if ((set = ExNetwork.initSpider(new ImageSetsLoadImageEntrySpider(set, toLoad)).fetch()).getImageEntries() == null) {
                    System.err.println("unknown error = 0002");
                    callback.accept(null);
                    return null;
                }
                String[] keys = set.getImageEntries().keySet().toArray(new String[0]);
                String randomKey = keys[new Random().nextInt(keys.length - 1)];
                ImageEntry entry = set.getImageEntries().get(randomKey);
                HDImage image = ExNetwork.initSpider(new ImageEntryLoadHDImageSpider(entry)).fetch();
                RandomAccessHDImage hdImage = new RandomAccessHDImage();
                hdImage.setImageSetName(set.getImageSetName());
                hdImage.setTags(set.getTags());
                hdImage.setUrl(image.getUrl());
                if (callback != null) {
                    callback.accept(hdImage);
                }
                return hdImage;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public static boolean downloadAllSet(String url, String dir) {
        ImageSet set = new ImageSet();
        set.setImageSetUrl(url);
        try {
            set = ExNetwork.doSpider(new ImageSetLoadPageCountSpider(set)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (set.getImageCount() <= 0) {
            return false;
        }
        System.out.println("ready to download " + set.getImageCount() + " file");
        AtomicInteger integer = new AtomicInteger(0);
        if (!((String)dir).endsWith("/")) {
            dir = (String)dir + "/";
        }
        for (int i = 0; i <= set.getMaxLoadEntryPage(); ++i) {
            ExNetwork.asyncSpider(new ImageSetsLoadImageEntrySpider(set, integer.getAndAdd(1)), a -> {
                System.out.println("loading entry in page " + integer.get());
                integer.getAndAdd(-1);
            });
        }
        while (integer.get() != 0) {
            System.out.println("waiting..");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int toDownload = set.getImageCount();
        AtomicInteger download = new AtomicInteger();
        Object finalDir = dir;
        set.getImageEntries().forEach((arg_0, arg_1) -> ExNetwork.lambda$downloadAllSet$6((String)finalDir, download, arg_0, arg_1));
        while (toDownload != download.get()) {
            System.out.print("\rdownloading..(" + download.get() + "/" + toDownload + ")..............");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static /* synthetic */ void lambda$downloadAllSet$6(String finalDir, AtomicInteger download, String a, ImageEntry b) {
        String path = finalDir + a + ".jpg";
        if (new File(path).exists()) {
            download.addAndGet(1);
        } else {
            ExNetwork.asyncSpider(new ImageEntryLoadHDImageSpider(b), hd -> ExNetwork.asyncSpider(new DownloadHDImageToFileSpider((HDImage)hd, new File(finalDir + a + ".jpg")), d -> {
                download.addAndGet(1);
                if (!d.booleanValue()) {
                    System.out.println("download [1] file failed");
                }
            }));
        }
    }

    public static interface RandomAccessHDImageCallback
    extends Consumer<RandomAccessHDImage> {
        @Override
        public void accept(@Nullable RandomAccessHDImage var1);
    }
}

