/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.ex.content;

import java.util.List;
import net.mamoe.ex.content.HDImage;
import net.mamoe.ex.network.ExNetwork;
import net.mamoe.ex.network.connections.defaults.DownloadHDImageStreamSpider;
import net.mamoe.robot.AsyncTaskPool;
import net.mamoe.robot.Robot;

public class RandomAccessHDImage
extends HDImage {
    private String imageSetName;
    private List<String> tags;

    public void sendHDImage(Robot robot, long group, long sender) {
        if (this.getPicId() != null) {
            this.sendHDImageMessage(robot, group, sender);
            return;
        }
        AsyncTaskPool.submit(() -> {
            try {
                robot.uploadGroupPicture(group, ExNetwork.doSpider(new DownloadHDImageStreamSpider(this)).get().readAllBytes(), id -> {
                    this.setPicId((String)id);
                    this.sendHDImageMessage(robot, group, sender);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void sendHDImageMessage(Robot robot, long group, long sender) {
        robot.sendGroupMessage(group, String.format("[@%s] " + this.getPicId(), sender));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomAccessHDImage)) {
            return false;
        }
        RandomAccessHDImage other = (RandomAccessHDImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$imageSetName = this.getImageSetName();
        String other$imageSetName = other.getImageSetName();
        if (this$imageSetName == null ? other$imageSetName != null : !this$imageSetName.equals(other$imageSetName)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RandomAccessHDImage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $imageSetName = this.getImageSetName();
        result = result * 59 + ($imageSetName == null ? 43 : $imageSetName.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String getImageSetName() {
        return this.imageSetName;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setImageSetName(String imageSetName) {
        this.imageSetName = imageSetName;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public String toString() {
        return "RandomAccessHDImage(imageSetName=" + this.getImageSetName() + ", tags=" + this.getTags() + ")";
    }
}

