/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/ktor/http/HttpProtocolVersion;", "", "name", "", "major", "", "minor", "(Ljava/lang/String;II)V", "getMajor", "()I", "getMinor", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "ktor-http"})
public final class HttpProtocolVersion {
    @NotNull
    private final String name;
    private final int major;
    private final int minor;
    @NotNull
    private static final HttpProtocolVersion HTTP_2_0;
    @NotNull
    private static final HttpProtocolVersion HTTP_1_1;
    @NotNull
    private static final HttpProtocolVersion HTTP_1_0;
    @NotNull
    private static final HttpProtocolVersion SPDY_3;
    @NotNull
    private static final HttpProtocolVersion QUIC;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.name + '/' + this.major + '.' + this.minor;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public HttpProtocolVersion(@NotNull String name2, int major, int minor) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        this.name = name2;
        this.major = major;
        this.minor = minor;
    }

    static {
        Companion = new Companion(null);
        HTTP_2_0 = new HttpProtocolVersion("HTTP", 2, 0);
        HTTP_1_1 = new HttpProtocolVersion("HTTP", 1, 1);
        HTTP_1_0 = new HttpProtocolVersion("HTTP", 1, 0);
        SPDY_3 = new HttpProtocolVersion("SPDY", 3, 0);
        QUIC = new HttpProtocolVersion("QUIC", 1, 0);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.major;
    }

    public final int component3() {
        return this.minor;
    }

    @NotNull
    public final HttpProtocolVersion copy(@NotNull String name2, int major, int minor) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        return new HttpProtocolVersion(name2, major, minor);
    }

    public static /* synthetic */ HttpProtocolVersion copy$default(HttpProtocolVersion httpProtocolVersion, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = httpProtocolVersion.name;
        }
        if ((n3 & 2) != 0) {
            n = httpProtocolVersion.major;
        }
        if ((n3 & 4) != 0) {
            n2 = httpProtocolVersion.minor;
        }
        return httpProtocolVersion.copy(string, n, n2);
    }

    public int hashCode() {
        String string = this.name;
        return ((string != null ? string.hashCode() : 0) * 31 + this.major) * 31 + this.minor;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HttpProtocolVersion)) break block3;
                HttpProtocolVersion httpProtocolVersion = (HttpProtocolVersion)object;
                if (!Intrinsics.areEqual(this.name, httpProtocolVersion.name) || this.major != httpProtocolVersion.major || this.minor != httpProtocolVersion.minor) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lio/ktor/http/HttpProtocolVersion$Companion;", "", "()V", "HTTP_1_0", "Lio/ktor/http/HttpProtocolVersion;", "getHTTP_1_0", "()Lio/ktor/http/HttpProtocolVersion;", "HTTP_1_1", "getHTTP_1_1", "HTTP_2_0", "getHTTP_2_0", "QUIC", "getQUIC", "SPDY_3", "getSPDY_3", "fromValue", "name", "", "major", "", "minor", "parse", "value", "", "ktor-http"})
    public static final class Companion {
        @NotNull
        public final HttpProtocolVersion getHTTP_2_0() {
            return HTTP_2_0;
        }

        @NotNull
        public final HttpProtocolVersion getHTTP_1_1() {
            return HTTP_1_1;
        }

        @NotNull
        public final HttpProtocolVersion getHTTP_1_0() {
            return HTTP_1_0;
        }

        @NotNull
        public final HttpProtocolVersion getSPDY_3() {
            return SPDY_3;
        }

        @NotNull
        public final HttpProtocolVersion getQUIC() {
            return QUIC;
        }

        @NotNull
        public final HttpProtocolVersion fromValue(@NotNull String name2, int major, int minor) {
            Intrinsics.checkParameterIsNotNull(name2, "name");
            return Intrinsics.areEqual(name2, "HTTP") && major == 1 && minor == 1 ? this.getHTTP_1_1() : (Intrinsics.areEqual(name2, "HTTP") && major == 2 && minor == 0 ? this.getHTTP_2_0() : new HttpProtocolVersion(name2, major, minor));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HttpProtocolVersion parse(@NotNull CharSequence value) {
            void protocol;
            void major;
            Intrinsics.checkParameterIsNotNull(value, "value");
            List list = StringsKt.split$default(value, new String[]{"/", "."}, false, 0, 6, null);
            boolean bl = false;
            boolean bl2 = false;
            List it = list;
            boolean bl3 = false;
            boolean bl4 = it.size() == 3;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Failed to parse HttpProtocolVersion. Expected format: protocol/major.minor, but actual: " + value;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object object = list;
            list = object;
            bl = false;
            String string = (String)list.get(0);
            list = object;
            bl = false;
            String string2 = (String)list.get(1);
            list = object;
            bl = false;
            String minor = (String)list.get(2);
            object = major;
            void var16_17 = protocol;
            Companion companion = this;
            boolean bl8 = false;
            int n = Integer.parseInt((String)object);
            object = minor;
            bl8 = false;
            int n2 = Integer.parseInt((String)object);
            return companion.fromValue((String)var16_17, n, n2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

