/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.Digest;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.SecretExchangeType;
import io.ktor.network.tls.ServerKeyExchangeType;
import io.ktor.network.tls.TLSClientHandshake;
import io.ktor.network.tls.TLSClientHandshake$WhenMappings;
import io.ktor.network.tls.TLSClientHandshakeKt;
import io.ktor.network.tls.TLSConfig;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.UtilsKt;
import io.ktor.network.tls.certificates.CertificateType;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.ByteWriteChannel;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.CloseableJVMKt;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010/\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u0011\u00102\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J5\u00105\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\b\u00100\u001a\u0004\u0018\u000101H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0011\u0010=\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010>\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010?\u001a\u00020.H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010@\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u001b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020;H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ!\u0010E\u001a\u0002032\u0006\u0010C\u001a\u00020;2\u0006\u0010F\u001a\u00020BH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0019\u0010H\u001a\u0002032\u0006\u0010I\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JJ\u0011\u0010K\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J3\u0010L\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010M\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u000101H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ2\u0010O\u001a\u0002032\u0006\u0010P\u001a\u00020Q2\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002030S\u00a2\u0006\u0002\bUH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ\u0010\u0010W\u001a\u0002032\u0006\u0010-\u001a\u00020.H\u0002R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0010\u001a\u0004\b#\u0010$R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0)\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u001c\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006X"}, d2={"Lio/ktor/network/tls/TLSClientHandshake;", "Lkotlinx/coroutines/CoroutineScope;", "rawInput", "Lkotlinx/coroutines/io/ByteReadChannel;", "rawOutput", "Lkotlinx/coroutines/io/ByteWriteChannel;", "config", "Lio/ktor/network/tls/TLSConfig;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlinx/coroutines/io/ByteReadChannel;Lkotlinx/coroutines/io/ByteWriteChannel;Lio/ktor/network/tls/TLSConfig;Lkotlin/coroutines/CoroutineContext;)V", "cipher", "Lio/ktor/network/tls/cipher/TLSCipher;", "getCipher", "()Lio/ktor/network/tls/cipher/TLSCipher;", "cipher$delegate", "Lkotlin/Lazy;", "clientSeed", "", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "digest", "Lio/ktor/network/tls/Digest;", "Lkotlinx/io/core/BytePacketBuilder;", "handshakes", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lio/ktor/network/tls/TLSHandshake;", "handshakes$annotations", "()V", "input", "Lio/ktor/network/tls/TLSRecord;", "input$annotations", "getInput", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "keyMaterial", "getKeyMaterial", "()[B", "keyMaterial$delegate", "masterSecret", "Ljavax/crypto/spec/SecretKeySpec;", "output", "Lkotlinx/coroutines/channels/SendChannel;", "output$annotations", "getOutput", "()Lkotlinx/coroutines/channels/SendChannel;", "serverHello", "Lio/ktor/network/tls/TLSServerHello;", "generatePreSecret", "encryptionInfo", "Lio/ktor/network/tls/EncryptionInfo;", "handleCertificatesAndKeys", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleServerDone", "exchangeType", "Lio/ktor/network/tls/SecretExchangeType;", "serverCertificate", "Ljava/security/cert/Certificate;", "certificateInfo", "Lio/ktor/network/tls/CertificateInfo;", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;Lio/ktor/network/tls/CertificateInfo;Lio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "negotiate", "receiveServerFinished", "receiveServerHello", "sendChangeCipherSpec", "sendClientCertificate", "Lio/ktor/network/tls/CertificateAndKey;", "info", "(Lio/ktor/network/tls/CertificateInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientCertificateVerify", "certificateAndKey", "(Lio/ktor/network/tls/CertificateInfo;Lio/ktor/network/tls/CertificateAndKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientFinished", "masterKey", "(Ljavax/crypto/spec/SecretKeySpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientHello", "sendClientKeyExchange", "preSecret", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;[BLio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendHandshakeRecord", "handshakeType", "Lio/ktor/network/tls/TLSHandshakeType;", "block", "Lkotlin/Function1;", "Lkotlinx/io/core/BytePacketBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/network/tls/TLSHandshakeType;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyHello", "ktor-network-tls"})
public final class TLSClientHandshake
implements CoroutineScope {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final BytePacketBuilder digest;
    private final byte[] clientSeed;
    private volatile TLSServerHello serverHello;
    private volatile SecretKeySpec masterSecret;
    private final Lazy keyMaterial$delegate;
    private final Lazy cipher$delegate;
    @NotNull
    private final ReceiveChannel<TLSRecord> input;
    @NotNull
    private final SendChannel<TLSRecord> output;
    private final ReceiveChannel<TLSHandshake> handshakes;
    private final TLSConfig config;
    @NotNull
    private final CoroutineContext coroutineContext;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(TLSClientHandshake.class), "keyMaterial", "getKeyMaterial()[B")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(TLSClientHandshake.class), "cipher", "getCipher()Lio/ktor/network/tls/cipher/TLSCipher;"))};
    }

    private final byte[] getKeyMaterial() {
        Lazy lazy = this.keyMaterial$delegate;
        TLSClientHandshake tLSClientHandshake = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (byte[])lazy.getValue();
    }

    private final TLSCipher getCipher() {
        Lazy lazy = this.cipher$delegate;
        TLSClientHandshake tLSClientHandshake = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (TLSCipher)lazy.getValue();
    }

    public static /* synthetic */ void input$annotations() {
    }

    @NotNull
    public final ReceiveChannel<TLSRecord> getInput() {
        return this.input;
    }

    public static /* synthetic */ void output$annotations() {
    }

    @NotNull
    public final SendChannel<TLSRecord> getOutput() {
        return this.output;
    }

    private static /* synthetic */ void handshakes$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object negotiate(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof negotiate.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.negotiate(this);
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(continuation2);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $this$use$iv = Digest.box-impl(this.digest);
                $i$f$use = false;
                closed$iv = 0;
                it = $this$use$iv.unbox-impl();
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.I$0 = closed$iv;
                $continuation.L$2 = it;
                $continuation.label = 1;
                v0 = this.sendClientHello($continuation);
                ** if (v0 != var12_4) goto lbl27
lbl26:
                // 1 sources

                return var12_4;
lbl27:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                it = (BytePacketBuilder)$continuation.L$2;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl36:
                // 2 sources

                var7_13 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.I$0 = closed$iv;
                $continuation.L$2 = it;
                $continuation.L$3 = var7_13;
                $continuation.label = 2;
                v1 = this.receiveServerHello($continuation);
                ** if (v1 != var12_4) goto lbl46
lbl45:
                // 1 sources

                return var12_4;
lbl46:
                // 1 sources

                ** GOTO lbl56
            }
            case 2: {
                var7_13 = (TLSClientHandshake)$continuation.L$3;
                it = (BytePacketBuilder)$continuation.L$2;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl56:
                // 2 sources

                var8_14 = v1;
                var7_13.serverHello = (TLSServerHello)var8_14;
                v2 = this.serverHello;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                }
                this.verifyHello(v2);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.I$0 = closed$iv;
                $continuation.L$2 = it;
                $continuation.label = 3;
                v3 = this.handleCertificatesAndKeys($continuation);
                ** if (v3 != var12_4) goto lbl70
lbl69:
                // 1 sources

                return var12_4;
lbl70:
                // 1 sources

                ** GOTO lbl79
            }
            case 3: {
                it = (BytePacketBuilder)$continuation.L$2;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl79:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.I$0 = closed$iv;
                $continuation.L$2 = it;
                $continuation.label = 4;
                v4 = this.receiveServerFinished($continuation);
                ** if (v4 != var12_4) goto lbl87
lbl86:
                // 1 sources

                return var12_4;
lbl87:
                // 1 sources

                ** GOTO lbl96
            }
            case 4: {
                it = (BytePacketBuilder)$continuation.L$2;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v4 = $result;
lbl96:
                    // 2 sources

                    var9_15 = Unit.INSTANCE;
                }
                catch (Throwable first$iv) {
                    try {
                        try {
                            closed$iv = 1;
                            $this$use$iv.close();
                        }
                        catch (Throwable second$iv) {
                            CloseableJVMKt.addSuppressedInternal(first$iv, second$iv);
                        }
                        throw first$iv;
                    }
                    catch (Throwable var5_10) {
                        if (closed$iv == 0) {
                            $this$use$iv.close();
                        }
                        throw var5_10;
                    }
                }
                $this$use$iv.close();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyHello(TLSServerHello serverHello) {
        boolean bl;
        List<HashAndSign> serverExchanges;
        List clientExchanges;
        block8: {
            void $this$filterTo$iv$iv;
            CipherSuite suite = serverHello.getCipherSuite();
            boolean bl2 = this.config.getCipherSuites().contains(suite);
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Unsupported cipher suite " + suite.getName() + " in SERVER_HELLO";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable $this$filter$iv = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
            boolean $i$f$filter = false;
            Iterable bl5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HashAndSign it = (HashAndSign)element$iv$iv;
                boolean bl6 = false;
                if (!(it.getHash() == suite.getHash() && it.getSign() == suite.getSignatureAlgorithm())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            clientExchanges = (List)destination$iv$iv;
            if (clientExchanges.isEmpty()) {
                throw (Throwable)new TLSException("No appropriate hash algorithm for suite: " + suite, null, 2, null);
            }
            serverExchanges = serverHello.getHashAndSignAlgorithms();
            if (serverExchanges.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = clientExchanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HashAndSign it = (HashAndSign)element$iv;
                    boolean bl7 = false;
                    if (!serverExchanges.contains(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            throw (Throwable)new TLSException("No sign algorithms in common. \n" + "Server candidates: " + serverExchanges + " \n" + "Client candidates: " + clientExchanges, null, 2, null);
        }
    }

    @Nullable
    final /* synthetic */ Object sendClientHello(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.sendHandshakeRecord(TLSHandshakeType.ClientHello, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ TLSClientHandshake this$0;

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkParameterIsNotNull($this$sendHandshakeRecord, "$receiver");
                RenderKt.writeTLSClientHello($this$sendHandshakeRecord, TLSVersion.TLS12, TLSClientHandshake.access$getConfig$p(this.this$0).getCipherSuites(), TLSClientHandshake.access$getClientSeed$p(this.this$0), new byte[32], TLSClientHandshake.access$getConfig$p(this.this$0).getServerName());
            }
            {
                this.this$0 = tLSClientHandshake;
                super(1);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object receiveServerHello(@NotNull Continuation<? super TLSServerHello> $completion) {
        if (!($completion instanceof receiveServerHello.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.receiveServerHello(this);
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(continuation2);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.handshakes.receive($continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                var3_6 = (handshake = (TLSHandshake)v0).getType() == TLSHandshakeType.ServerHello;
                var4_7 = false;
                var5_8 = false;
                if (!var3_6) {
                    $i$a$-check-TLSClientHandshake$receiveServerHello$2 = false;
                    var5_9 = "Expected TLS handshake ServerHello but got " + (Object)handshake.getType();
                    throw (Throwable)new IllegalStateException(var5_9.toString());
                }
                return ParserKt.readTLSServerHello(handshake.getPacket());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    final /* synthetic */ Object handleCertificatesAndKeys(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleCertificatesAndKeys.1)) ** GOTO lbl-1000
        var30_2 = $completion;
        if ((var30_2.label & -2147483648) != 0) {
            var30_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleCertificatesAndKeys(this);
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(continuation2);
                }
            };
        }
        $result = $continuation.result;
        var34_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                v0 = this.serverHello;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                }
                exchangeType = v0.getCipherSuite().getExchangeType();
                var3_7 = new Ref.ObjectRef<T>();
                var3_7.element = null;
                certificateInfo = null;
                encryptionInfo = null;
                break;
            }
            case 1: {
                encryptionInfo = (EncryptionInfo)$continuation.L$4;
                certificateInfo = (CertificateInfo)$continuation.L$3;
                serverCertificate = (Ref.ObjectRef)$continuation.L$2;
                exchangeType = (SecretExchangeType)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
                ** GOTO lbl55
            }
            case 2: {
                packet = (ByteReadPacket)$continuation.L$6;
                handshake = (TLSHandshake)$continuation.L$5;
                encryptionInfo = (EncryptionInfo)$continuation.L$4;
                certificateInfo = (CertificateInfo)$continuation.L$3;
                serverCertificate = (Ref.ObjectRef)$continuation.L$2;
                exchangeType = (SecretExchangeType)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
                return Unit.INSTANCE;
            }
            default: {
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        }
        block20: while (true) {
            $continuation.L$0 = this;
            $continuation.L$1 = exchangeType;
            $continuation.L$2 = serverCertificate;
            $continuation.L$3 = certificateInfo;
            $continuation.L$4 = encryptionInfo;
            $continuation.label = 1;
            v1 = this.handshakes.receive($continuation);
            if (v1 == var34_4) {
                return var34_4;
            }
lbl55:
            // 3 sources

            handshake = (TLSHandshake)v1;
            packet = handshake.getPacket();
            switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$2[handshake.getType().ordinal()]) {
                case 1: {
                    certs = ParserKt.readTLSCertificate(packet);
                    $this$filterIsInstance$iv = certs;
                    $i$f$filterIsInstance = false;
                    var12_26 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof X509Certificate)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    x509s = (List)destination$iv$iv;
                    if (x509s.isEmpty()) {
                        throw (Throwable)new TLSException("Server sent no certificate", null, 2, null);
                    }
                    manager = this.config.getTrustManager();
                    $i$f$filterIsInstance = x509s;
                    var25_81 = manager;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    v3 = thisCollection$iv.toArray(new X509Certificate[0]);
                    if (v3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    var26_82 = v3;
                    var25_81.checkServerTrusted(var26_82, exchangeType.getJvmName());
                    $this$toTypedArray$iv = x509s;
                    var25_81 = serverCertificate;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        certificate = (X509Certificate)element$iv;
                        $i$a$-firstOrNull-TLSClientHandshake$handleCertificatesAndKeys$2 = false;
                        $this$any$iv = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl94
                        v4 = false;
                        ** GOTO lbl102
lbl94:
                        // 2 sources

                        for (Collection element$iv : $this$any$iv) {
                            it = (HashAndSign)element$iv /* !! */ ;
                            $i$a$-any-TLSClientHandshake$handleCertificatesAndKeys$2$1 = false;
                            if (!Boxing.boxBoolean(StringsKt.equals(it.getName(), certificate.getSigAlgName(), true)).booleanValue()) continue;
                            v4 = true;
                            ** GOTO lbl102
                        }
                        v4 = false;
lbl102:
                        // 3 sources

                        if (!Boxing.boxBoolean(v4).booleanValue()) continue;
                        v5 = element$iv;
                        ** GOTO lbl106
                    }
                    v5 = null;
lbl106:
                    // 2 sources

                    var26_82 = v5;
                    v6 = (X509Certificate)var26_82;
                    if (v6 == null) {
                        throw (Throwable)new TLSException("No suitable server certificate received: " + certs, null, 2, null);
                    }
                    var25_81.element = v6;
                    continue block20;
                }
                case 2: {
                    typeCount = packet.readByte() & 255;
                    types = kotlinx.io.core.StringsKt.readBytes(packet, typeCount);
                    hashAndSignCount = packet.readShort() & 65535;
                    $i$f$firstOrNull = 0;
                    hashAndSign = new ArrayList<E>();
                    $i$f$firstOrNull = hashAndSignCount / 2;
                    thisCollection$iv = false;
                    element$iv = 0;
                    certificate = $i$f$firstOrNull;
                    for (element$iv = 0; element$iv < certificate; ++element$iv) {
                        it = ((Number)Boxing.boxInt(element$iv)).intValue();
                        $i$a$-repeat-TLSClientHandshake$handleCertificatesAndKeys$3 = false;
                        hash = packet.readByte();
                        sign = packet.readByte();
                        element$iv /* !! */  = hashAndSign;
                        it = new HashAndSign(hash, sign);
                        $i$a$-any-TLSClientHandshake$handleCertificatesAndKeys$2$1 = false;
                        element$iv /* !! */ .add(it);
                    }
                    authoritiesSize = packet.readShort() & 65535;
                    element$iv = 0;
                    authorities = new LinkedHashSet<E>();
                    for (position = 0; position < authoritiesSize; position += size) {
                        size = packet.readShort() & 65535;
                        authority = kotlinx.io.core.StringsKt.readBytes(packet, size);
                        $i$a$-repeat-TLSClientHandshake$handleCertificatesAndKeys$3 = authorities;
                        var18_64 = new X500Principal(authority);
                        sign = false;
                        $i$a$-repeat-TLSClientHandshake$handleCertificatesAndKeys$3.add(var18_64);
                    }
                    size = hashAndSign;
                    var27_83 = types;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new HashAndSign[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    var31_85 = authorities;
                    var32_86 = var28_84;
                    var33_87 = var27_83;
                    certificateInfo = new CertificateInfo(var33_87, var32_86, var31_85);
                    $this$toTypedArray$iv = packet.isEmpty();
                    $i$f$toTypedArray = false;
                    thisCollection$iv = false;
                    thisCollection$iv = false;
                    var18_65 = false;
                    if ($this$toTypedArray$iv) continue block20;
                    sign = false;
                    var18_66 = "Check failed.";
                    throw (Throwable)new IllegalStateException(var18_66.toString());
                }
                case 3: {
                    switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$1[exchangeType.ordinal()]) {
                        case 1: {
                            curve = ParserKt.readCurveParams(packet);
                            point = ParserKt.readECPoint(packet, curve.getFieldSize());
                            hashAndSign = SignatureAlgorithmKt.readHashAndSign(packet);
                            headerSizeHint$iv = 0;
                            $i$f$buildPacket = false;
                            builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
                            try {
                                $this$buildPacket = builder$iv;
                                $i$a$-buildPacket-TLSClientHandshake$handleCertificatesAndKeys$params$1 = false;
                                $this$buildPacket.writeByte((byte)ServerKeyExchangeType.NamedCurve.getCode());
                                $this$buildPacket.writeShort(curve.getCode());
                                RenderKt.writeECPoint($this$buildPacket, point, curve.getFieldSize());
                                v7 = builder$iv.build();
                            }
                            catch (Throwable t$iv) {
                                builder$iv.release();
                                throw t$iv;
                            }
                            params = v7;
                            if (Signature.getInstance(hashAndSign.getName()) == null) {
                                Intrinsics.throwNpe();
                            }
                            builder$iv = false;
                            var15_48 = false;
                            $this$apply = $i$f$buildPacket;
                            $i$a$-apply-TLSClientHandshake$handleCertificatesAndKeys$signature$1 = false;
                            $this$apply.initVerify((Certificate)serverCertificate.element);
                            var18_67 = $this$apply;
                            headerSizeHint$iv = 0;
                            $i$f$buildPacket = false;
                            builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
                            try {
                                $this$buildPacket = builder$iv;
                                $i$a$-buildPacket-TLSClientHandshake$handleCertificatesAndKeys$signature$1$1 = false;
                                OutputKt.writeFully$default((Output)$this$buildPacket, this.clientSeed, 0, 0, 6, null);
                                v8 = $this$buildPacket;
                                v9 = this.serverHello;
                                if (v9 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                                }
                                OutputKt.writeFully$default(v8, v9.getServerSeed(), 0, 0, 6, null);
                                $this$buildPacket.writePacket(params);
                                v10 = builder$iv.build();
                            }
                            catch (Throwable t$iv) {
                                builder$iv.release();
                                throw t$iv;
                            }
                            var24_80 = v10;
                            var18_67.update(kotlinx.io.core.StringsKt.readBytes$default(var24_80, 0, 1, null));
                            signature = $i$f$buildPacket;
                            signSize = packet.readShort() & 65535;
                            signedMessage = kotlinx.io.core.StringsKt.readBytes(packet, signSize);
                            if (!signature.verify(signedMessage)) {
                                throw (Throwable)new TLSException("Failed to verify signed message", null, 2, null);
                            }
                            encryptionInfo = TLSClientHandshakeKt.access$generateECKeys(curve, point);
                            continue block20;
                        }
                        case 2: {
                            packet.release();
                            var8_17 = "Server key exchange handshake doesn't expected in RCA exchange type";
                            var9_20 = false;
                            throw (Throwable)new IllegalStateException(var8_17.toString());
                        }
                    }
                    continue block20;
                }
                case 4: {
                    v11 = (Certificate)serverCertificate.element;
                    if (v11 == null) {
                        Intrinsics.throwNpe();
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = exchangeType;
                    $continuation.L$2 = serverCertificate;
                    $continuation.L$3 = certificateInfo;
                    $continuation.L$4 = encryptionInfo;
                    $continuation.L$5 = handshake;
                    $continuation.L$6 = packet;
                    $continuation.label = 2;
                    if ((v2 = this.handleServerDone(exchangeType, v11, certificateInfo, encryptionInfo, $continuation)) != var34_4) ** continue;
                    return var34_4;
                }
            }
            throw (Throwable)new TLSException("Unsupported message type during handshake: " + (Object)handshake.getType(), null, 2, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object handleServerDone(@NotNull SecretExchangeType exchangeType, @NotNull Certificate serverCertificate, @Nullable CertificateInfo certificateInfo, @Nullable EncryptionInfo encryptionInfo, @NotNull Continuation<? super Unit> $completion) {
        block19: {
            if (!($completion instanceof handleServerDone.1)) ** GOTO lbl-1000
            var14_6 = $completion;
            if ((var14_6.label & -2147483648) != 0) {
                var14_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    int label;
                    final /* synthetic */ TLSClientHandshake this$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handleServerDone(null, null, null, null, this);
                    }
                    {
                        this.this$0 = tLSClientHandshake;
                        super(continuation2);
                    }
                };
            }
            $result = $continuation.result;
            var15_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    v0 = certificateInfo;
                    if (v0 == null) break;
                    var7_9 = v0;
                    var8_11 = false;
                    var9_13 = false;
                    it = var7_9;
                    $i$a$-let-TLSClientHandshake$handleServerDone$chain$1 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = exchangeType;
                    $continuation.L$2 = serverCertificate;
                    $continuation.L$3 = certificateInfo;
                    $continuation.L$4 = encryptionInfo;
                    $continuation.L$5 = it;
                    $continuation.label = 1;
                    v1 = this.sendClientCertificate(it, $continuation);
                    if (v1 == var15_8) {
                        return var15_8;
                    }
                    ** GOTO lbl39
                }
                case 1: {
                    it = (CertificateInfo)$continuation.L$5;
                    encryptionInfo = (EncryptionInfo)$continuation.L$4;
                    certificateInfo = (CertificateInfo)$continuation.L$3;
                    serverCertificate = (Certificate)$continuation.L$2;
                    exchangeType = (SecretExchangeType)$continuation.L$1;
                    this = (TLSClientHandshake)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v1 = $result;
lbl39:
                    // 2 sources

                    v2 = (CertificateAndKey)v1;
                    break block19;
                }
            }
            v2 = null;
        }
        chain = v2;
        preSecret = this.generatePreSecret(encryptionInfo);
        $continuation.L$0 = this;
        $continuation.L$1 = exchangeType;
        $continuation.L$2 = serverCertificate;
        $continuation.L$3 = certificateInfo;
        $continuation.L$4 = encryptionInfo;
        $continuation.L$5 = chain;
        $continuation.L$6 = preSecret;
        $continuation.label = 2;
        v3 = this.sendClientKeyExchange(exchangeType, serverCertificate, preSecret, encryptionInfo, $continuation);
        if (v3 == var15_8) {
            return var15_8;
        }
        ** GOTO lbl67
        {
            case 2: {
                preSecret = (byte[])$continuation.L$6;
                chain = (CertificateAndKey)$continuation.L$5;
                encryptionInfo = (EncryptionInfo)$continuation.L$4;
                certificateInfo = (CertificateInfo)$continuation.L$3;
                serverCertificate = (Certificate)$continuation.L$2;
                exchangeType = (SecretExchangeType)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl67:
                // 2 sources

                v4 = this.serverHello;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                }
                v5 = new SecretKeySpec(preSecret, v4.getCipherSuite().getHash().getMacName());
                v6 = this.serverHello;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                }
                this.masterSecret = KeysKt.masterSecret(v5, this.clientSeed, v6.getServerSeed());
                ArraysKt.fill$default(preSecret, (byte)0, 0, 0, 6, null);
                v7 = certificateInfo;
                if (v7 == null) break;
                var8_12 = v7;
                var9_13 = false;
                var10_16 = false;
                it = var8_12;
                $i$a$-let-TLSClientHandshake$handleServerDone$2 = false;
                v8 = chain;
                if (v8 == null) {
                    Intrinsics.throwNpe();
                }
                $continuation.L$0 = this;
                $continuation.L$1 = exchangeType;
                $continuation.L$2 = serverCertificate;
                $continuation.L$3 = certificateInfo;
                $continuation.L$4 = encryptionInfo;
                $continuation.L$5 = chain;
                $continuation.L$6 = preSecret;
                $continuation.L$7 = it;
                $continuation.label = 3;
                v9 = this.sendClientCertificateVerify(it, v8, $continuation);
                if (v9 == var15_8) {
                    return var15_8;
                }
                break;
            }
            case 3: {
                it = (CertificateInfo)$continuation.L$7;
                preSecret = (byte[])$continuation.L$6;
                chain = (CertificateAndKey)$continuation.L$5;
                encryptionInfo = (EncryptionInfo)$continuation.L$4;
                certificateInfo = (CertificateInfo)$continuation.L$3;
                serverCertificate = (Certificate)$continuation.L$2;
                exchangeType = (SecretExchangeType)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v9 = $result;
                break;
            }
        }
        $continuation.L$0 = this;
        $continuation.L$1 = exchangeType;
        $continuation.L$2 = serverCertificate;
        $continuation.L$3 = certificateInfo;
        $continuation.L$4 = encryptionInfo;
        $continuation.L$5 = chain;
        $continuation.L$6 = preSecret;
        $continuation.label = 4;
        v10 = this.sendChangeCipherSpec($continuation);
        if (v10 == var15_8) {
            return var15_8;
        }
        ** GOTO lbl133
        {
            case 4: {
                preSecret = (byte[])$continuation.L$6;
                chain = (CertificateAndKey)$continuation.L$5;
                encryptionInfo = (EncryptionInfo)$continuation.L$4;
                certificateInfo = (CertificateInfo)$continuation.L$3;
                serverCertificate = (Certificate)$continuation.L$2;
                exchangeType = (SecretExchangeType)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v10 = $result;
lbl133:
                // 2 sources

                v11 = this.masterSecret;
                if (v11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("masterSecret");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = exchangeType;
                $continuation.L$2 = serverCertificate;
                $continuation.L$3 = certificateInfo;
                $continuation.L$4 = encryptionInfo;
                $continuation.L$5 = chain;
                $continuation.L$6 = preSecret;
                $continuation.label = 5;
                v12 = this.sendClientFinished(v11, $continuation);
                if (v12 == var15_8) {
                    return var15_8;
                }
                ** GOTO lbl158
            }
            case 5: {
                preSecret = (byte[])$continuation.L$6;
                chain = (CertificateAndKey)$continuation.L$5;
                encryptionInfo = (EncryptionInfo)$continuation.L$4;
                certificateInfo = (CertificateInfo)$continuation.L$3;
                serverCertificate = (Certificate)$continuation.L$2;
                exchangeType = (SecretExchangeType)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v12 = $result;
lbl158:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final byte[] generatePreSecret(EncryptionInfo encryptionInfo) {
        byte[] byArray;
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException("serverHello");
        }
        switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$3[tLSServerHello.getCipherSuite().getExchangeType().ordinal()]) {
            case 1: {
                byte[] byArray2 = new byte[48];
                boolean bl = false;
                boolean bl2 = false;
                byte[] it = byArray2;
                boolean bl3 = false;
                this.config.getRandom().nextBytes(it);
                it[0] = 3;
                it[1] = 3;
                byArray = byArray2;
                break;
            }
            case 2: {
                KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
                if (keyAgreement == null) {
                    Intrinsics.throwNpe();
                }
                KeyAgreement keyAgreement2 = keyAgreement;
                boolean bl = false;
                boolean bl4 = false;
                KeyAgreement $this$run = keyAgreement2;
                boolean bl5 = false;
                if (encryptionInfo == null) {
                    throw (Throwable)new TLSException("ECDHE_ECDSA: Encryption info should be provided", null, 2, null);
                }
                $this$run.init(encryptionInfo.getClientPrivate());
                $this$run.doPhase(encryptionInfo.getServerPublic(), true);
                byArray = $this$run.generateSecret();
                if (byArray != null) break;
                Intrinsics.throwNpe();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    @Nullable
    final /* synthetic */ Object sendClientKeyExchange(@NotNull SecretExchangeType exchangeType, @NotNull Certificate serverCertificate, @NotNull byte[] preSecret, @Nullable EncryptionInfo encryptionInfo, @NotNull Continuation<? super Unit> $completion) {
        ByteReadPacket byteReadPacket;
        switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$4[exchangeType.ordinal()]) {
            case 1: {
                BytePacketBuilder $this$buildPacket;
                int headerSizeHint$iv = 0;
                boolean $i$f$buildPacket = false;
                BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
                try {
                    $this$buildPacket = builder$iv;
                    boolean bl = false;
                    PublicKey publicKey = serverCertificate.getPublicKey();
                    Intrinsics.checkExpressionValueIsNotNull(publicKey, "serverCertificate.publicKey");
                    RenderKt.writeEncryptedPreMasterSecret($this$buildPacket, preSecret, publicKey, this.config.getRandom());
                    byteReadPacket = builder$iv.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
            }
            case 2: {
                BytePacketBuilder $this$buildPacket;
                int headerSizeHint$iv = 0;
                boolean $i$f$buildPacket = false;
                BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
                try {
                    $this$buildPacket = builder$iv;
                    boolean bl = false;
                    if (encryptionInfo == null) {
                        throw (Throwable)new TLSException("ECDHE: Encryption info should be provided", null, 2, null);
                    }
                    RenderKt.writePublicKeyUncompressed($this$buildPacket, encryptionInfo.getClientPublic());
                    byteReadPacket = builder$iv.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ByteReadPacket packet2 = byteReadPacket;
        Object object = this.sendHandshakeRecord(TLSHandshakeType.ClientKeyExchange, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(packet2){
            final /* synthetic */ ByteReadPacket $packet;

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkParameterIsNotNull($this$sendHandshakeRecord, "$receiver");
                $this$sendHandshakeRecord.writePacket(this.$packet);
            }
            {
                this.$packet = byteReadPacket;
                super(1);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object sendClientCertificate(@NotNull CertificateInfo info, @NotNull Continuation<? super CertificateAndKey> $completion) {
        if (!($completion instanceof sendClientCertificate.1)) ** GOTO lbl-1000
        var24_3 = $completion;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.sendClientCertificate(null, this);
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(continuation2);
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var4_6 = this.config.getCertificates();
                var5_7 = false;
                var6_8 = var4_6;
                var7_9 = false;
                for (T var9_11 : var6_8) {
                    candidate = (CertificateAndKey)var9_11;
                    $i$a$-find-TLSClientHandshake$sendClientCertificate$chainAndKey$1 = false;
                    leaf = ArraysKt.first(candidate.getCertificateChain());
                    v0 = leaf.getPublicKey();
                    Intrinsics.checkExpressionValueIsNotNull(v0, "leaf.publicKey");
                    if (v0.getAlgorithm() == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var13_15.hashCode()) {
                        case 81440: {
                            if (!var13_15.equals("RSA")) break;
                            tmp = 1;
                            break;
                        }
                        case 68004: {
                            if (!var13_15.equals("DSS")) break;
                            tmp = 2;
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v1 = ArraysKt.contains(info.getTypes(), CertificateType.INSTANCE.getRSA());
                            break;
                        }
                        case 2: {
                            v1 = ArraysKt.contains(info.getTypes(), CertificateType.INSTANCE.getDSS());
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v1 = validAlgorithm = false;
                        }
                    }
                    if (validAlgorithm) ** GOTO lbl46
                    v2 = false;
                    ** GOTO lbl77
lbl46:
                    // 1 sources

                    $this$none$iv = info.getHashAndSign();
                    $i$f$none = false;
                    var17_20 = $this$none$iv;
                    var18_21 = var17_20.length;
                    for (var19_22 = 0; var19_22 < var18_21; ++var19_22) {
                        it = element$iv = var17_20[var19_22];
                        $i$a$-none-TLSClientHandshake$sendClientCertificate$chainAndKey$1$hasHashAndSignInCommon$1 = false;
                        if (!Boxing.boxBoolean(StringsKt.equals(it.getName(), leaf.getSigAlgName(), true)).booleanValue()) continue;
                        v3 = false;
                        ** GOTO lbl57
                    }
                    v3 = hasHashAndSignInCommon = true;
lbl57:
                    // 2 sources

                    if (!hasHashAndSignInCommon) ** GOTO lbl60
                    v2 = false;
                    ** GOTO lbl77
lbl60:
                    // 1 sources

                    if (info.getAuthorities().isEmpty()) ** GOTO lbl-1000
                    $this$any$iv = candidate.getCertificateChain();
                    $i$f$any = false;
                    var17_20 = $this$any$iv;
                    var18_21 = var17_20.length;
                    for (var19_22 = 0; var19_22 < var18_21; ++var19_22) {
                        it = element$iv = var17_20[var19_22];
                        $i$a$-any-TLSClientHandshake$sendClientCertificate$chainAndKey$1$1 = false;
                        if (!Boxing.boxBoolean(info.getAuthorities().contains(it.getIssuerDN())).booleanValue()) continue;
                        v4 = true;
                        ** GOTO lbl72
                    }
                    v4 = false;
lbl72:
                    // 2 sources

                    if (v4) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
lbl77:
                    // 4 sources

                    if (!Boxing.boxBoolean(v2).booleanValue()) continue;
                    v5 = var9_11;
                    ** GOTO lbl81
                }
                v5 = null;
lbl81:
                // 2 sources

                chainAndKey = v5;
                $continuation.L$0 = this;
                $continuation.L$1 = info;
                $continuation.L$2 = chainAndKey;
                $continuation.label = 1;
                v6 = this.sendHandshakeRecord(TLSHandshakeType.Certificate, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(chainAndKey){
                    final /* synthetic */ CertificateAndKey $chainAndKey;

                    public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                        Intrinsics.checkParameterIsNotNull($this$sendHandshakeRecord, "$receiver");
                        BytePacketBuilder bytePacketBuilder = $this$sendHandshakeRecord;
                        X509Certificate[] x509CertificateArray = this.$chainAndKey;
                        if (this.$chainAndKey == null || (x509CertificateArray = x509CertificateArray.getCertificateChain()) == null) {
                            BytePacketBuilder bytePacketBuilder2 = bytePacketBuilder;
                            X509Certificate[] x509CertificateArray2 = new X509Certificate[]{};
                            bytePacketBuilder = bytePacketBuilder2;
                            x509CertificateArray = x509CertificateArray2;
                        }
                        RenderKt.writeTLSCertificates(bytePacketBuilder, x509CertificateArray);
                    }
                    {
                        this.$chainAndKey = certificateAndKey;
                        super(1);
                    }
                }, $continuation);
                if (v6 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl96
            }
            case 1: {
                chainAndKey = (CertificateAndKey)$continuation.L$2;
                info = (CertificateInfo)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v6 = $result;
lbl96:
                // 2 sources

                return chainAndKey;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    final /* synthetic */ Object sendClientCertificateVerify(@NotNull CertificateInfo info, @NotNull CertificateAndKey certificateAndKey, @NotNull Continuation<? super Unit> $completion) {
        HashAndSign hashAndSign;
        block6: {
            X509Certificate leaf = ArraysKt.first(certificateAndKey.getCertificateChain());
            HashAndSign[] $this$firstOrNull$iv = info.getHashAndSign();
            boolean $i$f$firstOrNull = false;
            HashAndSign[] hashAndSignArray = $this$firstOrNull$iv;
            int n = hashAndSignArray.length;
            for (int i = 0; i < n; ++i) {
                HashAndSign element$iv;
                HashAndSign it = element$iv = hashAndSignArray[i];
                boolean bl = false;
                if (!Boxing.boxBoolean(StringsKt.equals(it.getName(), leaf.getSigAlgName(), true)).booleanValue()) continue;
                hashAndSign = element$iv;
                break block6;
            }
            hashAndSign = null;
        }
        if (hashAndSign == null) {
            if (hashAndSign == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return hashAndSign;
            }
            return Unit.INSTANCE;
        }
        HashAndSign hashAndSign2 = hashAndSign;
        if (hashAndSign2.getSign() == SignatureAlgorithm.DSA) {
            return Unit.INSTANCE;
        }
        Signature signature2 = Signature.getInstance(ArraysKt.first(certificateAndKey.getCertificateChain()).getSigAlgName());
        if (signature2 == null) {
            Intrinsics.throwNpe();
        }
        Signature sign = signature2;
        sign.initSign(certificateAndKey.getKey());
        Object object = this.sendHandshakeRecord(TLSHandshakeType.CertificateVerify, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(this, hashAndSign2, sign){
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ HashAndSign $hashAndSign;
            final /* synthetic */ Signature $sign;

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkParameterIsNotNull($this$sendHandshakeRecord, "$receiver");
                $this$sendHandshakeRecord.writeByte(this.$hashAndSign.getHash().getCode());
                $this$sendHandshakeRecord.writeByte(this.$hashAndSign.getSign().getCode());
                TLSClientHandshake.access$getDigest$p(this.this$0).preview((Function1)new Function1<ByteReadPacket, Unit>(this){
                    final /* synthetic */ sendClientCertificateVerify.2 this$0;

                    public final void invoke(@NotNull ByteReadPacket it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        this.this$0.$sign.update(kotlinx.io.core.StringsKt.readBytes$default(it, 0, 1, null));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                byte[] byArray = this.$sign.sign();
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                byte[] signBytes = byArray;
                $this$sendHandshakeRecord.writeShort((short)signBytes.length);
                OutputKt.writeFully$default((Output)$this$sendHandshakeRecord, signBytes, 0, 0, 6, null);
            }
            {
                this.this$0 = tLSClientHandshake;
                this.$hashAndSign = hashAndSign;
                this.$sign = signature2;
                super(1);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    final /* synthetic */ Object sendChangeCipherSpec(@NotNull Continuation<? super Unit> $completion) {
        ByteReadPacket byteReadPacket;
        TLSVersion tLSVersion = null;
        TLSRecordType tLSRecordType = TLSRecordType.ChangeCipherSpec;
        SendChannel<TLSRecord> sendChannel = this.output;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl = false;
            $this$buildPacket.writeByte((byte)1);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket byteReadPacket2 = byteReadPacket;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        ByteReadPacket byteReadPacket3 = byteReadPacket2;
        TLSVersion tLSVersion2 = tLSVersion;
        TLSRecordType tLSRecordType2 = tLSRecordType;
        Object object = sendChannel.send(new TLSRecord(tLSRecordType2, tLSVersion2, byteReadPacket3, n, defaultConstructorMarker), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    final /* synthetic */ Object sendClientFinished(@NotNull SecretKeySpec masterKey, @NotNull Continuation<? super Unit> $completion) {
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException("serverHello");
        }
        byte[] checksum = Digest.doHash-impl(this.digest, tLSServerHello.getCipherSuite().getHash().getOpenSSLName());
        ByteReadPacket finished = RenderKt.finished(checksum, masterKey);
        Object object = this.sendHandshakeRecord(TLSHandshakeType.Finished, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(finished){
            final /* synthetic */ ByteReadPacket $finished;

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkParameterIsNotNull($this$sendHandshakeRecord, "$receiver");
                $this$sendHandshakeRecord.writePacket(this.$finished);
            }
            {
                this.$finished = byteReadPacket;
                super(1);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object receiveServerFinished(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof receiveServerFinished.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.receiveServerFinished(this);
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(continuation2);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.handshakes.receive($continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((finished = (TLSHandshake)v0).getType() != TLSHandshakeType.Finished) {
                    throw (Throwable)new TLSException("Finished handshake expected, received: " + finished, null, 2, null);
                }
                receivedChecksum = kotlinx.io.core.StringsKt.readBytes$default(finished.getPacket(), 0, 1, null);
                v1 = this.serverHello;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                }
                v2 = Digest.doHash-impl(this.digest, v1.getCipherSuite().getHash().getOpenSSLName());
                v3 = this.masterSecret;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("masterSecret");
                }
                expectedChecksum = RenderKt.serverFinished(v2, v3, receivedChecksum.length);
                var5_8 = receivedChecksum;
                var6_9 = false;
                if (!Arrays.equals(var5_8, expectedChecksum)) {
                    throw (Throwable)new TLSException(StringsKt.trimMargin$default("Handshake: ServerFinished verification failed:\n                |Expected: " + ArraysKt.joinToString$default(expectedChecksum, null, null, null, 0, null, null, 63, null) + "\n                |Actual: " + ArraysKt.joinToString$default(receivedChecksum, null, null, null, 0, null, null, 63, null) + "\n            ", null, 1, null), null, 2, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    final /* synthetic */ Object sendHandshakeRecord(@NotNull TLSHandshakeType handshakeType, @NotNull Function1<? super BytePacketBuilder, Unit> block2, @NotNull Continuation<? super Unit> $completion) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            block2.invoke(builder$iv);
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket handshakeBody = byteReadPacket2;
        int headerSizeHint$iv2 = 0;
        boolean $i$f$buildPacket2 = false;
        BytePacketBuilder builder$iv2 = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv2);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv2;
            boolean bl = false;
            RenderKt.writeTLSHandshakeType($this$buildPacket, handshakeType, (int)handshakeBody.getRemaining());
            $this$buildPacket.writePacket(handshakeBody);
            byteReadPacket = builder$iv2.build();
        }
        catch (Throwable t$iv) {
            builder$iv2.release();
            throw t$iv;
        }
        ByteReadPacket recordBody = byteReadPacket;
        Digest.update-impl(this.digest, recordBody);
        TLSRecord element = new TLSRecord(TLSRecordType.Handshake, null, recordBody, 2, null);
        Object object = this.output.send(element, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public TLSClientHandshake(@NotNull ByteReadChannel rawInput, @NotNull ByteWriteChannel rawOutput, @NotNull TLSConfig config2, @NotNull CoroutineContext coroutineContext2) {
        Intrinsics.checkParameterIsNotNull(rawInput, "rawInput");
        Intrinsics.checkParameterIsNotNull(rawOutput, "rawOutput");
        Intrinsics.checkParameterIsNotNull(config2, "config");
        Intrinsics.checkParameterIsNotNull(coroutineContext2, "coroutineContext");
        this.config = config2;
        this.coroutineContext = coroutineContext2;
        this.digest = UtilsKt.Digest();
        this.clientSeed = TLSClientHandshakeKt.access$generateClientSeed(this.config.getRandom());
        this.keyMaterial$delegate = LazyKt.lazy((Function0)new Function0<byte[]>(this){
            final /* synthetic */ TLSClientHandshake this$0;

            @NotNull
            public final byte[] invoke() {
                CipherSuite cipherSuite = TLSClientHandshake.access$getServerHello$p(this.this$0).getCipherSuite();
                boolean bl = false;
                boolean bl2 = false;
                CipherSuite $this$with = cipherSuite;
                boolean bl3 = false;
                return KeysKt.keyMaterial(TLSClientHandshake.access$getMasterSecret$p(this.this$0), ArraysKt.plus(TLSClientHandshake.access$getServerHello$p(this.this$0).getServerSeed(), TLSClientHandshake.access$getClientSeed$p(this.this$0)), $this$with.getKeyStrengthInBytes(), $this$with.getMacStrengthInBytes(), $this$with.getFixedIvLength());
            }
            {
                this.this$0 = tLSClientHandshake;
                super(0);
            }
        });
        this.cipher$delegate = LazyKt.lazy((Function0)new Function0<TLSCipher>(this){
            final /* synthetic */ TLSClientHandshake this$0;

            @NotNull
            public final TLSCipher invoke() {
                return TLSCipher.Companion.fromSuite(TLSClientHandshake.access$getServerHello$p(this.this$0).getCipherSuite(), TLSClientHandshake.access$getKeyMaterial$p(this.this$0));
            }
            {
                this.this$0 = tLSClientHandshake;
                super(0);
            }
        });
        this.input = ProduceKt.produce$default(this, new CoroutineName("cio-tls-parser"), 0, new Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object>(this, rawInput, null){
            private ProducerScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ ByteReadChannel $rawInput;

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
            {
                this.this$0 = tLSClientHandshake;
                this.$rawInput = byteReadChannel;
                super(2, continuation2);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, "completion");
                Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ProducerScope producerScope = function2.p$ = (ProducerScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        this.output = ActorKt.actor$default(this, new CoroutineName("cio-tls-encoder"), 0, null, null, new Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object>(this, rawOutput, null){
            private ActorScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ ByteWriteChannel $rawOutput;

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
            {
                this.this$0 = tLSClientHandshake;
                this.$rawOutput = byteWriteChannel;
                super(2, continuation2);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, "completion");
                Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ActorScope actorScope = function2.p$ = (ActorScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 14, null);
        this.handshakes = ProduceKt.produce$default(this, new CoroutineName("cio-tls-handshake"), 0, new Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object>(this, null){
            private ProducerScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ TLSClientHandshake this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        $this$produce = this.p$;
                        while (true) {
                            this.L$0 = $this$produce;
                            this.label = 1;
                            v0 = this.this$0.getInput().receive(this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl18
                            break;
                        }
                    }
                    case 1: {
                        $this$produce = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if ((record = (TLSRecord)v0).getType() != TLSRecordType.Handshake) {
                            record.getPacket().release();
                            var4_5 = "TLS handshake expected, got " + (Object)record.getType();
                            var5_7 = false;
                            throw (Throwable)new IllegalStateException(var4_5.toString());
                        }
                        packet = record.getPacket();
lbl24:
                        // 2 sources

                        while (true) {
                            if (!packet.isNotEmpty()) ** continue;
                            handshake = ParserKt.readTLSHandshake(packet);
                            if (handshake.getType() == TLSHandshakeType.HelloRequest) ** continue;
                            if (handshake.getType() != TLSHandshakeType.Finished) {
                                UtilsKt.plusAssign-Bb1Az4c(TLSClientHandshake.access$getDigest$p(this.this$0), handshake);
                            }
                            this.L$0 = $this$produce;
                            this.L$1 = record;
                            this.L$2 = packet;
                            this.L$3 = handshake;
                            this.label = 2;
                            v1 = $this$produce.getChannel().send(handshake, this);
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl46
                            break;
                        }
                    }
                    case 2: {
                        handshake = (TLSHandshake)this.L$3;
                        packet = (ByteReadPacket)this.L$2;
                        record = (TLSRecord)this.L$1;
                        $this$produce = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl46:
                        // 2 sources

                        if (handshake.getType() == TLSHandshakeType.Finished) ** break;
                        ** continue;
                        packet.release();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = tLSClientHandshake;
                super(2, continuation2);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, "completion");
                Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ProducerScope producerScope = function2.p$ = (ProducerScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    public static final /* synthetic */ TLSConfig access$getConfig$p(TLSClientHandshake $this) {
        return $this.config;
    }

    public static final /* synthetic */ byte[] access$getClientSeed$p(TLSClientHandshake $this) {
        return $this.clientSeed;
    }

    public static final /* synthetic */ BytePacketBuilder access$getDigest$p(TLSClientHandshake $this) {
        return $this.digest;
    }

    public static final /* synthetic */ TLSServerHello access$getServerHello$p(TLSClientHandshake $this) {
        TLSServerHello tLSServerHello = $this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException("serverHello");
        }
        return tLSServerHello;
    }

    public static final /* synthetic */ void access$setServerHello$p(TLSClientHandshake $this, TLSServerHello tLSServerHello) {
        $this.serverHello = tLSServerHello;
    }

    public static final /* synthetic */ SecretKeySpec access$getMasterSecret$p(TLSClientHandshake $this) {
        SecretKeySpec secretKeySpec = $this.masterSecret;
        if (secretKeySpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException("masterSecret");
        }
        return secretKeySpec;
    }

    public static final /* synthetic */ void access$setMasterSecret$p(TLSClientHandshake $this, SecretKeySpec secretKeySpec) {
        $this.masterSecret = secretKeySpec;
    }

    public static final /* synthetic */ byte[] access$getKeyMaterial$p(TLSClientHandshake $this) {
        return $this.getKeyMaterial();
    }

    public static final /* synthetic */ TLSCipher access$getCipher$p(TLSClientHandshake $this) {
        return $this.getCipher();
    }
}

