/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import java.util.HashSet;
import java.util.Set;

public class SimplePropertyPreFilter
implements PropertyPreFilter {
    private final Class<?> clazz;
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private int maxLevel = 0;

    public SimplePropertyPreFilter(String ... properties2) {
        this((Class<?>)null, properties2);
    }

    public SimplePropertyPreFilter(Class<?> clazz, String ... properties2) {
        this.clazz = clazz;
        for (String item : properties2) {
            if (item == null) continue;
            this.includes.add(item);
        }
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean apply(JSONSerializer serializer2, Object source, String name2) {
        if (source == null) {
            return true;
        }
        if (this.clazz != null && !this.clazz.isInstance(source)) {
            return true;
        }
        if (this.excludes.contains(name2)) {
            return false;
        }
        if (this.maxLevel > 0) {
            int level = 0;
            SerialContext context = serializer2.context;
            while (context != null) {
                if (++level > this.maxLevel) {
                    return false;
                }
                context = context.parent;
            }
        }
        return this.includes.size() == 0 || this.includes.contains(name2);
    }
}

