/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.extensions;

import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.ByteReadPacket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0002*\u00020\u0006H\u0000\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\b"}, d2={"SupportedSignatureAlgorithms", "", "Lio/ktor/network/tls/extensions/HashAndSign;", "getSupportedSignatureAlgorithms", "()Ljava/util/List;", "parseSignatureAlgorithms", "Lkotlinx/io/core/ByteReadPacket;", "readHashAndSign", "ktor-network-tls"})
public final class SignatureAlgorithmKt {
    @NotNull
    private static final List<HashAndSign> SupportedSignatureAlgorithms = CollectionsKt.listOf(new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA), new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA), new HashAndSign(HashAlgorithm.SHA512, SignatureAlgorithm.RSA), new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.RSA), new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.RSA), new HashAndSign(HashAlgorithm.SHA1, SignatureAlgorithm.RSA));

    @NotNull
    public static final List<HashAndSign> getSupportedSignatureAlgorithms() {
        return SupportedSignatureAlgorithms;
    }

    @NotNull
    public static final List<HashAndSign> parseSignatureAlgorithms(@NotNull ByteReadPacket $this$parseSignatureAlgorithms) {
        Intrinsics.checkParameterIsNotNull($this$parseSignatureAlgorithms, "$this$parseSignatureAlgorithms");
        int length = $this$parseSignatureAlgorithms.readShort() & 0xFFFF;
        boolean bl = false;
        List result2 = new ArrayList();
        while ($this$parseSignatureAlgorithms.getRemaining() > 0L) {
            Collection collection = result2;
            HashAndSign hashAndSign = SignatureAlgorithmKt.readHashAndSign($this$parseSignatureAlgorithms);
            boolean bl2 = false;
            collection.add(hashAndSign);
        }
        if ((int)$this$parseSignatureAlgorithms.getRemaining() != length) {
            throw (Throwable)new TLSException("Invalid hash and sign packet size: expected " + length + ", actual " + result2.size(), null, 2, null);
        }
        return result2;
    }

    @NotNull
    public static final HashAndSign readHashAndSign(@NotNull ByteReadPacket $this$readHashAndSign) {
        Intrinsics.checkParameterIsNotNull($this$readHashAndSign, "$this$readHashAndSign");
        byte hash = $this$readHashAndSign.readByte();
        byte sign = $this$readHashAndSign.readByte();
        boolean bl = sign != SignatureAlgorithm.ANON.getCode();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Anonymous signature not al";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new HashAndSign(hash, sign);
    }
}

