/*
 * Copyright 2020 Mamoe Technologies and contributors.
 *
 * 此源代码的使用受 GNU AFFERO GENERAL PUBLIC LICENSE version 3 许可证的约束, 可以在以下链接找到该许可证.
 * Use of this source code is governed by the GNU AGPLv3 license that can be found through the following link.
 *
 * https://github.com/mamoe/mirai/blob/master/LICENSE
 */

@file:Suppress("unused")

package net.mamoe.mirai.network

import net.mamoe.mirai.Bot
import net.mamoe.mirai.utils.MiraiExperimentalAPI

/**
 * 在 [登录][Bot.login] 失败时抛出, 可正常地中断登录过程.
 */
sealed class LoginFailedException : RuntimeException {
    constructor() : super()
    constructor(message: String?) : super(message)
    constructor(message: String?, cause: Throwable?) : super(message, cause)
    constructor(cause: Throwable?) : super(cause)
}

/**
 * 密码输入错误
 */
class WrongPasswordException(message: String?) : LoginFailedException(message)

/**
 * 需要短信验证时抛出. mirai 目前还不支持短信验证.
 */
@MiraiExperimentalAPI
class UnsupportedSMSLoginException(message: String?) : LoginFailedException(message)

/**
 * 非 mirai 实现的异常
 */
abstract class CustomLoginFailedException : LoginFailedException {
    constructor() : super()
    constructor(message: String?) : super(message)
    constructor(message: String?, cause: Throwable?) : super(message, cause)
    constructor(cause: Throwable?) : super(cause)
}