/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;

public class Comment
extends LeafNode {
    private static final String COMMENT_KEY = "comment";

    public Comment(String data2) {
        this.value = data2;
    }

    public Comment(String data2, String baseUri) {
        this(data2);
    }

    @Override
    public String nodeName() {
        return "#comment";
    }

    public String getData() {
        return this.coreValue();
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out2) throws IOException {
        if (out2.prettyPrint()) {
            this.indent(accum, depth, out2);
        }
        accum.append("<!--").append(this.getData()).append("-->");
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out2) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public boolean isXmlDeclaration() {
        String data2 = this.getData();
        return data2.length() > 1 && (data2.startsWith("!") || data2.startsWith("?"));
    }

    public XmlDeclaration asXmlDeclaration() {
        String data2 = this.getData();
        Document doc = Jsoup.parse("<" + data2.substring(1, data2.length() - 1) + ">", this.baseUri(), Parser.xmlParser());
        XmlDeclaration decl = null;
        if (doc.children().size() > 0) {
            Element el = doc.child(0);
            decl = new XmlDeclaration(NodeUtils.parser(doc).settings().normalizeTag(el.tagName()), data2.startsWith("!"));
            decl.attributes().addAll(el.attributes());
        }
        return decl;
    }
}

