/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapDeserializer
implements ObjectDeserializer {
    public static MapDeserializer instance = new MapDeserializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type2, Object fieldName) {
        if (type2 == JSONObject.class && parser.getFieldTypeResolver() == null) {
            return (T)parser.parseObject();
        }
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        boolean unmodifiableMap = type2 instanceof Class && "java.util.Collections$UnmodifiableMap".equals(((Class)type2).getName());
        Map<Object, Object> map2 = (lexer.getFeatures() & Feature.OrderedField.mask) != 0 ? this.createMap(type2, lexer.getFeatures()) : this.createMap(type2);
        ParseContext context = parser.getContext();
        try {
            parser.setContext(context, map2, fieldName);
            Map t = this.deserialze(parser, type2, fieldName, map2);
            if (unmodifiableMap) {
                t = Collections.unmodifiableMap(t);
            }
            Map map3 = t;
            return (T)map3;
        }
        finally {
            parser.setContext(context);
        }
    }

    protected Object deserialze(DefaultJSONParser parser, Type type2, Object fieldName, Map map2) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Object valueType = null;
            valueType = map2.getClass().getName().equals("org.springframework.util.LinkedMultiValueMap") ? List.class : parameterizedType.getActualTypeArguments()[1];
            if (String.class == keyType) {
                return MapDeserializer.parseMap(parser, map2, (Type)valueType, fieldName);
            }
            return MapDeserializer.parseMap(parser, map2, keyType, (Type)valueType, fieldName);
        }
        return parser.parseObject(map2, fieldName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map parseMap(DefaultJSONParser parser, Map<String, Object> map2, Type valueType, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token != 12) {
            String msg = "syntax error, expect {, actual " + lexer.tokenName();
            if (fieldName instanceof String) {
                msg = msg + ", fieldName ";
                msg = msg + fieldName;
            }
            msg = msg + ", ";
            msg = msg + lexer.info();
            if (token == 4) throw new JSONException(msg);
            JSONArray array = new JSONArray();
            parser.parseArray(array, fieldName);
            if (array.size() != 1) throw new JSONException(msg);
            Object first2 = array.get(0);
            if (!(first2 instanceof JSONObject)) throw new JSONException(msg);
            return (JSONObject)first2;
        }
        ParseContext context = parser.getContext();
        try {
            int i = 0;
            while (true) {
                block33: {
                    Map<String, Object> map3;
                    Object value;
                    String key;
                    lexer.skipWhitespace();
                    char ch = lexer.getCurrent();
                    if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                        while (ch == ',') {
                            lexer.next();
                            lexer.skipWhitespace();
                            ch = lexer.getCurrent();
                        }
                    }
                    if (ch == '\"') {
                        key = lexer.scanSymbol(parser.getSymbolTable(), '\"');
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos());
                        }
                    } else {
                        if (ch == '}') {
                            lexer.next();
                            lexer.resetStringPosition();
                            lexer.nextToken(16);
                            Map<String, Object> map4 = map2;
                            return map4;
                        }
                        if (ch == '\'') {
                            if (!lexer.isEnabled(Feature.AllowSingleQuotes)) {
                                throw new JSONException("syntax error");
                            }
                            key = lexer.scanSymbol(parser.getSymbolTable(), '\'');
                            lexer.skipWhitespace();
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("expect ':' at " + lexer.pos());
                            }
                        } else {
                            if (!lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                                throw new JSONException("syntax error");
                            }
                            key = lexer.scanSymbolUnQuoted(parser.getSymbolTable());
                            lexer.skipWhitespace();
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                            }
                        }
                    }
                    lexer.next();
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    lexer.resetStringPosition();
                    if (key == JSON.DEFAULT_TYPE_KEY && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                        String typeName = lexer.scanSymbol(parser.getSymbolTable(), '\"');
                        ParserConfig config2 = parser.getConfig();
                        Class<?> clazz = config2.checkAutoType(typeName, null, lexer.getFeatures());
                        if (Map.class.isAssignableFrom(clazz)) {
                            lexer.nextToken(16);
                            if (lexer.token() == 13) {
                                lexer.nextToken(16);
                                Map<String, Object> map5 = map2;
                                return map5;
                            }
                            break block33;
                        } else {
                            ObjectDeserializer deserializer = config2.getDeserializer(clazz);
                            lexer.nextToken(16);
                            parser.setResolveStatus(2);
                            if (context != null && !(fieldName instanceof Integer)) {
                                parser.popContext();
                            }
                            Map map6 = (Map)deserializer.deserialze(parser, clazz, fieldName);
                            return map6;
                        }
                    }
                    lexer.nextToken();
                    if (i != 0) {
                        parser.setContext(context);
                    }
                    if (lexer.token() == 8) {
                        value = null;
                        lexer.nextToken();
                    } else {
                        value = parser.parseObject(valueType, (Object)key);
                    }
                    map2.put(key, value);
                    parser.checkMapResolve(map2, key);
                    parser.setContext(context, value, key);
                    parser.setContext(context);
                    int tok = lexer.token();
                    if (tok == 20 || tok == 15) {
                        map3 = map2;
                        return map3;
                    }
                    if (tok == 13) {
                        lexer.nextToken();
                        map3 = map2;
                        return map3;
                    }
                }
                ++i;
            }
        }
        finally {
            parser.setContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseMap(DefaultJSONParser parser, Map<Object, Object> map2, Type keyType, Type valueType, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
        }
        ObjectDeserializer keyDeserializer = parser.getConfig().getDeserializer(keyType);
        ObjectDeserializer valueDeserializer = parser.getConfig().getDeserializer(valueType);
        lexer.nextToken(keyDeserializer.getFastMatchToken());
        ParseContext context = parser.getContext();
        try {
            while (true) {
                Object object;
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    break;
                }
                if (lexer.token() == 4 && lexer.isRef() && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                    Object ref;
                    object = null;
                    lexer.nextTokenWithColon(4);
                    if (lexer.token() == 4) {
                        ref = lexer.stringVal();
                        if ("..".equals(ref)) {
                            ParseContext parentContext = context.parent;
                            object = parentContext.object;
                        } else if ("$".equals(ref)) {
                            ParseContext rootContext = context;
                            while (rootContext.parent != null) {
                                rootContext = rootContext.parent;
                            }
                            object = rootContext.object;
                        } else {
                            parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                            parser.setResolveStatus(1);
                        }
                    } else {
                        throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                    }
                    lexer.nextToken(13);
                    if (lexer.token() != 13) {
                        throw new JSONException("illegal ref");
                    }
                    lexer.nextToken(16);
                    ref = object;
                    return ref;
                }
                if (map2.size() == 0 && lexer.token() == 4 && JSON.DEFAULT_TYPE_KEY.equals(lexer.stringVal()) && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                    lexer.nextTokenWithColon(4);
                    lexer.nextToken(16);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        object = map2;
                        return object;
                    }
                    lexer.nextToken(keyDeserializer.getFastMatchToken());
                }
                Object key = keyDeserializer.deserialze(parser, keyType, null);
                if (lexer.token() != 17) {
                    throw new JSONException("syntax error, expect :, actual " + lexer.token());
                }
                lexer.nextToken(valueDeserializer.getFastMatchToken());
                Object value = valueDeserializer.deserialze(parser, valueType, key);
                parser.checkMapResolve(map2, key);
                map2.put(key, value);
                if (lexer.token() != 16) continue;
                lexer.nextToken(keyDeserializer.getFastMatchToken());
            }
        }
        finally {
            parser.setContext(context);
        }
        return map2;
    }

    public Map<Object, Object> createMap(Type type2) {
        return this.createMap(type2, JSON.DEFAULT_GENERATE_FEATURE);
    }

    public Map<Object, Object> createMap(Type type2, int featrues) {
        if (type2 == Properties.class) {
            return new Properties();
        }
        if (type2 == Hashtable.class) {
            return new Hashtable<Object, Object>();
        }
        if (type2 == IdentityHashMap.class) {
            return new IdentityHashMap<Object, Object>();
        }
        if (type2 == SortedMap.class || type2 == TreeMap.class) {
            return new TreeMap<Object, Object>();
        }
        if (type2 == ConcurrentMap.class || type2 == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<Object, Object>();
        }
        if (type2 == Map.class) {
            return (featrues & Feature.OrderedField.mask) != 0 ? new LinkedHashMap() : new HashMap();
        }
        if (type2 == HashMap.class) {
            return new HashMap<Object, Object>();
        }
        if (type2 == LinkedHashMap.class) {
            return new LinkedHashMap<Object, Object>();
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type rawType = parameterizedType.getRawType();
            if (EnumMap.class.equals((Object)rawType)) {
                Type[] actualArgs = parameterizedType.getActualTypeArguments();
                return new EnumMap<Object, Object>((Class)actualArgs[0]);
            }
            return this.createMap(rawType, featrues);
        }
        Class clazz = (Class)type2;
        if (clazz.isInterface()) {
            throw new JSONException("unsupport type " + type2);
        }
        if ("java.util.Collections$UnmodifiableMap".equals(clazz.getName())) {
            return new HashMap<Object, Object>();
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("unsupport type " + type2, e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

