/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldTypeResolver;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JSON
implements JSONStreamAware,
JSONAware {
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    public static Locale defaultLocale = Locale.getDefault();
    public static String DEFAULT_TYPE_KEY = "@type";
    static final SerializeFilter[] emptyFilters = new SerializeFilter[0];
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_PARSER_FEATURE;
    public static int DEFAULT_GENERATE_FEATURE;
    private static final ConcurrentHashMap<Type, Type> mixInsMapper;
    private static final ThreadLocal<byte[]> bytesLocal;
    private static final ThreadLocal<char[]> charsLocal;
    public static final String VERSION = "1.2.62";

    private static void config(Properties properties2) {
        String featuresProperty = properties2.getProperty("fastjson.serializerFeatures.MapSortField");
        int mask = SerializerFeature.MapSortField.getMask();
        if ("true".equals(featuresProperty)) {
            DEFAULT_GENERATE_FEATURE |= mask;
        } else if ("false".equals(featuresProperty)) {
            DEFAULT_GENERATE_FEATURE &= ~mask;
        }
        if ("true".equals(properties2.getProperty("parser.features.NonStringKeyAsString"))) {
            DEFAULT_PARSER_FEATURE |= Feature.NonStringKeyAsString.getMask();
        }
        if ("true".equals(properties2.getProperty("parser.features.ErrorOnEnumNotMatch")) || "true".equals(properties2.getProperty("fastjson.parser.features.ErrorOnEnumNotMatch"))) {
            DEFAULT_PARSER_FEATURE |= Feature.ErrorOnEnumNotMatch.getMask();
        }
        if ("false".equals(properties2.getProperty("fastjson.asmEnable"))) {
            ParserConfig.getGlobalInstance().setAsmEnable(false);
            SerializeConfig.getGlobalInstance().setAsmEnable(false);
        }
    }

    public static void setDefaultTypeKey(String typeKey) {
        DEFAULT_TYPE_KEY = typeKey;
        ParserConfig.global.symbolTable.addSymbol(typeKey, 0, typeKey.length(), typeKey.hashCode(), true);
    }

    public static Object parse(String text) {
        return JSON.parse(text, DEFAULT_PARSER_FEATURE);
    }

    public static Object parse(String text, ParserConfig config2) {
        return JSON.parse(text, config2, DEFAULT_PARSER_FEATURE);
    }

    public static Object parse(String text, ParserConfig config2, int features) {
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, config2, features);
        Object value = parser.parse();
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static Object parse(String text, int features) {
        return JSON.parse(text, ParserConfig.getGlobalInstance(), features);
    }

    public static Object parse(byte[] input2, Feature ... features) {
        char[] chars = JSON.allocateChars(input2.length);
        int len = IOUtils.decodeUTF8(input2, 0, input2.length, chars);
        if (len < 0) {
            return null;
        }
        return JSON.parse(new String(chars, 0, len), features);
    }

    public static Object parse(byte[] input2, int off, int len, CharsetDecoder charsetDecoder, Feature ... features) {
        if (input2 == null || input2.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        return JSON.parse(input2, off, len, charsetDecoder, featureValues);
    }

    public static Object parse(byte[] input2, int off, int len, CharsetDecoder charsetDecoder, int features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = JSON.allocateChars(scaleLength);
        ByteBuffer byteBuf = ByteBuffer.wrap(input2, off, len);
        CharBuffer charBuf = CharBuffer.wrap(chars);
        IOUtils.decode(charsetDecoder, byteBuf, charBuf);
        int position = charBuf.position();
        DefaultJSONParser parser = new DefaultJSONParser(chars, position, ParserConfig.getGlobalInstance(), features);
        Object value = parser.parse();
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static Object parse(String text, Feature ... features) {
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        return JSON.parse(text, featureValues);
    }

    public static JSONObject parseObject(String text, Feature ... features) {
        return (JSONObject)JSON.parse(text, features);
    }

    public static JSONObject parseObject(String text) {
        Object obj = JSON.parse(text);
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        try {
            return (JSONObject)JSON.toJSON(obj);
        }
        catch (RuntimeException e) {
            throw new JSONException("can not cast to JSONObject.", e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> type2, Feature ... features) {
        return JSON.parseObject(text, type2.type, ParserConfig.global, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(String json, Class<T> clazz, Feature ... features) {
        return JSON.parseObject(json, clazz, ParserConfig.global, null, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(String text, Class<T> clazz, ParseProcess processor, Feature ... features) {
        return JSON.parseObject(text, clazz, ParserConfig.global, processor, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(String json, Type type2, Feature ... features) {
        return JSON.parseObject(json, type2, ParserConfig.global, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(String input2, Type clazz, ParseProcess processor, Feature ... features) {
        return JSON.parseObject(input2, clazz, ParserConfig.global, processor, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(String input2, Type clazz, int featureValues, Feature ... features) {
        if (input2 == null) {
            return null;
        }
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        DefaultJSONParser parser = new DefaultJSONParser(input2, ParserConfig.getGlobalInstance(), featureValues);
        Object value = parser.parseObject(clazz);
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static <T> T parseObject(String input2, Type clazz, ParserConfig config2, Feature ... features) {
        return JSON.parseObject(input2, clazz, config2, null, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(String input2, Type clazz, ParserConfig config2, int featureValues, Feature ... features) {
        return JSON.parseObject(input2, clazz, config2, null, featureValues, features);
    }

    public static <T> T parseObject(String input2, Type clazz, ParserConfig config2, ParseProcess processor, int featureValues, Feature ... features) {
        if (input2 == null || input2.isEmpty()) {
            return null;
        }
        if (features != null) {
            for (Feature feature : features) {
                featureValues |= feature.mask;
            }
        }
        DefaultJSONParser parser = new DefaultJSONParser(input2, config2, featureValues);
        if (processor != null) {
            if (processor instanceof ExtraTypeProvider) {
                parser.getExtraTypeProviders().add((ExtraTypeProvider)processor);
            }
            if (processor instanceof ExtraProcessor) {
                parser.getExtraProcessors().add((ExtraProcessor)processor);
            }
            if (processor instanceof FieldTypeResolver) {
                parser.setFieldTypeResolver((FieldTypeResolver)processor);
            }
        }
        Object value = parser.parseObject(clazz, null);
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static <T> T parseObject(byte[] bytes2, Type clazz, Feature ... features) {
        return JSON.parseObject(bytes2, 0, bytes2.length, IOUtils.UTF8, clazz, features);
    }

    public static <T> T parseObject(byte[] bytes2, int offset, int len, Charset charset, Type clazz, Feature ... features) {
        return JSON.parseObject(bytes2, offset, len, charset, clazz, ParserConfig.global, null, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(byte[] bytes2, Charset charset, Type clazz, ParserConfig config2, ParseProcess processor, int featureValues, Feature ... features) {
        return JSON.parseObject(bytes2, 0, bytes2.length, charset, clazz, config2, processor, featureValues, features);
    }

    public static <T> T parseObject(byte[] bytes2, int offset, int len, Charset charset, Type clazz, ParserConfig config2, ParseProcess processor, int featureValues, Feature ... features) {
        String strVal;
        if (charset == null) {
            charset = IOUtils.UTF8;
        }
        if (charset == IOUtils.UTF8) {
            char[] chars = JSON.allocateChars(bytes2.length);
            int chars_len = IOUtils.decodeUTF8(bytes2, offset, len, chars);
            if (chars_len < 0) {
                return null;
            }
            strVal = new String(chars, 0, chars_len);
        } else {
            if (len < 0) {
                return null;
            }
            strVal = new String(bytes2, offset, len, charset);
        }
        return JSON.parseObject(strVal, clazz, config2, processor, featureValues, features);
    }

    public static <T> T parseObject(byte[] input2, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature ... features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = JSON.allocateChars(scaleLength);
        ByteBuffer byteBuf = ByteBuffer.wrap(input2, off, len);
        CharBuffer charByte = CharBuffer.wrap(chars);
        IOUtils.decode(charsetDecoder, byteBuf, charByte);
        int position = charByte.position();
        return JSON.parseObject(chars, position, clazz, features);
    }

    public static <T> T parseObject(char[] input2, int length, Type clazz, Feature ... features) {
        if (input2 == null || input2.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        DefaultJSONParser parser = new DefaultJSONParser(input2, length, ParserConfig.getGlobalInstance(), featureValues);
        Object value = parser.parseObject(clazz);
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static <T> T parseObject(InputStream is, Type type2, Feature ... features) throws IOException {
        return JSON.parseObject(is, IOUtils.UTF8, type2, features);
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type type2, Feature ... features) throws IOException {
        return JSON.parseObject(is, charset, type2, ParserConfig.global, features);
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type type2, ParserConfig config2, Feature ... features) throws IOException {
        return JSON.parseObject(is, charset, type2, config2, null, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type type2, ParserConfig config2, ParseProcess processor, int featureValues, Feature ... features) throws IOException {
        int readCount;
        if (charset == null) {
            charset = IOUtils.UTF8;
        }
        byte[] bytes2 = JSON.allocateBytes(65536);
        int offset = 0;
        while ((readCount = is.read(bytes2, offset, bytes2.length - offset)) != -1) {
            if ((offset += readCount) != bytes2.length) continue;
            byte[] newBytes = new byte[bytes2.length * 3 / 2];
            System.arraycopy(bytes2, 0, newBytes, 0, bytes2.length);
            bytes2 = newBytes;
        }
        return JSON.parseObject(bytes2, 0, offset, charset, type2, config2, processor, featureValues, features);
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        return JSON.parseObject(text, clazz, new Feature[0]);
    }

    public static JSONArray parseArray(String text) {
        JSONArray array;
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, ParserConfig.getGlobalInstance());
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken();
            array = null;
        } else if (lexer.token() == 20) {
            array = null;
        } else {
            array = new JSONArray();
            parser.parseArray(array);
            parser.handleResovleTask(array);
        }
        parser.close();
        return array;
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        ArrayList list;
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, ParserConfig.getGlobalInstance());
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken();
            list = null;
        } else if (token == 20 && lexer.isBlankInput()) {
            list = null;
        } else {
            list = new ArrayList();
            parser.parseArray(clazz, list);
            parser.handleResovleTask(list);
        }
        parser.close();
        return list;
    }

    public static List<Object> parseArray(String text, Type[] types) {
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, ParserConfig.getGlobalInstance());
        Object[] objectArray = parser.parseArray(types);
        List<Object> list = objectArray == null ? null : Arrays.asList(objectArray);
        parser.handleResovleTask(list);
        parser.close();
        return list;
    }

    public static String toJSONString(Object object) {
        return JSON.toJSONString(object, emptyFilters, new SerializerFeature[0]);
    }

    public static String toJSONString(Object object, SerializerFeature ... features) {
        return JSON.toJSONString(object, DEFAULT_GENERATE_FEATURE, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJSONString(Object object, int defaultFeatures, SerializerFeature ... features) {
        SerializeWriter out2 = new SerializeWriter((Writer)null, defaultFeatures, features);
        try {
            JSONSerializer serializer2 = new JSONSerializer(out2);
            serializer2.write(object);
            String string = out2.toString();
            return string;
        }
        finally {
            out2.close();
        }
    }

    public static String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, null, dateFormat, DEFAULT_GENERATE_FEATURE, features);
    }

    public static String toJSONString(Object object, SerializeFilter filter2, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, new SerializeFilter[]{filter2}, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static String toJSONString(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, filters, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static byte[] toJSONBytes(Object object, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, DEFAULT_GENERATE_FEATURE, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter filter2, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, new SerializeFilter[]{filter2}, DEFAULT_GENERATE_FEATURE, features);
    }

    public static byte[] toJSONBytes(Object object, int defaultFeatures, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, defaultFeatures, features);
    }

    public static String toJSONString(Object object, SerializeConfig config2, SerializerFeature ... features) {
        return JSON.toJSONString(object, config2, (SerializeFilter)null, features);
    }

    public static String toJSONString(Object object, SerializeConfig config2, SerializeFilter filter2, SerializerFeature ... features) {
        return JSON.toJSONString(object, config2, new SerializeFilter[]{filter2}, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static String toJSONString(Object object, SerializeConfig config2, SerializeFilter[] filters, SerializerFeature ... features) {
        return JSON.toJSONString(object, config2, filters, null, DEFAULT_GENERATE_FEATURE, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJSONString(Object object, SerializeConfig config2, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        SerializeWriter out2 = new SerializeWriter(null, defaultFeatures, features);
        try {
            JSONSerializer serializer2 = new JSONSerializer(out2, config2);
            if (dateFormat != null && dateFormat.length() != 0) {
                serializer2.setDateFormat(dateFormat);
                serializer2.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (filters != null) {
                for (SerializeFilter filter2 : filters) {
                    serializer2.addFilter(filter2);
                }
            }
            serializer2.write(object);
            String string = out2.toString();
            return string;
        }
        finally {
            out2.close();
        }
    }

    public static String toJSONStringZ(Object object, SerializeConfig mapping, SerializerFeature ... features) {
        return JSON.toJSONString(object, mapping, emptyFilters, null, 0, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config2, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, config2, emptyFilters, DEFAULT_GENERATE_FEATURE, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config2, int defaultFeatures, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, config2, emptyFilters, defaultFeatures, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, filters, DEFAULT_GENERATE_FEATURE, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config2, SerializeFilter filter2, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, config2, new SerializeFilter[]{filter2}, DEFAULT_GENERATE_FEATURE, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config2, SerializeFilter[] filters, int defaultFeatures, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, config2, filters, null, defaultFeatures, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config2, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        return JSON.toJSONBytes(IOUtils.UTF8, object, config2, filters, dateFormat, defaultFeatures, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toJSONBytes(Charset charset, Object object, SerializeConfig config2, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        SerializeWriter out2 = new SerializeWriter(null, defaultFeatures, features);
        try {
            JSONSerializer serializer2 = new JSONSerializer(out2, config2);
            if (dateFormat != null && dateFormat.length() != 0) {
                serializer2.setDateFormat(dateFormat);
                serializer2.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (filters != null) {
                for (SerializeFilter filter2 : filters) {
                    serializer2.addFilter(filter2);
                }
            }
            serializer2.write(object);
            byte[] byArray = out2.toBytes(charset);
            return byArray;
        }
        finally {
            out2.close();
        }
    }

    public static String toJSONString(Object object, boolean prettyFormat) {
        if (!prettyFormat) {
            return JSON.toJSONString(object);
        }
        return JSON.toJSONString(object, SerializerFeature.PrettyFormat);
    }

    public static void writeJSONStringTo(Object object, Writer writer, SerializerFeature ... features) {
        JSON.writeJSONString(writer, object, features);
    }

    public static void writeJSONString(Writer writer, Object object, SerializerFeature ... features) {
        JSON.writeJSONString(writer, object, DEFAULT_GENERATE_FEATURE, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJSONString(Writer writer, Object object, int defaultFeatures, SerializerFeature ... features) {
        SerializeWriter out2 = new SerializeWriter(writer, defaultFeatures, features);
        try {
            JSONSerializer serializer2 = new JSONSerializer(out2);
            serializer2.write(object);
        }
        finally {
            out2.close();
        }
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializerFeature ... features) throws IOException {
        return JSON.writeJSONString(os, object, DEFAULT_GENERATE_FEATURE, features);
    }

    public static final int writeJSONString(OutputStream os, Object object, int defaultFeatures, SerializerFeature ... features) throws IOException {
        return JSON.writeJSONString(os, IOUtils.UTF8, object, SerializeConfig.globalInstance, null, null, defaultFeatures, features);
    }

    public static final int writeJSONString(OutputStream os, Charset charset, Object object, SerializerFeature ... features) throws IOException {
        return JSON.writeJSONString(os, charset, object, SerializeConfig.globalInstance, null, null, DEFAULT_GENERATE_FEATURE, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int writeJSONString(OutputStream os, Charset charset, Object object, SerializeConfig config2, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) throws IOException {
        SerializeWriter writer = new SerializeWriter(null, defaultFeatures, features);
        try {
            int len;
            JSONSerializer serializer2 = new JSONSerializer(writer, config2);
            if (dateFormat != null && dateFormat.length() != 0) {
                serializer2.setDateFormat(dateFormat);
                serializer2.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (filters != null) {
                for (SerializeFilter filter2 : filters) {
                    serializer2.addFilter(filter2);
                }
            }
            serializer2.write(object);
            int n = len = writer.writeToEx(os, charset);
            return n;
        }
        finally {
            writer.close();
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        SerializeWriter out2 = new SerializeWriter();
        try {
            new JSONSerializer(out2).write(this);
            String string = out2.toString();
            return string;
        }
        finally {
            out2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(SerializerFeature ... features) {
        SerializeWriter out2 = new SerializeWriter(null, DEFAULT_GENERATE_FEATURE, features);
        try {
            new JSONSerializer(out2).write(this);
            String string = out2.toString();
            return string;
        }
        finally {
            out2.close();
        }
    }

    @Override
    public void writeJSONString(Appendable appendable) {
        SerializeWriter out2 = new SerializeWriter();
        try {
            new JSONSerializer(out2).write(this);
            appendable.append(out2.toString());
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
        finally {
            out2.close();
        }
    }

    public static Object toJSON(Object javaObject) {
        return JSON.toJSON(javaObject, SerializeConfig.globalInstance);
    }

    public static Object toJSON(Object javaObject, ParserConfig parserConfig) {
        return JSON.toJSON(javaObject, SerializeConfig.globalInstance);
    }

    public static Object toJSON(Object javaObject, SerializeConfig config2) {
        if (javaObject == null) {
            return null;
        }
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        if (javaObject instanceof Map) {
            Map map2 = (Map)javaObject;
            int size2 = map2.size();
            AbstractMap innerMap = map2 instanceof LinkedHashMap ? new LinkedHashMap(size2) : (map2 instanceof TreeMap ? new TreeMap() : new HashMap(size2));
            JSONObject json = new JSONObject(innerMap);
            for (Map.Entry entry : map2.entrySet()) {
                Object key = entry.getKey();
                String jsonKey = TypeUtils.castToString(key);
                Object jsonValue = JSON.toJSON(entry.getValue(), config2);
                json.put(jsonKey, jsonValue);
            }
            return json;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            JSONArray array = new JSONArray(collection.size());
            for (Object item : collection) {
                Object jsonValue = JSON.toJSON(item, config2);
                array.add(jsonValue);
            }
            return array;
        }
        if (javaObject instanceof JSONSerializable) {
            String json = JSON.toJSONString(javaObject);
            return JSON.parse(json);
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isEnum()) {
            return ((Enum)javaObject).name();
        }
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            JSONArray array = new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                Object jsonValue = JSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        if (ParserConfig.isPrimitive2(clazz)) {
            return javaObject;
        }
        ObjectSerializer serializer2 = config2.getObjectWriter(clazz);
        if (serializer2 instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer2;
            JSONObject json = new JSONObject();
            try {
                Map<String, Object> values2 = javaBeanSerializer.getFieldValuesMap(javaObject);
                for (Map.Entry<String, Object> entry : values2.entrySet()) {
                    json.put(entry.getKey(), JSON.toJSON(entry.getValue(), config2));
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", e);
            }
            return json;
        }
        String text = JSON.toJSONString(javaObject);
        return JSON.parse(text);
    }

    public static <T> T toJavaObject(JSON json, Class<T> clazz) {
        return TypeUtils.cast((Object)json, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz == JSONArray.class || clazz == JSON.class || clazz == Collection.class || clazz == List.class) {
            return (T)this;
        }
        return TypeUtils.cast((Object)this, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Type type2) {
        return TypeUtils.cast((Object)this, type2, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(TypeReference typeReference) {
        Type type2 = typeReference != null ? typeReference.getType() : null;
        return TypeUtils.cast((Object)this, type2, ParserConfig.getGlobalInstance());
    }

    private static byte[] allocateBytes(int length) {
        byte[] chars = bytesLocal.get();
        if (chars == null) {
            if (length <= 65536) {
                chars = new byte[65536];
                bytesLocal.set(chars);
            } else {
                chars = new byte[length];
            }
        } else if (chars.length < length) {
            chars = new byte[length];
        }
        return chars;
    }

    private static char[] allocateChars(int length) {
        char[] chars = charsLocal.get();
        if (chars == null) {
            if (length <= 65536) {
                chars = new char[65536];
                charsLocal.set(chars);
            } else {
                chars = new char[length];
            }
        } else if (chars.length < length) {
            chars = new char[length];
        }
        return chars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        JSONScanner lexer = new JSONScanner(str);
        try {
            lexer.nextToken();
            int token = lexer.token();
            switch (token) {
                case 12: {
                    if (lexer.getCurrent() == '\u001a') {
                        boolean bl = false;
                        return bl;
                    }
                    lexer.skipObject(true);
                    break;
                }
                case 14: {
                    lexer.skipArray(true);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    lexer.nextToken();
                    break;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = lexer.token() == 20;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            lexer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidObject(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        JSONScanner lexer = new JSONScanner(str);
        try {
            lexer.nextToken();
            int token = lexer.token();
            if (token == 12) {
                if (lexer.getCurrent() == '\u001a') {
                    boolean bl = false;
                    return bl;
                }
                lexer.skipObject(true);
                boolean bl = lexer.token() == 20;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            lexer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidArray(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        JSONScanner lexer = new JSONScanner(str);
        try {
            lexer.nextToken();
            int token = lexer.token();
            if (token == 14) {
                lexer.skipArray(true);
                boolean bl = lexer.token() == 20;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            lexer.close();
        }
    }

    public static <T> void handleResovleTask(DefaultJSONParser parser, T value) {
        parser.handleResovleTask(value);
    }

    public static void addMixInAnnotations(Type target, Type mixinSource) {
        if (target != null && mixinSource != null) {
            mixInsMapper.put(target, mixinSource);
        }
    }

    public static void removeMixInAnnotations(Type target) {
        if (target != null) {
            mixInsMapper.remove(target);
        }
    }

    public static void clearMixInAnnotations() {
        mixInsMapper.clear();
    }

    public static Type getMixInAnnotations(Type target) {
        if (target != null) {
            return mixInsMapper.get(target);
        }
        return null;
    }

    static {
        mixInsMapper = new ConcurrentHashMap(16);
        int features = 0;
        features |= Feature.AutoCloseSource.getMask();
        features |= Feature.InternFieldNames.getMask();
        features |= Feature.UseBigDecimal.getMask();
        features |= Feature.AllowUnQuotedFieldNames.getMask();
        features |= Feature.AllowSingleQuotes.getMask();
        features |= Feature.AllowArbitraryCommas.getMask();
        features |= Feature.SortFeidFastMatch.getMask();
        DEFAULT_PARSER_FEATURE = features |= Feature.IgnoreNotMatch.getMask();
        features = 0;
        features |= SerializerFeature.QuoteFieldNames.getMask();
        features |= SerializerFeature.SkipTransientField.getMask();
        features |= SerializerFeature.WriteEnumUsingName.getMask();
        DEFAULT_GENERATE_FEATURE = features |= SerializerFeature.SortField.getMask();
        JSON.config(IOUtils.DEFAULT_PROPERTIES);
        bytesLocal = new ThreadLocal();
        charsLocal = new ThreadLocal();
    }
}

