/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Enumeration;

public class EnumerationSerializer
implements ObjectSerializer {
    public static EnumerationSerializer instance = new EnumerationSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out2 = serializer2.out;
        if (object == null) {
            out2.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        Type elementType = null;
        if (out2.isEnabled(SerializerFeature.WriteClassName) && fieldType instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)fieldType;
            elementType = param.getActualTypeArguments()[0];
        }
        Enumeration e = (Enumeration)object;
        SerialContext context = serializer2.context;
        serializer2.setContext(context, object, fieldName, 0);
        try {
            int i = 0;
            out2.append('[');
            while (e.hasMoreElements()) {
                Object item = e.nextElement();
                if (i++ != 0) {
                    out2.append(',');
                }
                if (item == null) {
                    out2.writeNull();
                    continue;
                }
                ObjectSerializer itemSerializer = serializer2.getObjectWriter(item.getClass());
                itemSerializer.write(serializer2, item, i - 1, elementType, 0);
            }
            out2.append(']');
        }
        finally {
            serializer2.context = context;
        }
    }
}

