/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.cio.ByteBufferPoolKt;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.jvm.javaio.ReadingKt;
import org.jetbrains.annotations.NotNull;

@KtorExperimentalAPI
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lio/ktor/http/content/URIFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "url", "Ljava/net/URL;", "contentType", "Lio/ktor/http/ContentType;", "(Ljava/net/URL;Lio/ktor/http/ContentType;)V", "uri", "Ljava/net/URI;", "(Ljava/net/URI;Lio/ktor/http/ContentType;)V", "getContentType", "()Lio/ktor/http/ContentType;", "getUri", "()Ljava/net/URI;", "readFrom", "Lkotlinx/coroutines/io/ByteReadChannel;", "ktor-http"})
public final class URIFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final URI uri;
    @NotNull
    private final ContentType contentType;

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        InputStream inputStream2 = this.uri.toURL().openStream();
        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "uri.toURL().openStream()");
        return ReadingKt.toByteReadChannel$default(inputStream2, null, ByteBufferPoolKt.getKtorDefaultPool(), 1, null);
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    public URIFileContent(@NotNull URI uri, @NotNull ContentType contentType2) {
        Intrinsics.checkParameterIsNotNull(uri, "uri");
        Intrinsics.checkParameterIsNotNull(contentType2, "contentType");
        this.uri = uri;
        this.contentType = contentType2;
    }

    public /* synthetic */ URIFileContent(URI uRI, ContentType contentType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = uRI.getPath();
            Intrinsics.checkExpressionValueIsNotNull(string, "uri.path");
            contentType2 = FileContentTypeKt.defaultForFilePath(ContentType.Companion, string);
        }
        this(uRI, contentType2);
    }

    public URIFileContent(@NotNull URL url2, @NotNull ContentType contentType2) {
        Intrinsics.checkParameterIsNotNull(url2, "url");
        Intrinsics.checkParameterIsNotNull(contentType2, "contentType");
        URI uRI = url2.toURI();
        Intrinsics.checkExpressionValueIsNotNull(uRI, "url.toURI()");
        this(uRI, contentType2);
    }

    public /* synthetic */ URIFileContent(URL uRL, ContentType contentType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = uRL.getPath();
            Intrinsics.checkExpressionValueIsNotNull(string, "url.path");
            contentType2 = FileContentTypeKt.defaultForFilePath(ContentType.Companion, string);
        }
        this(uRL, contentType2);
    }
}

