/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.AbstractDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateCodec
extends AbstractDateDeserializer
implements ObjectSerializer,
ObjectDeserializer {
    public static final DateCodec instance = new DateCodec();

    @Override
    public void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        TimeZone timeZone;
        int offset;
        long millis;
        SerializeWriter out2 = serializer2.out;
        if (object == null) {
            out2.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Date.class && ((millis = ((Date)object).getTime()) + (long)(offset = (timeZone = serializer2.timeZone).getOffset(millis))) % 86400000L == 0L && !SerializerFeature.isEnabled(out2.features, features, SerializerFeature.WriteClassName)) {
            out2.writeString(object.toString());
            return;
        }
        if (clazz == Time.class) {
            millis = ((Time)object).getTime();
            if ("unixtime".equals(serializer2.getDateFormatPattern())) {
                long seconds = millis / 1000L;
                out2.writeLong(seconds);
                return;
            }
            if ("millis".equals(serializer2.getDateFormatPattern())) {
                long seconds = millis;
                out2.writeLong(millis);
                return;
            }
            if (millis < 86400000L) {
                out2.writeString(object.toString());
                return;
            }
        }
        java.util.Date date = object instanceof java.util.Date ? (java.util.Date)object : TypeUtils.castToDate(object);
        if ("unixtime".equals(serializer2.getDateFormatPattern())) {
            long seconds = date.getTime() / 1000L;
            out2.writeLong(seconds);
            return;
        }
        if ("millis".equals(serializer2.getDateFormatPattern())) {
            long millis2 = date.getTime();
            out2.writeLong(millis2);
            return;
        }
        if (out2.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            DateFormat format = serializer2.getDateFormat();
            if (format == null) {
                format = new SimpleDateFormat(JSON.DEFFAULT_DATE_FORMAT, serializer2.locale);
                format.setTimeZone(serializer2.timeZone);
            }
            String text = format.format(date);
            out2.writeString(text);
            return;
        }
        if (out2.isEnabled(SerializerFeature.WriteClassName) && clazz != fieldType) {
            if (clazz == java.util.Date.class) {
                out2.write("new Date(");
                out2.writeLong(((java.util.Date)object).getTime());
                out2.write(41);
            } else {
                out2.write(123);
                out2.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                serializer2.write(clazz.getName());
                out2.writeFieldValue(',', "val", ((java.util.Date)object).getTime());
                out2.write(125);
            }
            return;
        }
        long time = date.getTime();
        if (out2.isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] buf;
            int quote = out2.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            out2.write(quote);
            Calendar calendar = Calendar.getInstance(serializer2.timeZone, serializer2.locale);
            calendar.setTimeInMillis(time);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            int millis3 = calendar.get(14);
            if (millis3 != 0) {
                buf = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(millis3, 23, buf);
                IOUtils.getChars(second, 19, buf);
                IOUtils.getChars(minute, 16, buf);
                IOUtils.getChars(hour, 13, buf);
                IOUtils.getChars(day, 10, buf);
                IOUtils.getChars(month, 7, buf);
                IOUtils.getChars(year, 4, buf);
            } else if (second == 0 && minute == 0 && hour == 0) {
                buf = "0000-00-00".toCharArray();
                IOUtils.getChars(day, 10, buf);
                IOUtils.getChars(month, 7, buf);
                IOUtils.getChars(year, 4, buf);
            } else {
                buf = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(second, 19, buf);
                IOUtils.getChars(minute, 16, buf);
                IOUtils.getChars(hour, 13, buf);
                IOUtils.getChars(day, 10, buf);
                IOUtils.getChars(month, 7, buf);
                IOUtils.getChars(year, 4, buf);
            }
            out2.write(buf);
            float timeZoneF = (float)calendar.getTimeZone().getOffset(calendar.getTimeInMillis()) / 3600000.0f;
            int timeZone2 = (int)timeZoneF;
            if ((double)timeZone2 == 0.0) {
                out2.write(90);
            } else {
                if (timeZone2 > 9) {
                    out2.write(43);
                    out2.writeInt(timeZone2);
                } else if (timeZone2 > 0) {
                    out2.write(43);
                    out2.write(48);
                    out2.writeInt(timeZone2);
                } else if (timeZone2 < -9) {
                    out2.write(45);
                    out2.writeInt(timeZone2);
                } else if (timeZone2 < 0) {
                    out2.write(45);
                    out2.write(48);
                    out2.writeInt(-timeZone2);
                }
                out2.write(58);
                int offSet = (int)((timeZoneF - (float)timeZone2) * 60.0f);
                out2.append(String.format("%02d", offSet));
            }
            out2.write(quote);
        } else {
            out2.writeLong(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof java.util.Date) {
            return (T)val;
        }
        if (val instanceof BigDecimal) {
            return (T)new java.util.Date(TypeUtils.longValue((BigDecimal)val));
        }
        if (val instanceof Number) {
            return (T)new java.util.Date(((Number)val).longValue());
        }
        if (val instanceof String) {
            String tzStr;
            TimeZone timeZone;
            String strVal = (String)val;
            if (strVal.length() == 0) {
                return null;
            }
            JSONScanner dateLexer = new JSONScanner(strVal);
            try {
                if (dateLexer.scanISO8601DateIfMatch(false)) {
                    Calendar calendar = dateLexer.getCalendar();
                    if (clazz == Calendar.class) {
                        Calendar calendar2 = calendar;
                        return (T)calendar2;
                    }
                    java.util.Date date = calendar.getTime();
                    return (T)date;
                }
            }
            finally {
                dateLexer.close();
            }
            if (strVal.length() == parser.getDateFomartPattern().length() || strVal.length() == 22 && parser.getDateFomartPattern().equals("yyyyMMddHHmmssSSSZ")) {
                DateFormat dateFormat = parser.getDateFormat();
                try {
                    return (T)dateFormat.parse(strVal);
                }
                catch (ParseException calendar) {
                    // empty catch block
                }
            }
            if (strVal.startsWith("/Date(") && strVal.endsWith(")/")) {
                String dotnetDateStr;
                strVal = dotnetDateStr = strVal.substring(6, strVal.length() - 2);
            }
            if ("0000-00-00".equals(strVal) || "0000-00-00T00:00:00".equalsIgnoreCase(strVal) || "0001-01-01T00:00:00+08:00".equalsIgnoreCase(strVal)) {
                return null;
            }
            int index = strVal.lastIndexOf(124);
            if (index > 20 && !"GMT".equals((timeZone = TimeZone.getTimeZone(tzStr = strVal.substring(index + 1))).getID())) {
                String subStr = strVal.substring(0, index);
                JSONScanner dateLexer2 = new JSONScanner(subStr);
                try {
                    if (dateLexer2.scanISO8601DateIfMatch(false)) {
                        Calendar calendar = dateLexer2.getCalendar();
                        calendar.setTimeZone(timeZone);
                        if (clazz == Calendar.class) {
                            Calendar calendar3 = calendar;
                            return (T)calendar3;
                        }
                        java.util.Date date = calendar.getTime();
                        return (T)date;
                    }
                }
                finally {
                    dateLexer2.close();
                }
            }
            long longVal = Long.parseLong(strVal);
            return (T)new java.util.Date(longVal);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

