/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.asm;

import com.alibaba.fastjson.asm.ByteVector;
import com.alibaba.fastjson.asm.FieldWriter;
import com.alibaba.fastjson.asm.Item;
import com.alibaba.fastjson.asm.MethodWriter;
import com.alibaba.fastjson.asm.Type;

public class ClassWriter {
    int version;
    int index = 1;
    final ByteVector pool = new ByteVector();
    Item[] items = new Item[256];
    int threshold = (int)(0.75 * (double)this.items.length);
    final Item key = new Item();
    final Item key2 = new Item();
    final Item key3 = new Item();
    Item[] typeTable;
    private int access;
    private int name;
    String thisName;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    FieldWriter firstField;
    FieldWriter lastField;
    MethodWriter firstMethod;
    MethodWriter lastMethod;

    public ClassWriter() {
        this(0);
    }

    private ClassWriter(int flags) {
    }

    public void visit(int version, int access, String name2, String superName, String[] interfaces) {
        this.version = version;
        this.access = access;
        this.name = this.newClassItem((String)name2).index;
        this.thisName = name2;
        int n = this.superName = superName == null ? 0 : this.newClassItem((String)superName).index;
        if (interfaces != null && interfaces.length > 0) {
            this.interfaceCount = interfaces.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.newClassItem((String)interfaces[i]).index;
            }
        }
    }

    public byte[] toByteArray() {
        int size2 = 24 + 2 * this.interfaceCount;
        int nbFields = 0;
        FieldWriter fb = this.firstField;
        while (fb != null) {
            ++nbFields;
            size2 += fb.getSize();
            fb = fb.next;
        }
        int nbMethods = 0;
        MethodWriter mb = this.firstMethod;
        while (mb != null) {
            ++nbMethods;
            size2 += mb.getSize();
            mb = mb.next;
        }
        int attributeCount = 0;
        ByteVector out2 = new ByteVector(size2 += this.pool.length);
        out2.putInt(-889275714).putInt(this.version);
        out2.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        int mask = 393216;
        out2.putShort(this.access & ~mask).putShort(this.name).putShort(this.superName);
        out2.putShort(this.interfaceCount);
        for (int i = 0; i < this.interfaceCount; ++i) {
            out2.putShort(this.interfaces[i]);
        }
        out2.putShort(nbFields);
        fb = this.firstField;
        while (fb != null) {
            fb.put(out2);
            fb = fb.next;
        }
        out2.putShort(nbMethods);
        mb = this.firstMethod;
        while (mb != null) {
            mb.put(out2);
            mb = mb.next;
        }
        out2.putShort(attributeCount);
        return out2.data;
    }

    Item newConstItem(Object cst) {
        if (cst instanceof Integer) {
            int val = (Integer)cst;
            this.key.set(val);
            Item result2 = this.get(this.key);
            if (result2 == null) {
                this.pool.putByte(3).putInt(val);
                result2 = new Item(this.index++, this.key);
                this.put(result2);
            }
            return result2;
        }
        if (cst instanceof String) {
            return this.newString((String)cst);
        }
        if (cst instanceof Type) {
            Type t = (Type)cst;
            return this.newClassItem(t.sort == 10 ? t.getInternalName() : t.getDescriptor());
        }
        throw new IllegalArgumentException("value " + cst);
    }

    public int newUTF8(String value) {
        this.key.set(1, value, null, null);
        Item result2 = this.get(this.key);
        if (result2 == null) {
            this.pool.putByte(1).putUTF8(value);
            result2 = new Item(this.index++, this.key);
            this.put(result2);
        }
        return result2.index;
    }

    public Item newClassItem(String value) {
        this.key2.set(7, value, null, null);
        Item result2 = this.get(this.key2);
        if (result2 == null) {
            this.pool.put12(7, this.newUTF8(value));
            result2 = new Item(this.index++, this.key2);
            this.put(result2);
        }
        return result2;
    }

    Item newFieldItem(String owner, String name2, String desc) {
        this.key3.set(9, owner, name2, desc);
        Item result2 = this.get(this.key3);
        if (result2 == null) {
            int s1 = this.newClassItem((String)owner).index;
            int s2 = this.newNameTypeItem((String)name2, (String)desc).index;
            this.pool.put12(9, s1).putShort(s2);
            result2 = new Item(this.index++, this.key3);
            this.put(result2);
        }
        return result2;
    }

    Item newMethodItem(String owner, String name2, String desc, boolean itf) {
        int type2 = itf ? 11 : 10;
        this.key3.set(type2, owner, name2, desc);
        Item result2 = this.get(this.key3);
        if (result2 == null) {
            int s1 = this.newClassItem((String)owner).index;
            int s2 = this.newNameTypeItem((String)name2, (String)desc).index;
            this.pool.put12(type2, s1).putShort(s2);
            result2 = new Item(this.index++, this.key3);
            this.put(result2);
        }
        return result2;
    }

    private Item newString(String value) {
        this.key2.set(8, value, null, null);
        Item result2 = this.get(this.key2);
        if (result2 == null) {
            this.pool.put12(8, this.newUTF8(value));
            result2 = new Item(this.index++, this.key2);
            this.put(result2);
        }
        return result2;
    }

    public Item newNameTypeItem(String name2, String desc) {
        this.key2.set(12, name2, desc, null);
        Item result2 = this.get(this.key2);
        if (result2 == null) {
            int s1 = this.newUTF8(name2);
            int s2 = this.newUTF8(desc);
            this.pool.put12(12, s1).putShort(s2);
            result2 = new Item(this.index++, this.key2);
            this.put(result2);
        }
        return result2;
    }

    private Item get(Item key) {
        Item i = this.items[key.hashCode % this.items.length];
        while (!(i == null || i.type == key.type && key.isEqualTo(i))) {
            i = i.next;
        }
        return i;
    }

    private void put(Item i) {
        if (this.index > this.threshold) {
            int ll = this.items.length;
            int nl = ll * 2 + 1;
            Item[] newItems = new Item[nl];
            for (int l = ll - 1; l >= 0; --l) {
                Item j = this.items[l];
                while (j != null) {
                    int index = j.hashCode % newItems.length;
                    Item k = j.next;
                    j.next = newItems[index];
                    newItems[index] = j;
                    j = k;
                }
            }
            this.items = newItems;
            this.threshold = (int)((double)nl * 0.75);
        }
        int index = i.hashCode % this.items.length;
        i.next = this.items[index];
        this.items[index] = i;
    }
}

