/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.asm.ClassReader;
import com.alibaba.fastjson.asm.TypeCollector;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class ASMUtils {
    public static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    public static final boolean IS_ANDROID = ASMUtils.isAndroid(JAVA_VM_NAME);

    public static boolean isAndroid(String vmName) {
        if (vmName == null) {
            return false;
        }
        String lowerVMName = vmName.toLowerCase();
        return lowerVMName.contains("dalvik") || lowerVMName.contains("lemur");
    }

    public static String desc(Method method) {
        Class<?>[] types = method.getParameterTypes();
        StringBuilder buf = new StringBuilder(types.length + 1 << 4);
        buf.append('(');
        for (int i = 0; i < types.length; ++i) {
            buf.append(ASMUtils.desc(types[i]));
        }
        buf.append(')');
        buf.append(ASMUtils.desc(method.getReturnType()));
        return buf.toString();
    }

    public static String desc(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return ASMUtils.getPrimitiveLetter(returnType);
        }
        if (returnType.isArray()) {
            return "[" + ASMUtils.desc(returnType.getComponentType());
        }
        return "L" + ASMUtils.type(returnType) + ";";
    }

    public static String type(Class<?> parameterType) {
        if (parameterType.isArray()) {
            return "[" + ASMUtils.desc(parameterType.getComponentType());
        }
        if (!parameterType.isPrimitive()) {
            String clsName = parameterType.getName();
            return clsName.replace('.', '/');
        }
        return ASMUtils.getPrimitiveLetter(parameterType);
    }

    public static String getPrimitiveLetter(Class<?> type2) {
        if (Integer.TYPE == type2) {
            return "I";
        }
        if (Void.TYPE == type2) {
            return "V";
        }
        if (Boolean.TYPE == type2) {
            return "Z";
        }
        if (Character.TYPE == type2) {
            return "C";
        }
        if (Byte.TYPE == type2) {
            return "B";
        }
        if (Short.TYPE == type2) {
            return "S";
        }
        if (Float.TYPE == type2) {
            return "F";
        }
        if (Long.TYPE == type2) {
            return "J";
        }
        if (Double.TYPE == type2) {
            return "D";
        }
        throw new IllegalStateException("Type: " + type2.getCanonicalName() + " is not a primitive type");
    }

    public static Type getMethodType(Class<?> clazz, String methodName) {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            return method.getGenericReturnType();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean checkName(String name2) {
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c >= '\u0001' && c <= '\u007f' && c != '.') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] lookupParameterNames(AccessibleObject methodOrCtor) {
        String className;
        String resourceName;
        InputStream is;
        Annotation[][] parameterAnnotations;
        Class<Object> declaringClass;
        String name2;
        Class<?>[] types;
        if (IS_ANDROID) {
            return new String[0];
        }
        if (methodOrCtor instanceof Method) {
            Method method = (Method)methodOrCtor;
            types = method.getParameterTypes();
            name2 = method.getName();
            declaringClass = method.getDeclaringClass();
            parameterAnnotations = TypeUtils.getParameterAnnotations(method);
        } else {
            Constructor constructor = (Constructor)methodOrCtor;
            types = constructor.getParameterTypes();
            declaringClass = constructor.getDeclaringClass();
            name2 = "<init>";
            parameterAnnotations = TypeUtils.getParameterAnnotations(constructor);
        }
        if (types.length == 0) {
            return new String[0];
        }
        ClassLoader classLoader = declaringClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((is = classLoader.getResourceAsStream(resourceName = (className = declaringClass.getName()).replace('.', '/') + ".class")) == null) {
            return new String[0];
        }
        try {
            ClassReader reader = new ClassReader(is, false);
            TypeCollector visitor2 = new TypeCollector(name2, types);
            reader.accept(visitor2);
            String[] parameterNames = visitor2.getParameterNamesForMethod();
            for (int i = 0; i < parameterNames.length; ++i) {
                Annotation[] annotations2 = parameterAnnotations[i];
                if (annotations2 == null) continue;
                for (int j = 0; j < annotations2.length; ++j) {
                    JSONField jsonField;
                    String fieldName;
                    if (!(annotations2[j] instanceof JSONField) || (fieldName = (jsonField = (JSONField)annotations2[j]).name()) == null || fieldName.length() <= 0) continue;
                    parameterNames[i] = fieldName;
                }
            }
            String[] stringArray = parameterNames;
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            IOUtils.close(is);
        }
    }
}

