/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features.websocket;

import io.ktor.client.request.ClientUpgradeContent;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.websocket.UtilsKt;
import io.ktor.util.Base64Kt;
import io.ktor.util.CryptoKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/ktor/client/features/websocket/WebSocketContent;", "Lio/ktor/client/request/ClientUpgradeContent;", "()V", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "nonce", "", "verify", "", "ktor-client-core"})
public final class WebSocketContent
extends ClientUpgradeContent {
    private final String nonce;
    @NotNull
    private final Headers headers;

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public void verify(@NotNull Headers headers2) {
        Intrinsics.checkParameterIsNotNull(headers2, "headers");
        String string = headers2.get(HttpHeaders.INSTANCE.getSecWebSocketAccept());
        if (string == null) {
            String string2 = "Server should specify header " + HttpHeaders.INSTANCE.getSecWebSocketAccept();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String serverAccept = string;
        String expectedAccept = UtilsKt.websocketServerAccept(this.nonce);
        boolean bl = Intrinsics.areEqual(expectedAccept, serverAccept);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string3 = "Failed to verify server accept header. Expected: " + expectedAccept + ", received: " + serverAccept;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
    }

    public WebSocketContent() {
        WebSocketContent webSocketContent = this;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        byte[] nonce = CryptoKt.generateNonce(16);
        $this$buildString.append(Base64Kt.encodeBase64(nonce));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        Object object = string;
        webSocketContent.nonce = object;
        HeadersBuilder headersBuilder = new HeadersBuilder(0, 1, null);
        webSocketContent = this;
        boolean bl5 = false;
        bl2 = false;
        HeadersBuilder $this$apply = headersBuilder;
        boolean bl6 = false;
        $this$apply.append(HttpHeaders.INSTANCE.getUpgrade(), "websocket");
        $this$apply.append(HttpHeaders.INSTANCE.getConnection(), "upgrade");
        $this$apply.append(HttpHeaders.INSTANCE.getSecWebSocketKey(), this.nonce);
        $this$apply.append(HttpHeaders.INSTANCE.getSecWebSocketVersion(), "13");
        object = headersBuilder;
        webSocketContent.headers = ((HeadersBuilder)object).build();
    }
}

