/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;

public class TokenQueue {
    private String queue;
    private int pos = 0;
    private static final char ESC = '\\';

    public TokenQueue(String data2) {
        Validate.notNull(data2);
        this.queue = data2;
    }

    public boolean isEmpty() {
        return this.remainingLength() == 0;
    }

    private int remainingLength() {
        return this.queue.length() - this.pos;
    }

    public char peek() {
        return this.isEmpty() ? (char)'\u0000' : this.queue.charAt(this.pos);
    }

    public void addFirst(Character c) {
        this.addFirst(c.toString());
    }

    public void addFirst(String seq) {
        this.queue = seq + this.queue.substring(this.pos);
        this.pos = 0;
    }

    public boolean matches(String seq) {
        return this.queue.regionMatches(true, this.pos, seq, 0, seq.length());
    }

    public boolean matchesCS(String seq) {
        return this.queue.startsWith(seq, this.pos);
    }

    public boolean matchesAny(String ... seq) {
        for (String s : seq) {
            if (!this.matches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        for (char c : seq) {
            if (this.queue.charAt(this.pos) != c) continue;
            return true;
        }
        return false;
    }

    public boolean matchesStartTag() {
        return this.remainingLength() >= 2 && this.queue.charAt(this.pos) == '<' && Character.isLetter(this.queue.charAt(this.pos + 1));
    }

    public boolean matchChomp(String seq) {
        if (this.matches(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && StringUtil.isWhitespace(this.queue.charAt(this.pos));
    }

    public boolean matchesWord() {
        return !this.isEmpty() && Character.isLetterOrDigit(this.queue.charAt(this.pos));
    }

    public void advance() {
        if (!this.isEmpty()) {
            ++this.pos;
        }
    }

    public char consume() {
        return this.queue.charAt(this.pos++);
    }

    public void consume(String seq) {
        if (!this.matches(seq)) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
        int len = seq.length();
        if (len > this.remainingLength()) {
            throw new IllegalStateException("Queue not long enough to consume sequence");
        }
        this.pos += len;
    }

    public String consumeTo(String seq) {
        int offset = this.queue.indexOf(seq, this.pos);
        if (offset != -1) {
            String consumed = this.queue.substring(this.pos, offset);
            this.pos += consumed.length();
            return consumed;
        }
        return this.remainder();
    }

    public String consumeToIgnoreCase(String seq) {
        int start2 = this.pos;
        String first2 = seq.substring(0, 1);
        boolean canScan = first2.toLowerCase().equals(first2.toUpperCase());
        while (!this.isEmpty() && !this.matches(seq)) {
            if (canScan) {
                int skip = this.queue.indexOf(first2, this.pos) - this.pos;
                if (skip == 0) {
                    ++this.pos;
                    continue;
                }
                if (skip < 0) {
                    this.pos = this.queue.length();
                    continue;
                }
                this.pos += skip;
                continue;
            }
            ++this.pos;
        }
        return this.queue.substring(start2, this.pos);
    }

    public String consumeToAny(String ... seq) {
        int start2 = this.pos;
        while (!this.isEmpty() && !this.matchesAny(seq)) {
            ++this.pos;
        }
        return this.queue.substring(start2, this.pos);
    }

    public String chompTo(String seq) {
        String data2 = this.consumeTo(seq);
        this.matchChomp(seq);
        return data2;
    }

    public String chompToIgnoreCase(String seq) {
        String data2 = this.consumeToIgnoreCase(seq);
        this.matchChomp(seq);
        return data2;
    }

    public String chompBalanced(char open, char close2) {
        String out2;
        int start2 = -1;
        int end2 = -1;
        int depth = 0;
        int last2 = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        while (!this.isEmpty()) {
            block14: {
                Character c;
                block13: {
                    c = Character.valueOf(this.consume());
                    if (last2 != 0 && last2 == 92) break block13;
                    if (c.equals(Character.valueOf('\'')) && c.charValue() != open && !inDoubleQuote) {
                        inSingleQuote = !inSingleQuote;
                    } else if (c.equals(Character.valueOf('\"')) && c.charValue() != open && !inSingleQuote) {
                        boolean bl = inDoubleQuote = !inDoubleQuote;
                    }
                    if (inSingleQuote || inDoubleQuote) break block14;
                    if (c.equals(Character.valueOf(open))) {
                        ++depth;
                        if (start2 == -1) {
                            start2 = this.pos;
                        }
                    } else if (c.equals(Character.valueOf(close2))) {
                        --depth;
                    }
                }
                if (depth > 0 && last2 != 0) {
                    end2 = this.pos;
                }
                last2 = c.charValue();
            }
            if (depth > 0) continue;
        }
        String string = out2 = end2 >= 0 ? this.queue.substring(start2, end2) : "";
        if (depth > 0) {
            Validate.fail("Did not find balanced marker at '" + out2 + "'");
        }
        return out2;
    }

    public static String unescape(String in) {
        StringBuilder out2 = StringUtil.borrowBuilder();
        char last2 = '\u0000';
        for (char c : in.toCharArray()) {
            if (c == '\\') {
                if (last2 != '\u0000' && last2 == '\\') {
                    out2.append(c);
                }
            } else {
                out2.append(c);
            }
            last2 = c;
        }
        return StringUtil.releaseBuilder(out2);
    }

    public boolean consumeWhitespace() {
        boolean seen = false;
        while (this.matchesWhitespace()) {
            ++this.pos;
            seen = true;
        }
        return seen;
    }

    public String consumeWord() {
        int start2 = this.pos;
        while (this.matchesWord()) {
            ++this.pos;
        }
        return this.queue.substring(start2, this.pos);
    }

    public String consumeTagName() {
        int start2 = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny(':', '_', '-'))) {
            ++this.pos;
        }
        return this.queue.substring(start2, this.pos);
    }

    public String consumeElementSelector() {
        int start2 = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny("*|", "|", "_", "-"))) {
            ++this.pos;
        }
        return this.queue.substring(start2, this.pos);
    }

    public String consumeCssIdentifier() {
        int start2 = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_'))) {
            ++this.pos;
        }
        return this.queue.substring(start2, this.pos);
    }

    public String consumeAttributeKey() {
        int start2 = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_', ':'))) {
            ++this.pos;
        }
        return this.queue.substring(start2, this.pos);
    }

    public String remainder() {
        String remainder = this.queue.substring(this.pos, this.queue.length());
        this.pos = this.queue.length();
        return remainder;
    }

    public String toString() {
        return this.queue.substring(this.pos);
    }
}

