/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils.cryptor;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.utils.PlatformUtilsJvmKt;
import net.mamoe.mirai.utils.cryptor.ECDHKeyPair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/mamoe/mirai/utils/cryptor/ECDH;", "", "keyPair", "Lnet/mamoe/mirai/utils/cryptor/ECDHKeyPair;", "(Lnet/mamoe/mirai/utils/cryptor/ECDHKeyPair;)V", "getKeyPair", "()Lnet/mamoe/mirai/utils/cryptor/ECDHKeyPair;", "calculateShareKeyByPeerPublicKey", "", "peerPublicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/utils/cryptor/ECDHPublicKey;", "toString", "", "Companion", "mirai-core"})
public final class ECDH {
    @NotNull
    private final ECDHKeyPair keyPair;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] calculateShareKeyByPeerPublicKey(@NotNull PublicKey peerPublicKey) {
        Intrinsics.checkParameterIsNotNull(peerPublicKey, "peerPublicKey");
        return Companion.calculateShareKey(this.keyPair.getPrivateKey(), peerPublicKey);
    }

    @NotNull
    public String toString() {
        return "ECDH(keyPair=" + this.keyPair + ')';
    }

    @NotNull
    public final ECDHKeyPair getKeyPair() {
        return this.keyPair;
    }

    public ECDH(@NotNull ECDHKeyPair keyPair) {
        Intrinsics.checkParameterIsNotNull(keyPair, "keyPair");
        this.keyPair = keyPair;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nJ\u0012\u0010\u000b\u001a\u00060\tj\u0002`\n2\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lnet/mamoe/mirai/utils/cryptor/ECDH$Companion;", "", "()V", "calculateShareKey", "", "privateKey", "Ljava/security/PrivateKey;", "Lnet/mamoe/mirai/utils/cryptor/ECDHPrivateKey;", "publicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/utils/cryptor/ECDHPublicKey;", "constructPublicKey", "key", "generateKeyPair", "Lnet/mamoe/mirai/utils/cryptor/ECDHKeyPair;", "mirai-core"})
    public static final class Companion {
        @NotNull
        public final ECDHKeyPair generateKeyPair() {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            boolean bl = false;
            boolean bl2 = false;
            KeyPairGenerator $this$apply = keyPairGenerator;
            boolean bl3 = false;
            $this$apply.initialize(new ECGenParameterSpec("secp192k1"));
            KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
            KeyPair keyPair = keyPairGenerator2.genKeyPair();
            Intrinsics.checkExpressionValueIsNotNull(keyPair, "KeyPairGenerator.getInst\u2026cp192k1\")) }.genKeyPair()");
            KeyPair keyPair2 = keyPair;
            return new ECDHKeyPair(keyPair2);
        }

        @NotNull
        public final byte[] calculateShareKey(@NotNull PrivateKey privateKey, @NotNull PublicKey publicKey) {
            Intrinsics.checkParameterIsNotNull(privateKey, "privateKey");
            Intrinsics.checkParameterIsNotNull(publicKey, "publicKey");
            KeyAgreement instance = KeyAgreement.getInstance("ECDH", "BC");
            instance.init(privateKey);
            instance.doPhase(publicKey, true);
            byte[] byArray = instance.generateSecret();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "instance.generateSecret()");
            return PlatformUtilsJvmKt.md5(byArray);
        }

        @NotNull
        public final PublicKey constructPublicKey(@NotNull byte[] key) {
            Intrinsics.checkParameterIsNotNull(key, "key");
            PublicKey publicKey = KeyFactory.getInstance("EC", "BC").generatePublic(new X509EncodedKeySpec(key));
            Intrinsics.checkExpressionValueIsNotNull(publicKey, "KeyFactory.getInstance(\"\u2026(X509EncodedKeySpec(key))");
            return publicKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

