/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OIDKt;
import io.ktor.network.tls.certificates.CertificateInfo;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.Counterparty;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.util.KtorExperimentalAPI;
import java.io.ByteArrayInputStream;
import java.net.Inet4Address;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.StringsKt;
import org.jetbrains.annotations.NotNull;

@KtorExperimentalAPI
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\r\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lio/ktor/network/tls/certificates/CertificateBuilder;", "", "()V", "daysValid", "", "getDaysValid", "()J", "setDaysValid", "(J)V", "hash", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "getHash", "()Lio/ktor/network/tls/extensions/HashAlgorithm;", "setHash", "(Lio/ktor/network/tls/extensions/HashAlgorithm;)V", "keySizeInBits", "", "getKeySizeInBits", "()I", "setKeySizeInBits", "(I)V", "password", "", "getPassword", "()Ljava/lang/String;", "setPassword", "(Ljava/lang/String;)V", "sign", "Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "getSign", "()Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "setSign", "(Lio/ktor/network/tls/extensions/SignatureAlgorithm;)V", "build", "Lio/ktor/network/tls/certificates/CertificateInfo;", "build$ktor_network_tls", "ktor-network-tls"})
public final class CertificateBuilder {
    @NotNull
    public HashAlgorithm hash;
    @NotNull
    public SignatureAlgorithm sign;
    @NotNull
    public String password;
    private long daysValid = 3L;
    private int keySizeInBits = 1024;

    @NotNull
    public final HashAlgorithm getHash() {
        HashAlgorithm hashAlgorithm = this.hash;
        if (hashAlgorithm == null) {
            Intrinsics.throwUninitializedPropertyAccessException("hash");
        }
        return hashAlgorithm;
    }

    public final void setHash(@NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)hashAlgorithm, "<set-?>");
        this.hash = hashAlgorithm;
    }

    @NotNull
    public final SignatureAlgorithm getSign() {
        SignatureAlgorithm signatureAlgorithm = this.sign;
        if (signatureAlgorithm == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sign");
        }
        return signatureAlgorithm;
    }

    public final void setSign(@NotNull SignatureAlgorithm signatureAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)signatureAlgorithm, "<set-?>");
        this.sign = signatureAlgorithm;
    }

    @NotNull
    public final String getPassword() {
        String string = this.password;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("password");
        }
        return string;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.password = string;
    }

    public final long getDaysValid() {
        return this.daysValid;
    }

    public final void setDaysValid(long l) {
        this.daysValid = l;
    }

    public final int getKeySizeInBits() {
        return this.keySizeInBits;
    }

    public final void setKeySizeInBits(int n) {
        this.keySizeInBits = n;
    }

    @NotNull
    public final CertificateInfo build$ktor_network_tls() {
        byte[] certificateBytes;
        ByteReadPacket byteReadPacket;
        HashAlgorithm hashAlgorithm = this.hash;
        if (hashAlgorithm == null) {
            Intrinsics.throwUninitializedPropertyAccessException("hash");
        }
        SignatureAlgorithm signatureAlgorithm = this.sign;
        if (signatureAlgorithm == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sign");
        }
        HashAndSign algorithm = new HashAndSign(hashAlgorithm, signatureAlgorithm);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm(algorithm.getName()));
        if (keyPairGenerator == null) {
            Intrinsics.throwNpe();
        }
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        boolean bl = false;
        boolean bl2 = false;
        KeyPairGenerator $this$apply = keyPairGenerator2;
        boolean bl3 = false;
        $this$apply.initialize(this.keySizeInBits);
        KeyPair keyPair = keyPairGenerator2.genKeyPair();
        if (keyPair == null) {
            Intrinsics.throwNpe();
        }
        KeyPair keys2 = keyPair;
        Counterparty id = new Counterparty("RU", "JetBrains", "Kotlin", "localhost");
        Date from = new Date();
        Date to = Date.from(LocalDateTime.now().plusDays(this.daysValid).atZone(ZoneId.systemDefault()).toInstant());
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl4 = false;
            String string = algorithm.getName();
            Date date = to;
            Intrinsics.checkExpressionValueIsNotNull(date, "to");
            CertificatesKt.writeCertificate($this$buildPacket, id, id, keys2, string, from, date, CollectionsKt.listOf("localhost"), CollectionsKt.listOf(Inet4Address.getByName("127.0.0.1")));
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        byte[] byArray = certificateBytes = StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        boolean bl5 = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate cert = certificateFactory.generateCertificate(byteArrayInputStream);
        cert.verify(keys2.getPublic());
        Certificate certificate = cert;
        Intrinsics.checkExpressionValueIsNotNull(certificate, "cert");
        String string = this.password;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("password");
        }
        return new CertificateInfo(certificate, keys2, string);
    }
}

