/*
 * Decompiled with CFR 0.152.
 */
package jpcap;

import java.io.IOException;
import jpcap.JpcapInstance;
import jpcap.JpcapSender;
import jpcap.NetworkInterface;
import jpcap.PacketReceiver;
import jpcap.packet.Packet;

public class JpcapCaptor
extends JpcapInstance {
    public int received_packets;
    public int dropped_packets;

    static {
        System.loadLibrary("jpcap");
    }

    private native String nativeOpenLive(String var1, int var2, int var3, int var4);

    private native String nativeOpenOffline(String var1);

    private native void nativeClose();

    private JpcapCaptor() throws IOException {
        if (this.reserveID() < 0) {
            throw new IOException("Unable to open a device: 255 devices are already opened.");
        }
    }

    public static native NetworkInterface[] getDeviceList();

    public static JpcapCaptor openDevice(NetworkInterface intrface, int snaplen, boolean promisc, int to_ms) throws IOException {
        JpcapCaptor jpcap = new JpcapCaptor();
        String ret = jpcap.nativeOpenLive(intrface.name, snaplen, promisc ? 1 : 0, to_ms);
        if (ret != null) {
            throw new IOException(ret);
        }
        return jpcap;
    }

    public static JpcapCaptor openFile(String filename) throws IOException {
        JpcapCaptor jpcap = new JpcapCaptor();
        String ret = jpcap.nativeOpenOffline(filename);
        if (ret != null) {
            throw new IOException(ret);
        }
        return jpcap;
    }

    public void close() {
        this.nativeClose();
        this.unreserveID();
    }

    public native Packet getPacket();

    public native int processPacket(int var1, PacketReceiver var2);

    public native int loopPacket(int var1, PacketReceiver var2);

    @Deprecated
    public int dispatchPacket(int count, PacketReceiver handler) {
        return this.processPacket(count, handler);
    }

    public native void setNonBlockingMode(boolean var1);

    public native boolean isNonBlockinMode();

    public native void breakLoop();

    public native boolean setPacketReadTimeout(int var1);

    public native int getPacketReadTimeout();

    public native void setFilter(String var1, boolean var2) throws IOException;

    public native void updateStat();

    public native String getErrorMessage();

    public JpcapSender getJpcapSenderInstance() {
        return new JpcapSender(this.ID);
    }
}

