/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmPackagePartSource
implements DeserializedContainerSource {
    @NotNull
    private final String moduleName;
    @NotNull
    private final JvmClassName className;
    @Nullable
    private final JvmClassName facadeClassName;
    @Nullable
    private final IncompatibleVersionErrorData<JvmMetadataVersion> incompatibility;
    private final boolean isPreReleaseInvisible;
    @Nullable
    private final KotlinJvmBinaryClass knownJvmBinaryClass;

    @Override
    @NotNull
    public String getPresentableString() {
        return "Class '" + this.getClassId().asSingleFqName().asString() + '\'';
    }

    @NotNull
    public final Name getSimpleName() {
        String string = this.className.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
        Name name2 = Name.identifier(StringsKt.substringAfterLast$default(string, '/', null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(classNam\u2026.substringAfterLast('/'))");
        return name2;
    }

    @NotNull
    public final ClassId getClassId() {
        return new ClassId(this.className.getPackageFqName(), this.getSimpleName());
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.className;
    }

    @Override
    @NotNull
    public SourceFile getContainingFile() {
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        Intrinsics.checkExpressionValueIsNotNull(sourceFile, "SourceFile.NO_SOURCE_FILE");
        return sourceFile;
    }

    @Nullable
    public final JvmClassName getFacadeClassName() {
        return this.facadeClassName;
    }

    @Nullable
    public final KotlinJvmBinaryClass getKnownJvmBinaryClass() {
        return this.knownJvmBinaryClass;
    }

    public JvmPackagePartSource(@NotNull JvmClassName className, @Nullable JvmClassName facadeClassName, @NotNull ProtoBuf.Package packageProto, @NotNull NameResolver nameResolver, @Nullable IncompatibleVersionErrorData<JvmMetadataVersion> incompatibility, boolean isPreReleaseInvisible, @Nullable KotlinJvmBinaryClass knownJvmBinaryClass) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull(className, "className");
                Intrinsics.checkParameterIsNotNull(packageProto, "packageProto");
                Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
                this.className = className;
                this.facadeClassName = facadeClassName;
                this.incompatibility = incompatibility;
                this.isPreReleaseInvisible = isPreReleaseInvisible;
                this.knownJvmBinaryClass = knownJvmBinaryClass;
                JvmPackagePartSource jvmPackagePartSource = this;
                GeneratedMessageLite.ExtendableMessage extendableMessage = packageProto;
                GeneratedMessageLite.GeneratedExtension<ProtoBuf.Package, Integer> generatedExtension = JvmProtoBuf.packageModuleName;
                Intrinsics.checkExpressionValueIsNotNull(generatedExtension, "JvmProtoBuf.packageModuleName");
                object = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
                if (object == null) break block2;
                Integer n = object;
                JvmPackagePartSource jvmPackagePartSource2 = jvmPackagePartSource;
                boolean bl = false;
                boolean bl2 = false;
                int p1 = ((Number)n).intValue();
                boolean bl3 = false;
                String string = nameResolver.getString(p1);
                jvmPackagePartSource = jvmPackagePartSource2;
                object = string;
                if (object != null) break block3;
            }
            object = "main";
        }
        jvmPackagePartSource.moduleName = object;
    }

    public JvmPackagePartSource(@NotNull KotlinJvmBinaryClass kotlinClass2, @NotNull ProtoBuf.Package packageProto, @NotNull NameResolver nameResolver, @Nullable IncompatibleVersionErrorData<JvmMetadataVersion> incompatibility, boolean isPreReleaseInvisible) {
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(kotlinClass2, "kotlinClass");
        Intrinsics.checkParameterIsNotNull(packageProto, "packageProto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        JvmPackagePartSource jvmPackagePartSource = this;
        JvmClassName jvmClassName2 = JvmClassName.byClassId(kotlinClass2.getClassId());
        JvmClassName jvmClassName3 = jvmClassName2;
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName2, "JvmClassName.byClassId(kotlinClass.classId)");
        String string = kotlinClass2.getClassHeader().getMultifileClassName();
        if (string != null) {
            String string2 = string;
            JvmClassName jvmClassName4 = jvmClassName3;
            JvmPackagePartSource jvmPackagePartSource2 = jvmPackagePartSource;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            JvmClassName jvmClassName5 = charSequence.length() > 0 ? JvmClassName.byInternalName(it) : null;
            jvmPackagePartSource = jvmPackagePartSource2;
            jvmClassName3 = jvmClassName4;
            jvmClassName = jvmClassName5;
        } else {
            jvmClassName = null;
        }
        jvmPackagePartSource(jvmClassName3, jvmClassName, packageProto, nameResolver, incompatibility, isPreReleaseInvisible, kotlinClass2);
    }
}

