/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.extensions.NamedCurve;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"generateECKeys", "Lio/ktor/network/tls/EncryptionInfo;", "curve", "Lio/ktor/network/tls/extensions/NamedCurve;", "serverPoint", "Ljava/security/spec/ECPoint;", "generateClientSeed", "", "Ljava/security/SecureRandom;", "ktor-network-tls"})
public final class TLSClientHandshakeKt {
    private static final byte[] generateClientSeed(@NotNull SecureRandom $this$generateClientSeed) {
        byte[] seed = new byte[32];
        $this$generateClientSeed.nextBytes(seed);
        byte[] byArray = seed;
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        long unixTime = System.currentTimeMillis() / 1000L;
        it[0] = (byte)(unixTime >> 24);
        it[1] = (byte)(unixTime >> 16);
        it[2] = (byte)(unixTime >> 8);
        it[3] = (byte)(unixTime >> 0);
        return byArray;
    }

    private static final EncryptionInfo generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        if (keyPairGenerator == null) {
            Intrinsics.throwNpe();
        }
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        boolean bl = false;
        boolean bl2 = false;
        KeyPairGenerator $this$run = keyPairGenerator2;
        boolean bl3 = false;
        $this$run.initialize(new ECGenParameterSpec(curve.name()));
        KeyPair keyPair = $this$run.generateKeyPair();
        if (keyPair == null) {
            Intrinsics.throwNpe();
        }
        KeyPair clientKeys = keyPair;
        PublicKey publicKey = clientKeys.getPublic();
        if (publicKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        }
        ECPublicKey publicKey2 = (ECPublicKey)publicKey;
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        if (keyFactory == null) {
            Intrinsics.throwNpe();
        }
        KeyFactory factory = keyFactory;
        ECParameterSpec eCParameterSpec = publicKey2.getParams();
        if (eCParameterSpec == null) {
            Intrinsics.throwNpe();
        }
        PublicKey publicKey3 = factory.generatePublic(new ECPublicKeySpec(serverPoint, eCParameterSpec));
        if (publicKey3 == null) {
            Intrinsics.throwNpe();
        }
        PublicKey serverPublic = publicKey3;
        PublicKey publicKey4 = clientKeys.getPublic();
        Intrinsics.checkExpressionValueIsNotNull(publicKey4, "clientKeys.public");
        PrivateKey privateKey = clientKeys.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull(privateKey, "clientKeys.private");
        return new EncryptionInfo(serverPublic, publicKey4, privateKey);
    }

    public static final /* synthetic */ EncryptionInfo access$generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        return TLSClientHandshakeKt.generateECKeys(curve, serverPoint);
    }

    public static final /* synthetic */ byte[] access$generateClientSeed(SecureRandom $this$access_u24generateClientSeed) {
        return TLSClientHandshakeKt.generateClientSeed($this$access_u24generateClientSeed);
    }
}

