/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class CollectionCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final CollectionCodec instance = new CollectionCodec();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out2 = serializer2.out;
        if (object == null) {
            out2.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        Type elementType = null;
        if (out2.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(features, SerializerFeature.WriteClassName)) {
            elementType = TypeUtils.getCollectionItemType(fieldType);
        }
        Collection collection = (Collection)object;
        SerialContext context = serializer2.context;
        serializer2.setContext(context, object, fieldName, 0);
        if (out2.isEnabled(SerializerFeature.WriteClassName)) {
            if (HashSet.class == collection.getClass()) {
                out2.append("Set");
            } else if (TreeSet.class == collection.getClass()) {
                out2.append("TreeSet");
            }
        }
        try {
            int i = 0;
            out2.append('[');
            for (Object item : collection) {
                if (i++ != 0) {
                    out2.append(',');
                }
                if (item == null) {
                    out2.writeNull();
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out2.writeInt((Integer)item);
                    continue;
                }
                if (clazz == Long.class) {
                    out2.writeLong((Long)item);
                    if (!out2.isEnabled(SerializerFeature.WriteClassName)) continue;
                    out2.write(76);
                    continue;
                }
                ObjectSerializer itemSerializer = serializer2.getObjectWriter(clazz);
                if (SerializerFeature.isEnabled(features, SerializerFeature.WriteClassName) && itemSerializer instanceof JavaBeanSerializer) {
                    JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)itemSerializer;
                    javaBeanSerializer.writeNoneASM(serializer2, item, i - 1, elementType, features);
                    continue;
                }
                itemSerializer.write(serializer2, item, i - 1, elementType, features);
            }
            out2.append(']');
        }
        finally {
            serializer2.context = context;
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type2, Object fieldName) {
        if (parser.lexer.token() == 8) {
            parser.lexer.nextToken(16);
            return null;
        }
        if (type2 == JSONArray.class) {
            JSONArray array = new JSONArray();
            parser.parseArray(array);
            return (T)array;
        }
        Collection list = TypeUtils.createCollection(type2);
        Type itemType = TypeUtils.getCollectionItemType(type2);
        parser.parseArray(itemType, list, fieldName);
        return (T)list;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

