/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class ArraySerializer
implements ObjectSerializer {
    private final Class<?> componentType;
    private final ObjectSerializer compObjectSerializer;

    public ArraySerializer(Class<?> componentType, ObjectSerializer compObjectSerializer) {
        this.componentType = componentType;
        this.compObjectSerializer = compObjectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out2 = serializer2.out;
        if (object == null) {
            out2.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        Object[] array = (Object[])object;
        int size2 = array.length;
        SerialContext context = serializer2.context;
        serializer2.setContext(context, object, fieldName, 0);
        try {
            out2.append('[');
            for (int i = 0; i < size2; ++i) {
                Object item;
                if (i != 0) {
                    out2.append(',');
                }
                if ((item = array[i]) == null) {
                    if (out2.isEnabled(SerializerFeature.WriteNullStringAsEmpty) && object instanceof String[]) {
                        out2.writeString("");
                        continue;
                    }
                    out2.append("null");
                    continue;
                }
                if (item.getClass() == this.componentType) {
                    this.compObjectSerializer.write(serializer2, item, i, null, 0);
                    continue;
                }
                ObjectSerializer itemSerializer = serializer2.getObjectWriter(item.getClass());
                itemSerializer.write(serializer2, item, i, null, 0);
            }
            out2.append(']');
        }
        finally {
            serializer2.context = context;
        }
    }
}

