/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils.cryptor;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.utils.cryptor.ECDH;
import net.mamoe.mirai.utils.cryptor.ECDHKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lnet/mamoe/mirai/utils/cryptor/ECDHKeyPair;", "", "delegate", "Ljava/security/KeyPair;", "(Ljava/security/KeyPair;)V", "privateKey", "Ljava/security/PrivateKey;", "Lnet/mamoe/mirai/utils/cryptor/ECDHPrivateKey;", "getPrivateKey", "()Ljava/security/PrivateKey;", "publicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/utils/cryptor/ECDHPublicKey;", "getPublicKey", "()Ljava/security/PublicKey;", "shareKey", "", "getShareKey", "()[B", "mirai-core"})
public final class ECDHKeyPair {
    @NotNull
    private final byte[] shareKey;
    private final KeyPair delegate;

    @NotNull
    public final PrivateKey getPrivateKey() {
        PrivateKey privateKey = this.delegate.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull(privateKey, "delegate.private");
        return privateKey;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        PublicKey publicKey = this.delegate.getPublic();
        Intrinsics.checkExpressionValueIsNotNull(publicKey, "delegate.public");
        return publicKey;
    }

    @NotNull
    public final byte[] getShareKey() {
        return this.shareKey;
    }

    public ECDHKeyPair(@NotNull KeyPair delegate2) {
        Intrinsics.checkParameterIsNotNull(delegate2, "delegate");
        this.delegate = delegate2;
        this.shareKey = ECDH.Companion.calculateShareKey(this.getPrivateKey(), ECDHKt.getInitialPublicKey());
    }
}

