/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.ByteBuffer;
import kotlinx.serialization.AbstractSerialFormat;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.CoreKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ElementValueDecoder;
import kotlinx.serialization.ElementValueEncoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.ShorthandsKt;
import kotlinx.serialization.StructureKind;
import kotlinx.serialization.UpdateMode;
import kotlinx.serialization.cbor.CborDecodingException;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.internal.HexConverter;
import kotlinx.serialization.internal.UtilKt;
import kotlinx.serialization.modules.EmptyModule;
import kotlinx.serialization.modules.SerialModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u000b\u001a\u001b\u001c\u001d\u001e\u001f !\"#$B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ)\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0013\u001a\u0002H\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0015\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lkotlinx/serialization/cbor/Cbor;", "Lkotlinx/serialization/AbstractSerialFormat;", "Lkotlinx/serialization/BinaryFormat;", "updateMode", "Lkotlinx/serialization/UpdateMode;", "encodeDefaults", "", "context", "Lkotlinx/serialization/modules/SerialModule;", "(Lkotlinx/serialization/UpdateMode;ZLkotlinx/serialization/modules/SerialModule;)V", "getEncodeDefaults", "()Z", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "dump", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "obj", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "load", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "CborDecoder", "CborEncoder", "CborEntryReader", "CborEntryWriter", "CborListReader", "CborListWriter", "CborMapReader", "CborMapWriter", "CborReader", "CborWriter", "Companion", "kotlinx-serialization-runtime"})
public final class Cbor
extends AbstractSerialFormat
implements BinaryFormat {
    @NotNull
    private final UpdateMode updateMode;
    private final boolean encodeDefaults;
    private static final int FALSE = 244;
    private static final int TRUE = 245;
    private static final int NULL = 246;
    private static final int NEXT_FLOAT = 250;
    private static final int NEXT_DOUBLE = 251;
    private static final int BEGIN_ARRAY = 159;
    private static final int BEGIN_MAP = 191;
    private static final int BREAK = 255;
    private static final byte HEADER_STRING = 96;
    private static final byte HEADER_NEGATIVE = 32;
    private static final int HEADER_ARRAY = 128;
    private static final int HEADER_MAP = 160;
    @NotNull
    private static final Cbor plain;
    public static final Companion Companion;

    @Override
    @NotNull
    public <T> byte[] dump(@NotNull SerializationStrategy<? super T> serializer2, T obj) {
        Intrinsics.checkParameterIsNotNull(serializer2, "serializer");
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        CborWriter dumper = new CborWriter(new CborEncoder(output2));
        CoreKt.encode(dumper, serializer2, obj);
        byte[] byArray = output2.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "output.toByteArray()");
        return byArray;
    }

    @Override
    public <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes2) {
        Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
        Intrinsics.checkParameterIsNotNull(bytes2, "bytes");
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes2);
        CborReader reader = new CborReader(new CborDecoder(stream));
        return CoreKt.decode(reader, deserializer);
    }

    @NotNull
    public final UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public final boolean getEncodeDefaults() {
        return this.encodeDefaults;
    }

    public Cbor(@NotNull UpdateMode updateMode, boolean encodeDefaults, @NotNull SerialModule context) {
        Intrinsics.checkParameterIsNotNull((Object)updateMode, "updateMode");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.updateMode = updateMode;
        this.encodeDefaults = encodeDefaults;
    }

    public /* synthetic */ Cbor(UpdateMode updateMode, boolean bl, SerialModule serialModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            updateMode = UpdateMode.BANNED;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            serialModule = EmptyModule.INSTANCE;
        }
        this(updateMode, bl, serialModule);
    }

    public Cbor() {
        this(null, false, null, 7, null);
    }

    static {
        Companion = new Companion(null);
        plain = new Cbor(null, false, null, 7, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborEntryWriter;", "Lkotlinx/serialization/cbor/Cbor$CborWriter;", "Lkotlinx/serialization/cbor/Cbor;", "encoder", "Lkotlinx/serialization/cbor/Cbor$CborEncoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborEncoder;)V", "encodeElement", "", "desc", "Lkotlinx/serialization/SerialDescriptor;", "index", "", "endStructure", "", "writeBeginToken", "kotlinx-serialization-runtime"})
    private final class CborEntryWriter
    extends CborWriter {
        @Override
        protected void writeBeginToken() {
        }

        @Override
        public void endStructure(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
        }

        @Override
        public boolean encodeElement(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            return true;
        }

        public CborEntryWriter(CborEncoder encoder2) {
            Intrinsics.checkParameterIsNotNull(encoder2, "encoder");
            super(encoder2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborMapWriter;", "Lkotlinx/serialization/cbor/Cbor$CborListWriter;", "Lkotlinx/serialization/cbor/Cbor;", "encoder", "Lkotlinx/serialization/cbor/Cbor$CborEncoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborEncoder;)V", "writeBeginToken", "", "kotlinx-serialization-runtime"})
    private final class CborMapWriter
    extends CborListWriter {
        @Override
        protected void writeBeginToken() {
            this.getEncoder().startMap();
        }

        public CborMapWriter(CborEncoder encoder2) {
            Intrinsics.checkParameterIsNotNull(encoder2, "encoder");
            super(encoder2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborListWriter;", "Lkotlinx/serialization/cbor/Cbor$CborWriter;", "Lkotlinx/serialization/cbor/Cbor;", "encoder", "Lkotlinx/serialization/cbor/Cbor$CborEncoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborEncoder;)V", "encodeElement", "", "desc", "Lkotlinx/serialization/SerialDescriptor;", "index", "", "writeBeginToken", "", "kotlinx-serialization-runtime"})
    private class CborListWriter
    extends CborWriter {
        @Override
        protected void writeBeginToken() {
            this.getEncoder().startArray();
        }

        @Override
        public boolean encodeElement(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            return true;
        }

        public CborListWriter(CborEncoder encoder2) {
            Intrinsics.checkParameterIsNotNull(encoder2, "encoder");
            super(encoder2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0092\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J1\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\"\u0006\u0012\u0002\b\u00030\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001fH\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0014H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u00100\u001a\u00020\u0014H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00061"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborWriter;", "Lkotlinx/serialization/ElementValueEncoder;", "encoder", "Lkotlinx/serialization/cbor/Cbor$CborEncoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborEncoder;)V", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "getEncoder", "()Lkotlinx/serialization/cbor/Cbor$CborEncoder;", "beginStructure", "Lkotlinx/serialization/CompositeEncoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeEncoder;", "encodeBoolean", "", "value", "", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "ordinal", "encodeFloat", "", "encodeInt", "encodeLong", "", "encodeNull", "encodeShort", "", "encodeString", "", "endStructure", "shouldEncodeElementDefault", "writeBeginToken", "kotlinx-serialization-runtime"})
    private class CborWriter
    extends ElementValueEncoder {
        @NotNull
        private final CborEncoder encoder;

        @Override
        @NotNull
        public SerialModule getContext() {
            return Cbor.this.getContext();
        }

        @Override
        public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            return Cbor.this.getEncodeDefaults();
        }

        protected void writeBeginToken() {
            this.encoder.startMap();
        }

        @Override
        @NotNull
        public CompositeEncoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            Intrinsics.checkParameterIsNotNull(typeParams, "typeParams");
            SerialKind serialKind = desc.getKind();
            CborWriter writer = Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE) ? (CborWriter)new CborListWriter(this.encoder) : (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE) ? (CborWriter)new CborMapWriter(this.encoder) : new CborWriter(this.encoder));
            writer.writeBeginToken();
            return writer;
        }

        @Override
        public void endStructure(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            this.encoder.end();
        }

        @Override
        public boolean encodeElement(@NotNull SerialDescriptor desc, int index) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            String name2 = desc.getElementName(index);
            this.encoder.encodeString(name2);
            return true;
        }

        @Override
        public void encodeString(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            this.encoder.encodeString(value);
        }

        @Override
        public void encodeFloat(float value) {
            this.encoder.encodeFloat(value);
        }

        @Override
        public void encodeDouble(double value) {
            this.encoder.encodeDouble(value);
        }

        @Override
        public void encodeChar(char value) {
            this.encoder.encodeNumber(value);
        }

        @Override
        public void encodeByte(byte value) {
            this.encoder.encodeNumber(value);
        }

        @Override
        public void encodeShort(short value) {
            this.encoder.encodeNumber(value);
        }

        @Override
        public void encodeInt(int value) {
            this.encoder.encodeNumber(value);
        }

        @Override
        public void encodeLong(long value) {
            this.encoder.encodeNumber(value);
        }

        @Override
        public void encodeBoolean(boolean value) {
            this.encoder.encodeBoolean(value);
        }

        @Override
        public void encodeNull() {
            this.encoder.encodeNull();
        }

        @Override
        public void encodeEnum(@NotNull EnumDescriptor enumDescription, int ordinal) {
            Intrinsics.checkParameterIsNotNull(enumDescription, "enumDescription");
            this.encoder.encodeString(enumDescription.getElementName(ordinal));
        }

        @NotNull
        public final CborEncoder getEncoder() {
            return this.encoder;
        }

        public CborWriter(CborEncoder encoder2) {
            Intrinsics.checkParameterIsNotNull(encoder2, "encoder");
            this.encoder = encoder2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u000fJ\u0006\u0010\u001b\u001a\u00020\u000fR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborEncoder;", "", "output", "Ljava/io/OutputStream;", "Lkotlinx/io/OutputStream;", "(Ljava/io/OutputStream;)V", "getOutput", "()Ljava/io/OutputStream;", "composeNegative", "", "value", "", "composeNumber", "composePositive", "encodeBoolean", "", "", "encodeDouble", "", "encodeFloat", "", "encodeNull", "encodeNumber", "encodeString", "", "end", "startArray", "startMap", "kotlinx-serialization-runtime"})
    public static final class CborEncoder {
        @NotNull
        private final OutputStream output;

        public final void startArray() {
            this.output.write(159);
        }

        public final void startMap() {
            this.output.write(191);
        }

        public final void end() {
            this.output.write(255);
        }

        public final void encodeNull() {
            this.output.write(246);
        }

        public final void encodeBoolean(boolean value) {
            this.output.write(value ? 245 : 244);
        }

        public final void encodeNumber(long value) {
            this.output.write(this.composeNumber(value));
        }

        public final void encodeString(@NotNull String value) {
            byte by;
            Intrinsics.checkParameterIsNotNull(value, "value");
            byte[] data2 = SerializationKt.toUtf8Bytes(value);
            byte[] header = this.composeNumber(data2.length);
            byte by2 = header[0];
            int n = 96;
            int n2 = 0;
            byte[] byArray = header;
            boolean bl = false;
            byArray[n2] = by = (byte)(by2 | n);
            this.output.write(header);
            this.output.write(data2);
        }

        public final void encodeFloat(float value) {
            byte[] data2 = ByteBuffer.Companion.allocate(5).put((byte)250).putFloat(value).array();
            this.output.write(data2);
        }

        public final void encodeDouble(double value) {
            byte[] data2 = ByteBuffer.Companion.allocate(9).put((byte)251).putDouble(value).array();
            this.output.write(data2);
        }

        private final byte[] composeNumber(long value) {
            return value >= 0L ? this.composePositive(value) : this.composeNegative(value);
        }

        private final byte[] composePositive(long value) {
            byte[] byArray;
            long l = value;
            long l2 = l;
            if (0L <= l2 && (long)23 >= l2) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = (byte)value;
            } else {
                l2 = l;
                if ((long)24 <= l2 && (long)127 >= l2) {
                    byte[] byArray3 = new byte[2];
                    byArray3[0] = 24;
                    byArray = byArray3;
                    byArray3[1] = (byte)value;
                } else {
                    l2 = l;
                    if ((long)128 <= l2 && (long)Short.MAX_VALUE >= l2) {
                        byArray = ByteBuffer.Companion.allocate(3).put((byte)25).putShort((short)value).array();
                    } else {
                        l2 = l;
                        if ((long)32768 <= l2 && (long)Integer.MAX_VALUE >= l2) {
                            byArray = ByteBuffer.Companion.allocate(5).put((byte)26).putInt((int)value).array();
                        } else {
                            l2 = l;
                            if (0x80000000L <= l2 && Long.MAX_VALUE >= l2) {
                                byArray = ByteBuffer.Companion.allocate(9).put((byte)27).putLong(value).array();
                            } else {
                                throw (Throwable)((Object)new AssertionError((Object)(value + " should be positive")));
                            }
                        }
                    }
                }
            }
            return byArray;
        }

        private final byte[] composeNegative(long value) {
            byte by;
            long aVal = value == Long.MIN_VALUE ? Long.MAX_VALUE : (long)-1 - value;
            byte[] data2 = this.composePositive(aVal);
            byte by2 = data2[0];
            int n = 32;
            int n2 = 0;
            byte[] byArray = data2;
            boolean bl = false;
            byArray[n2] = by = (byte)(by2 | n);
            return data2;
        }

        @NotNull
        public final OutputStream getOutput() {
            return this.output;
        }

        public CborEncoder(@NotNull OutputStream output2) {
            Intrinsics.checkParameterIsNotNull(output2, "output");
            this.output = output2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborEntryReader;", "Lkotlinx/serialization/cbor/Cbor$CborReader;", "Lkotlinx/serialization/cbor/Cbor;", "decoder", "Lkotlinx/serialization/cbor/Cbor$CborDecoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborDecoder;)V", "ind", "", "decodeElementIndex", "desc", "Lkotlinx/serialization/SerialDescriptor;", "endStructure", "", "skipBeginToken", "kotlinx-serialization-runtime"})
    private final class CborEntryReader
    extends CborReader {
        private int ind;

        @Override
        protected void skipBeginToken() {
        }

        @Override
        public void endStructure(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
        }

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor desc) {
            int n;
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            int n2 = this.ind;
            this.ind = n2 + 1;
            switch (n2) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            return n;
        }

        public CborEntryReader(CborDecoder decoder2) {
            Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
            super(decoder2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborMapReader;", "Lkotlinx/serialization/cbor/Cbor$CborListReader;", "Lkotlinx/serialization/cbor/Cbor;", "decoder", "Lkotlinx/serialization/cbor/Cbor$CborDecoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborDecoder;)V", "skipBeginToken", "", "kotlinx-serialization-runtime"})
    private final class CborMapReader
    extends CborListReader {
        @Override
        protected void skipBeginToken() {
            this.setSize(this.getDecoder().startMap() * 2);
        }

        public CborMapReader(CborDecoder decoder2) {
            Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
            super(decoder2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborListReader;", "Lkotlinx/serialization/cbor/Cbor$CborReader;", "Lkotlinx/serialization/cbor/Cbor;", "decoder", "Lkotlinx/serialization/cbor/Cbor$CborDecoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborDecoder;)V", "ind", "", "decodeElementIndex", "desc", "Lkotlinx/serialization/SerialDescriptor;", "skipBeginToken", "", "kotlinx-serialization-runtime"})
    private class CborListReader
    extends CborReader {
        private int ind;

        @Override
        protected void skipBeginToken() {
            this.setSize(this.getDecoder().startArray());
        }

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor desc) {
            int n;
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            if (!this.getFiniteMode() && this.getDecoder().isEnd() || this.getFiniteMode() && this.ind >= this.getSize()) {
                n = -1;
            } else {
                int n2 = this.ind;
                this.ind = n2 + 1;
                n = n2;
            }
            return n;
        }

        public CborListReader(CborDecoder decoder2) {
            Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
            super(decoder2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J1\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u001a\u0010\u001d\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001e\"\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0011H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\fH\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010:\u001a\u0002092\u0006\u0010\u0012\u001a\u00020\u0011H\u0004J\b\u0010;\u001a\u000209H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0011@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006<"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborReader;", "Lkotlinx/serialization/ElementValueDecoder;", "decoder", "Lkotlinx/serialization/cbor/Cbor$CborDecoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/Cbor$CborDecoder;)V", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "getDecoder", "()Lkotlinx/serialization/cbor/Cbor$CborDecoder;", "<set-?>", "", "finiteMode", "getFiniteMode", "()Z", "readProperties", "", "size", "getSize", "()I", "updateMode", "Lkotlinx/serialization/UpdateMode;", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "beginStructure", "Lkotlinx/serialization/CompositeDecoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeDecoder;", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescription", "Lkotlinx/serialization/internal/EnumDescriptor;", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "", "endStructure", "", "setSize", "skipBeginToken", "kotlinx-serialization-runtime"})
    private class CborReader
    extends ElementValueDecoder {
        private int size;
        private boolean finiteMode;
        private int readProperties;
        @NotNull
        private final CborDecoder decoder;

        protected final int getSize() {
            return this.size;
        }

        protected final boolean getFiniteMode() {
            return this.finiteMode;
        }

        protected final void setSize(int size2) {
            if (size2 >= 0) {
                this.finiteMode = true;
                this.size = size2;
            }
        }

        @Override
        @NotNull
        public SerialModule getContext() {
            return Cbor.this.getContext();
        }

        @Override
        @NotNull
        public UpdateMode getUpdateMode() {
            return Cbor.this.getUpdateMode();
        }

        protected void skipBeginToken() {
            this.setSize(this.decoder.startMap());
        }

        @Override
        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            Intrinsics.checkParameterIsNotNull(typeParams, "typeParams");
            SerialKind serialKind = desc.getKind();
            CborReader re = Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE) ? (CborReader)new CborListReader(this.decoder) : (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE) ? (CborReader)new CborMapReader(this.decoder) : new CborReader(this.decoder));
            re.skipBeginToken();
            return re;
        }

        @Override
        public void endStructure(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            if (!this.finiteMode) {
                this.decoder.end();
            }
        }

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor desc) {
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            if (!this.finiteMode && this.decoder.isEnd() || this.finiteMode && this.readProperties >= this.size) {
                return -1;
            }
            String elemName = this.decoder.nextString();
            int n = this.readProperties;
            this.readProperties = n + 1;
            return ShorthandsKt.getElementIndexOrThrow(desc, elemName);
        }

        @Override
        @NotNull
        public String decodeString() {
            return this.decoder.nextString();
        }

        @Override
        public boolean decodeNotNullMark() {
            return !this.decoder.isNull();
        }

        @Override
        public double decodeDouble() {
            return this.decoder.nextDouble();
        }

        @Override
        public float decodeFloat() {
            return this.decoder.nextFloat();
        }

        @Override
        public boolean decodeBoolean() {
            return this.decoder.nextBoolean();
        }

        @Override
        public byte decodeByte() {
            return (byte)this.decoder.nextNumber();
        }

        @Override
        public short decodeShort() {
            return (short)this.decoder.nextNumber();
        }

        @Override
        public char decodeChar() {
            return (char)this.decoder.nextNumber();
        }

        @Override
        public int decodeInt() {
            return (int)this.decoder.nextNumber();
        }

        @Override
        public long decodeLong() {
            return this.decoder.nextNumber();
        }

        @Override
        @Nullable
        public Void decodeNull() {
            return this.decoder.nextNull();
        }

        @Override
        public int decodeEnum(@NotNull EnumDescriptor enumDescription) {
            Intrinsics.checkParameterIsNotNull(enumDescription, "enumDescription");
            return ShorthandsKt.getElementIndexOrThrow(enumDescription, this.decoder.nextString());
        }

        @NotNull
        public final CborDecoder getDecoder() {
            return this.decoder;
        }

        public CborReader(CborDecoder decoder2) {
            Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
            this.decoder = decoder2;
            this.size = -1;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0007J \u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lkotlinx/serialization/cbor/Cbor$CborDecoder;", "", "input", "Ljava/io/InputStream;", "Lkotlinx/io/InputStream;", "(Ljava/io/InputStream;)V", "curByte", "", "getInput", "()Ljava/io/InputStream;", "end", "", "isEnd", "", "isNull", "nextBoolean", "nextDouble", "", "nextFloat", "", "nextNull", "", "nextNumber", "", "nextString", "", "readByte", "readNumber", "skipByte", "expected", "startArray", "startMap", "startSized", "unboundedHeader", "boundedHeaderMask", "collectionType", "kotlinx-serialization-runtime"})
    public static final class CborDecoder {
        private int curByte;
        @NotNull
        private final InputStream input;

        private final int readByte() {
            this.curByte = this.input.read();
            return this.curByte;
        }

        private final void skipByte(int expected) {
            if (this.curByte != expected) {
                throw (Throwable)new CborDecodingException("byte " + HexConverter.INSTANCE.toHexString(expected), this.curByte);
            }
            this.readByte();
        }

        public final boolean isNull() {
            return this.curByte == 246;
        }

        @Nullable
        public final Void nextNull() {
            this.skipByte(246);
            return null;
        }

        public final boolean nextBoolean() {
            boolean bl;
            switch (this.curByte) {
                case 245: {
                    bl = true;
                    break;
                }
                case 244: {
                    bl = false;
                    break;
                }
                default: {
                    throw (Throwable)new CborDecodingException("boolean value", this.curByte);
                }
            }
            boolean ans = bl;
            this.readByte();
            return ans;
        }

        public final int startArray() {
            return this.startSized(159, 128, "array");
        }

        public final int startMap() {
            return this.startSized(191, 160, "map");
        }

        private final int startSized(int unboundedHeader, int boundedHeaderMask, String collectionType) {
            if (this.curByte == unboundedHeader) {
                this.skipByte(unboundedHeader);
                return -1;
            }
            if ((this.curByte & 0xE0) != boundedHeaderMask) {
                throw (Throwable)new CborDecodingException("start of " + collectionType, this.curByte);
            }
            int size2 = (int)this.readNumber();
            this.readByte();
            return size2;
        }

        public final boolean isEnd() {
            return this.curByte == 255;
        }

        public final void end() {
            this.skipByte(255);
        }

        @NotNull
        public final String nextString() {
            if ((this.curByte & 0xE0) != 96) {
                throw (Throwable)new CborDecodingException("start of string", this.curByte);
            }
            int strLen = (int)this.readNumber();
            byte[] arr = UtilKt.readExactNBytes(this.input, strLen);
            String ans = SerializationKt.stringFromUtf8Bytes(arr);
            this.readByte();
            return ans;
        }

        public final long nextNumber() {
            long res = this.readNumber();
            this.readByte();
            return res;
        }

        private final long readNumber() {
            long l;
            int bytesToRead;
            int value = this.curByte & 0x1F;
            boolean negative = (this.curByte & 0xE0) == 32;
            switch (value) {
                case 24: {
                    int n = 1;
                    break;
                }
                case 25: {
                    int n = 2;
                    break;
                }
                case 26: {
                    int n = 4;
                    break;
                }
                case 27: {
                    int n = 8;
                    break;
                }
                default: {
                    int n = bytesToRead = 0;
                }
            }
            if (bytesToRead == 0) {
                if (negative) {
                    return -((long)(value + 1));
                }
                return value;
            }
            ByteBuffer buf = UtilKt.readToByteBuffer(this.input, bytesToRead);
            switch (bytesToRead) {
                case 1: {
                    l = UtilKt.getUnsignedByte(buf);
                    break;
                }
                case 2: {
                    l = UtilKt.getUnsignedShort(buf);
                    break;
                }
                case 4: {
                    l = UtilKt.getUnsignedInt(buf);
                    break;
                }
                case 8: {
                    l = buf.getLong();
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError());
                }
            }
            long res = l;
            return negative ? -(res + 1L) : res;
        }

        public final float nextFloat() {
            if (this.curByte != 250) {
                throw (Throwable)new CborDecodingException("float header", this.curByte);
            }
            float res = UtilKt.readToByteBuffer(this.input, 4).getFloat();
            this.readByte();
            return res;
        }

        public final double nextDouble() {
            if (this.curByte != 251) {
                throw (Throwable)new CborDecodingException("double header", this.curByte);
            }
            double res = UtilKt.readToByteBuffer(this.input, 8).getDouble();
            this.readByte();
            return res;
        }

        @NotNull
        public final InputStream getInput() {
            return this.input;
        }

        public CborDecoder(@NotNull InputStream input2) {
            Intrinsics.checkParameterIsNotNull(input2, "input");
            this.input = input2;
            this.curByte = -1;
            this.readByte();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\u0006\u0010\u001e\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0012H\u0016J)\u0010#\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001b0%2\u0006\u0010&\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lkotlinx/serialization/cbor/Cbor$Companion;", "Lkotlinx/serialization/BinaryFormat;", "()V", "BEGIN_ARRAY", "", "BEGIN_MAP", "BREAK", "FALSE", "HEADER_ARRAY", "HEADER_MAP", "HEADER_NEGATIVE", "", "HEADER_STRING", "NEXT_DOUBLE", "NEXT_FLOAT", "NULL", "TRUE", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "plain", "Lkotlinx/serialization/cbor/Cbor;", "getPlain", "()Lkotlinx/serialization/cbor/Cbor;", "dump", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "obj", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "install", "", "module", "load", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "kotlinx-serialization-runtime"})
    public static final class Companion
    implements BinaryFormat {
        @NotNull
        public final Cbor getPlain() {
            return plain;
        }

        @Override
        @NotNull
        public <T> byte[] dump(@NotNull SerializationStrategy<? super T> serializer2, T obj) {
            Intrinsics.checkParameterIsNotNull(serializer2, "serializer");
            return this.getPlain().dump(serializer2, obj);
        }

        @Override
        public <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes2) {
            Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
            Intrinsics.checkParameterIsNotNull(bytes2, "bytes");
            return this.getPlain().load(deserializer, bytes2);
        }

        @NotNull
        public Void install(@NotNull SerialModule module) {
            Intrinsics.checkParameterIsNotNull(module, "module");
            throw (Throwable)new IllegalStateException("You should not install anything to global instance");
        }

        @Override
        @NotNull
        public SerialModule getContext() {
            return Companion.getPlain().getContext();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

