/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class ObjectArrayCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final ObjectArrayCodec instance = new ObjectArrayCodec();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer serializer2, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out2 = serializer2.out;
        Object[] array = (Object[])object;
        if (object == null) {
            out2.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        int size2 = array.length;
        int end2 = size2 - 1;
        if (end2 == -1) {
            out2.append("[]");
            return;
        }
        SerialContext context = serializer2.context;
        serializer2.setContext(context, object, fieldName, 0);
        try {
            Class<?> preClazz = null;
            ObjectSerializer preWriter = null;
            out2.append('[');
            if (out2.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer2.incrementIndent();
                serializer2.println();
                for (int i = 0; i < size2; ++i) {
                    if (i != 0) {
                        out2.write(44);
                        serializer2.println();
                    }
                    serializer2.write(array[i]);
                }
                serializer2.decrementIdent();
                serializer2.println();
                out2.write(93);
                return;
            }
            for (int i = 0; i < end2; ++i) {
                Object item = array[i];
                if (item == null) {
                    out2.append("null,");
                    continue;
                }
                if (serializer2.containsReference(item)) {
                    serializer2.writeReference(item);
                } else {
                    Class<?> clazz = item.getClass();
                    if (clazz == preClazz) {
                        preWriter.write(serializer2, item, i, null, 0);
                    } else {
                        preClazz = clazz;
                        preWriter = serializer2.getObjectWriter(clazz);
                        preWriter.write(serializer2, item, i, null, 0);
                    }
                }
                out2.append(',');
            }
            Object item = array[end2];
            if (item == null) {
                out2.append("null]");
            } else {
                if (serializer2.containsReference(item)) {
                    serializer2.writeReference(item);
                } else {
                    serializer2.writeWithFieldName(item, end2);
                }
                out2.append(']');
            }
        }
        finally {
            serializer2.context = context;
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type2, Object fieldName) {
        Class<Object> componentClass;
        Class<?> componentType;
        Type clazz;
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        if (token == 4 || token == 26) {
            byte[] bytes2 = lexer.bytesValue();
            lexer.nextToken(16);
            if (bytes2.length == 0 && type2 != byte[].class) {
                return null;
            }
            return (T)bytes2;
        }
        if (type2 instanceof GenericArrayType) {
            clazz = (GenericArrayType)type2;
            componentType = clazz.getGenericComponentType();
            if (componentType instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)((Object)componentType);
                Type objType = parser.getContext().type;
                if (objType instanceof ParameterizedType) {
                    ParameterizedType objParamType = (ParameterizedType)objType;
                    Type objRawType = objParamType.getRawType();
                    Type actualType = null;
                    if (objRawType instanceof Class) {
                        TypeVariable<Class<T>>[] objTypeParams = ((Class)objRawType).getTypeParameters();
                        for (int i = 0; i < objTypeParams.length; ++i) {
                            if (!objTypeParams[i].getName().equals(typeVar.getName())) continue;
                            actualType = objParamType.getActualTypeArguments()[i];
                        }
                    }
                    componentClass = actualType instanceof Class ? (Class<Object>)actualType : Object.class;
                } else {
                    componentClass = TypeUtils.getClass(typeVar.getBounds()[0]);
                }
            } else {
                componentClass = TypeUtils.getClass(componentType);
            }
        } else {
            clazz = (Class)type2;
            componentClass = ((Class)clazz).getComponentType();
            componentType = componentClass;
        }
        JSONArray array = new JSONArray();
        parser.parseArray(componentType, array, fieldName);
        return this.toObjectArray(parser, componentClass, array);
    }

    private <T> T toObjectArray(DefaultJSONParser parser, Class<?> componentType, JSONArray array) {
        if (array == null) {
            return null;
        }
        int size2 = array.size();
        Object objArray = Array.newInstance(componentType, size2);
        for (int i = 0; i < size2; ++i) {
            Object element;
            Object value = array.get(i);
            if (value == array) {
                Array.set(objArray, i, objArray);
                continue;
            }
            if (componentType.isArray()) {
                element = componentType.isInstance(value) ? value : this.toObjectArray(parser, componentType, (JSONArray)value);
                Array.set(objArray, i, element);
                continue;
            }
            element = null;
            if (value instanceof JSONArray) {
                boolean contains2 = false;
                JSONArray valueArray = (JSONArray)value;
                int valueArraySize = valueArray.size();
                for (int y = 0; y < valueArraySize; ++y) {
                    Object valueItem = valueArray.get(y);
                    if (valueItem != array) continue;
                    valueArray.set(i, objArray);
                    contains2 = true;
                }
                if (contains2) {
                    element = valueArray.toArray();
                }
            }
            if (element == null) {
                element = TypeUtils.cast(value, componentType, parser.getConfig());
            }
            Array.set(objArray, i, element);
        }
        array.setRelatedArray(objArray);
        array.setComponentType(componentType);
        return (T)objArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

