#! /usr/bin/perl

# Determine the keys that should be in the locale file,
# and the number of arguments the keys should have

our %found;

use File::Find;
find(\&doit, '../../src');

sub arg_count {
	return scalar split(/,/,$_[0]);
}

sub make_comment {
	my $input = $_[0];
	$input =~ s/(_[A-Z])/_COMMENT$1/g;
	return $input;
}

# for each .cpp/.hpp file, collect locale calls
sub doit {
	my $file = $File::Find::name;
	if (!($file =~ /\..pp$/)) {
		return;
	}
	
	# relative filename
	#print "$file\n";
	$file =~ s@.*/@@;
	
	# Read file
	open F, "< $file";
	my $body = join('',<F>);
	close F;
	
	# Custom argument expansion
	$inparen = qr/[^()]|\((??{$inparen})*\)/; # recursive paren matching
	$body =~ s/format_string\((_[A-Z]+)(_\([^)]+\)),($inparen+)/
	           $1 . "_" . arg_count($3) . $2
	          /ge;
	$body =~ s/action_name_for[(][^,]*,\s*(_[A-Z]+)(_\([^)]+\))/$1_1$2/g;
	
	# Drop comments, mark found items as 'optional'
	$body =~ s@//[^\n]*@ find_locale_calls($&, 1)@ge;
	$body =~ s@/\*.*?\*/@find_locale_calls($&, 1)@ge;
	
	find_locale_calls($body, 0);
}

sub find_locale_calls {
	my $body       = $_[0];
	my $in_comment = $_[1];
	
	# Find calls to locale functions
	while ($body =~ /_(COMMENT_)?(MENU|HELP|TOOL|TOOLTIP|LABEL|BUTTON|TITLE|TYPE|ACTION|ERROR)_(?:([1-9])_)?\(\s*\"([^\"]+)\"/g) {
		$argc = $3 ? $3 : 0;
		if (defined($found{$2}{$4}{'argc'}) && $found{$2}{$4}{'argc'} != $argc) {
			print "ERROR: key _$2_($4) used with different arities";
		}
		$found{$2}{$4}{'opt'}  = defined($found{$2}{$4}{'opt'}) ? ($found{$2}{$4}{'opt'} && $in_comment) : $in_comment;
		$found{$2}{$4}{'argc'} = $argc;
	}
	# Also translated:
	while ($body =~ m@
	                 ( addPanel        \((?:[^,]+,){6} # gui/set/window.cpp
	                 )
	                 \s* _ \(\" ([^\"]+) \"\)
	                @xg
	      ) {
		($key = $2) =~ s/_/ /g;
		foreach $type ("MENU","HELP","TOOL","TOOLTIP") {
			$found{$type}{$key}{'opt'}  = $in_comment;
			$found{$type}{$key}{'argc'} = 0;
		}
	}
}

# Now process the items we found, print out a list in MSE reader format

my $result;
my $now = localtime;
$result .= "# This file contains the keys expected to be in MSE locales\n";
$result .= "# It was automatically generated by tools/locale/locale.pl\n";
$result .= "# Generated on " . $now . "\n\n";

my @types = sort keys %found;
foreach $type (@types) {
	$result .= lc($type) . ":\n";
	my @keys = sort keys %{$found{$type}};
	foreach $key (@keys) {
		$argc = $found{$type}{$key}{'argc'};
		$opt  = $found{$type}{$key}{'opt'} ? 'optional, ' : '';
		$result .= "\t$key:\t$opt$argc\n";
	}
}

# Write to file
open F, "> ../../src/resource/common/expected_locale_keys";
print F $result;
close F;

# and to stdout
#print $result;
