import { applyQueryProperty, DateColumn, IdBase, StringColumn } from 'nicot';
import { Index, SelectQueryBuilder } from 'typeorm';
import { Session } from 'koishi';

export class UserBase extends IdBase() {
  @Index()
  @StringColumn(128, { required: true, description: '用户' })
  userId: string;
  @Index()
  @DateColumn({ required: true, description: '时间' })
  date: Date;

  fromSession(session: Session) {
    this.userId = session.userId;
    this.date = new Date();
    return this;
  }

  applyQuery(qb: SelectQueryBuilder<UserBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryProperty(this, qb, entityName, 'userId', 'date');
  }
}
